/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrFedNonFedBudget20V20.RRFedNonFedBudget20Document;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.RRFedNonFedBudget20Document.RRFedNonFedBudget20;
import gov.grants.apply.forms.rrFedNonFedSubawardBudget20V20.RRFedNonFedSubawardBudget20Document;
import gov.grants.apply.forms.rrFedNonFedSubawardBudget20V20.RRFedNonFedSubawardBudget20Document.RRFedNonFedSubawardBudget20;
import gov.grants.apply.forms.rrFedNonFedSubawardBudget20V20.RRFedNonFedSubawardBudget20Document.RRFedNonFedSubawardBudget20.BudgetAttachments;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@FormGenerator("RRFedNonFedSubAwardBudget_2_0_V2_0Generator")
public class RRFedNonFedSubAwardBudget_2_0_V2_0Generator extends S2SAdobeFormAttachmentBaseGenerator<RRFedNonFedSubawardBudget20Document> implements S2SFormGeneratorPdfFillable<RRFedNonFedSubawardBudget20Document> {

    @Value("http://apply.grants.gov/forms/RR_FedNonFed_SubawardBudget_2_0-V2.0")
    private String namespace;

    @Value("RRFedNonFedSubAwardBudget_2_0_V2_0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_FedNonFedSubawardBudget_2_0-V2.0.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_FedNonFed_SubawardBudget_2_0-V2.0.pdf")
    private Resource pdfForm;

    @Value("172")
    private int sortIndex;

    private static final String RR_FED_NON_FED_BUDGET_20_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_FedNonFedBudget_2_0-V2.0";
    private static final String LOCAL_FED_NON_FED_NAME = "RR_FedNonFedBudget_2_0";


    private RRFedNonFedSubawardBudget20Document getRRFedNonFedSubawardBudgetDocument() throws S2SException {
        RRFedNonFedSubawardBudget20 rrSubawardBudget = RRFedNonFedSubawardBudget20.Factory.newInstance();
        rrSubawardBudget.setFormVersion(FormVersion.v2_0.getVersion());

        List<BudgetSubAwardsContract> budgetSubAwardsList = getBudgetSubAwards(pdDoc, RR_FED_NON_FED_BUDGET_20_NAMESPACE_URI,false);
        RRFedNonFedBudget20[] budgetList = new RRFedNonFedBudget20[budgetSubAwardsList.size()];

        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRFedNonFedBudget20 rrBudget = getRRFedNonFedBudget(budgetSubAwards).getRRFedNonFedBudget20();
            switch (attCount) {
                case 1:
                    rrSubawardBudget.setATT1(prepareAttName(budgetSubAwards));
                    budgetList[0] = rrBudget;
                    break;
                case 2:
                    rrSubawardBudget.setATT2(prepareAttName(budgetSubAwards));
                    budgetList[1] = rrBudget;
                    break;
                case 3:
                    rrSubawardBudget.setATT3(prepareAttName(budgetSubAwards));
                    budgetList[2] = rrBudget;
                    break;
                case 4:
                    rrSubawardBudget.setATT4(prepareAttName(budgetSubAwards));
                    budgetList[3] = rrBudget;
                    break;
                case 5:
                    rrSubawardBudget.setATT5(prepareAttName(budgetSubAwards));
                    budgetList[4] = rrBudget;
                    break;
                case 6:
                    rrSubawardBudget.setATT6(prepareAttName(budgetSubAwards));
                    budgetList[5] = rrBudget;
                    break;
                case 7:
                    rrSubawardBudget.setATT7(prepareAttName(budgetSubAwards));
                    budgetList[6] = rrBudget;
                    break;
                case 8:
                    rrSubawardBudget.setATT8(prepareAttName(budgetSubAwards));
                    budgetList[7] = rrBudget;
                    break;
                case 9:
                    rrSubawardBudget.setATT9(prepareAttName(budgetSubAwards));
                    budgetList[8] = rrBudget;
                    break;
                case 10:
                    rrSubawardBudget.setATT10(prepareAttName(budgetSubAwards));
                    budgetList[9] = rrBudget;
                    break;
            }
            addSubAwdAttachments(budgetSubAwards);
            attCount++;
            
        }
        BudgetAttachments budgetAttachments = BudgetAttachments.Factory.newInstance();
        budgetAttachments.setRRFedNonFedBudget20Array(budgetList);
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        RRFedNonFedSubawardBudget20Document rrSubawardBudgetDocument = RRFedNonFedSubawardBudget20Document.Factory.newInstance();
        rrSubawardBudgetDocument.setRRFedNonFedSubawardBudget20(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRFedNonFedBudget20Document getRRFedNonFedBudget(BudgetSubAwardsContract budgetSubAwards) throws S2SException  {
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        Document subAwdFormsDoc = stringToDom(subAwdXML);
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_FED_NON_FED_BUDGET_20_NAMESPACE_URI, LOCAL_FED_NON_FED_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null){
            if(subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }

        try {
            byte[] subAwdNodeBytes = docToBytes(nodeToDom(subAwdNode));
            return RRFedNonFedBudget20Document.Factory.parse(new ByteArrayInputStream(subAwdNodeBytes));
        } catch (XmlException|IOException e) {
            throw new RuntimeException(e);
        }

    }

    @Override
    public RRFedNonFedSubawardBudget20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        pdDoc=proposalDevelopmentDocument;
        return getRRFedNonFedSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(RRFedNonFedSubawardBudget20Document form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<RRFedNonFedSubawardBudget20Document> factory() {
        return RRFedNonFedSubawardBudget20Document.Factory;
    }
}
