/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.org.OrganizationIndirectcostContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMappingContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetCategoryMapService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ED524BudgetBaseGenerator<T extends XmlObject>
extends S2SBaseFormGenerator<T> {
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    protected S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="s2SBudgetCategoryMapService")
    protected S2SBudgetCategoryMapService s2SBudgetCategoryMapService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    protected S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    protected S2SCommonBudgetService s2SCommonBudgetService;
    protected static final String INDIRECT_COST_RATE_AGREEMENT_NONE = "NONE";
    protected static final String APPROVING_FEDERAL_AGENCY_OTHER = "Other";
    protected static final String APPROVING_FEDERAL_AGENCY_ED = "ED";
    protected static final String APPROVING_FEDERAL_AGENCY_OT = "OT";
    protected static final String RATE_CLASS_TYPE_EMPLOYEE_BENEFITS = "E";
    protected static final String RATE_CLASS_TYPE_VACATION = "V";
    protected static final String RATE_CLASS_TYPE_OTHER = "O";
    protected static final String TARGET_CATEGORY_CODE_SUBCONTRACT = "04";
    protected static final String TARGET_CATEGORY_CODE_PURCHASED_EQUIPMENT = "42";
    protected static final String TARGET_CATEGORY_CODE_MATERIOALS_AND_SUPPLIES = "43";
    protected static final String TARGET_CATEGORY_CODE_TRAVEL = "73";
    protected static final String TARGET_CATEGORY_CODE_FOREIGN_TRAVEL = "74";
    protected static final String TARGET_CATEGORY_CODE_PARTICIPANT_STIPENDS = "75";
    protected static final String TARGET_CATEGORY_TYPE_CODE_PERSONNEL = "P";
    protected static final int RATE_TYPE_ADMINISTRATIVE_SALARIES = 2;
    protected static final int RATE_TYPE_SUPPORT_STAFF_SALARIES = 3;
    protected ScaleTwoDecimal totalCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal totalIndirectCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal totalCostSharing = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal indirectCS = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal supplyCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal supplyCostCS = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal otherCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal otherCostCS = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal categoryCostFringe = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal categoryCostCSFringe = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal equipmentCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal equipmentCostCS = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal contractualCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal contractualCostCS = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal travelCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal travelCostCS = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal trainingCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal trainingCostCS = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal personnelCost = ScaleTwoDecimal.ZERO;
    protected ScaleTwoDecimal personnelCostCS = ScaleTwoDecimal.ZERO;
    protected static final String AGENCY_VALUE = "DHHS";
    protected static final String RESTIRCTED_QUESTION = " ";
    protected static final String DEFAULT_LEGAL_NAME = "NONE";
    private List<? extends BudgetCategoryMapContract> budgetCategoryMapListWithoutFilter;

    public List<? extends BudgetCategoryMapContract> getBudgetCategoryMapListWithoutFilter() {
        if (this.budgetCategoryMapListWithoutFilter == null) {
            this.budgetCategoryMapListWithoutFilter = this.s2SBudgetCategoryMapService.getBudgetCategoryMapList(new ArrayList<String>(), new ArrayList<String>());
        }
        return this.budgetCategoryMapListWithoutFilter;
    }

    protected void getTotalCosts(BudgetPeriodContract budgetPeriod) {
        this.totalCost = budgetPeriod.getTotalCost();
        this.totalDirectCost = budgetPeriod.getTotalDirectCost();
        this.totalIndirectCost = budgetPeriod.getTotalIndirectCost();
        this.totalCostSharing = budgetPeriod.getCostSharingAmount();
        this.getTrainingCosts(budgetPeriod);
        this.totalDirectCost = (ScaleTwoDecimal)this.totalDirectCost.subtract((AbstractDecimal)this.trainingCost);
    }

    protected void getIndirectCosts(BudgetPeriodContract budgetPeriod) {
        this.indirectCS = ScaleTwoDecimal.ZERO;
        for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetLineItemCalculatedAmountContract budgetLineItemCalAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                if (budgetLineItemCalAmount.getRateClass() == null || !RATE_CLASS_TYPE_OTHER.equals(budgetLineItemCalAmount.getRateClass().getRateClassType().getCode())) continue;
                this.indirectCS = (ScaleTwoDecimal)this.indirectCS.add((AbstractDecimal)budgetLineItemCalAmount.getCalculatedCostSharing());
            }
        }
    }

    protected void getSuppliesCosts(BudgetPeriodContract budgetPeriod) {
        this.supplyCost = ScaleTwoDecimal.ZERO;
        this.supplyCostCS = ScaleTwoDecimal.ZERO;
        for (BudgetCategoryMapContract categoryMap : this.getBudgetCategoryMapListWithoutFilter()) {
            if (!TARGET_CATEGORY_CODE_MATERIOALS_AND_SUPPLIES.equals(categoryMap.getTargetCategoryCode())) continue;
            for (BudgetCategoryMappingContract categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.supplyCost = (ScaleTwoDecimal)this.supplyCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    this.supplyCostCS = (ScaleTwoDecimal)this.supplyCostCS.add((AbstractDecimal)lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getOtherCosts(BudgetPeriodContract budgetPeriod) {
        this.categoryCostFringe = ScaleTwoDecimal.ZERO;
        this.categoryCostCSFringe = ScaleTwoDecimal.ZERO;
        this.otherCost = ScaleTwoDecimal.ZERO;
        this.otherCostCS = ScaleTwoDecimal.ZERO;
        for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetailsContract budgetPersonnelDetailsContract : budgetLineItem.getBudgetPersonnelDetailsList()) {
                for (BudgetPersonnelCalculatedAmountContract budgetPersonnelCalculatedAmount : budgetPersonnelDetailsContract.getBudgetPersonnelCalculatedAmounts()) {
                    if ((!budgetPersonnelCalculatedAmount.getRateClass().getRateClassType().getCode().equals(RATE_CLASS_TYPE_EMPLOYEE_BENEFITS) || Integer.parseInt(budgetPersonnelCalculatedAmount.getRateTypeCode()) == 3) && (!budgetPersonnelCalculatedAmount.getRateClass().getRateClassType().getCode().equals(RATE_CLASS_TYPE_VACATION) || Integer.parseInt(budgetPersonnelCalculatedAmount.getRateTypeCode()) == 2)) continue;
                    this.categoryCostFringe = (ScaleTwoDecimal)this.categoryCostFringe.add((AbstractDecimal)budgetPersonnelCalculatedAmount.getCalculatedCost());
                    this.categoryCostCSFringe = (ScaleTwoDecimal)this.categoryCostCSFringe.add((AbstractDecimal)budgetPersonnelCalculatedAmount.getCalculatedCostSharing());
                }
            }
        }
        ArrayList<String> filterTargetCategoryCodes = new ArrayList<String>();
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_SUBCONTRACT);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_PURCHASED_EQUIPMENT);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_MATERIOALS_AND_SUPPLIES);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_TRAVEL);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_FOREIGN_TRAVEL);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_PARTICIPANT_STIPENDS);
        List<? extends BudgetCategoryMapContract> budgetCategoryMapList = this.s2SBudgetCategoryMapService.getBudgetCategoryMapList(filterTargetCategoryCodes, new ArrayList<String>());
        for (BudgetCategoryMapContract budgetCategoryMapContract : budgetCategoryMapList) {
            if (!budgetCategoryMapContract.getCategoryType().equals(RATE_CLASS_TYPE_OTHER)) continue;
            for (BudgetCategoryMappingContract categoryMapping : budgetCategoryMapContract.getBudgetCategoryMappings()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(categoryMapping.getBudgetCategoryCode())) continue;
                    this.otherCost = (ScaleTwoDecimal)this.otherCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    this.otherCostCS = (ScaleTwoDecimal)this.otherCostCS.add((AbstractDecimal)lineItem.getCostSharingAmount());
                }
            }
        }
        for (BudgetLineItemContract budgetLineItemContract : budgetPeriod.getBudgetLineItems()) {
            for (BudgetLineItemCalculatedAmountContract budgetLineItemCalAmount : budgetLineItemContract.getBudgetLineItemCalculatedAmounts()) {
                if (budgetLineItemCalAmount.getRateClass().getRateClassType().getCode().equals(RATE_CLASS_TYPE_OTHER)) continue;
                this.otherCost = (ScaleTwoDecimal)this.otherCost.add((AbstractDecimal)budgetLineItemCalAmount.getCalculatedCost());
                this.otherCostCS = (ScaleTwoDecimal)this.otherCostCS.add((AbstractDecimal)budgetLineItemCalAmount.getCalculatedCostSharing());
            }
        }
        this.otherCost = (ScaleTwoDecimal)this.otherCost.subtract((AbstractDecimal)this.categoryCostFringe);
        this.otherCostCS = (ScaleTwoDecimal)this.otherCostCS.subtract((AbstractDecimal)this.categoryCostCSFringe);
    }

    protected void getEquipmentCosts(BudgetPeriodContract budgetPeriod) {
        this.equipmentCost = ScaleTwoDecimal.ZERO;
        this.equipmentCostCS = ScaleTwoDecimal.ZERO;
        for (BudgetCategoryMapContract categoryMap : this.getBudgetCategoryMapListWithoutFilter()) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_PURCHASED_EQUIPMENT)) continue;
            for (BudgetCategoryMappingContract categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.equipmentCost = (ScaleTwoDecimal)this.equipmentCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    this.equipmentCostCS = (ScaleTwoDecimal)this.equipmentCostCS.add((AbstractDecimal)lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getContractualCosts(BudgetPeriodContract budgetPeriod) {
        this.contractualCost = ScaleTwoDecimal.ZERO;
        this.contractualCostCS = ScaleTwoDecimal.ZERO;
        for (BudgetCategoryMapContract categoryMap : this.getBudgetCategoryMapListWithoutFilter()) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_SUBCONTRACT)) continue;
            for (BudgetCategoryMappingContract categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.contractualCost = (ScaleTwoDecimal)this.contractualCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    this.contractualCostCS = (ScaleTwoDecimal)this.contractualCostCS.add((AbstractDecimal)lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getTravelCosts(BudgetPeriodContract budgetPeriod) {
        this.travelCost = ScaleTwoDecimal.ZERO;
        this.travelCostCS = ScaleTwoDecimal.ZERO;
        for (BudgetCategoryMapContract categoryMap : this.getBudgetCategoryMapListWithoutFilter()) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_TRAVEL) && !categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_FOREIGN_TRAVEL)) continue;
            for (BudgetCategoryMappingContract categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.travelCost = (ScaleTwoDecimal)this.travelCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    this.travelCostCS = (ScaleTwoDecimal)this.travelCostCS.add((AbstractDecimal)lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getTrainingCosts(BudgetPeriodContract budgetPeriod) {
        this.trainingCost = ScaleTwoDecimal.ZERO;
        this.trainingCostCS = ScaleTwoDecimal.ZERO;
        for (BudgetCategoryMapContract categoryMap : this.getBudgetCategoryMapListWithoutFilter()) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_PARTICIPANT_STIPENDS)) continue;
            for (BudgetCategoryMappingContract categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.trainingCost = (ScaleTwoDecimal)this.trainingCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    this.trainingCostCS = (ScaleTwoDecimal)this.trainingCostCS.add((AbstractDecimal)lineItem.getCostSharingAmount());
                }
            }
        }
    }

    public void getPersonnelCosts(BudgetPeriodContract budgetPeriod) {
        this.personnelCost = ScaleTwoDecimal.ZERO;
        this.personnelCostCS = ScaleTwoDecimal.ZERO;
        for (BudgetCategoryMapContract categoryMap : this.getBudgetCategoryMapListWithoutFilter()) {
            if (!categoryMap.getCategoryType().equals(TARGET_CATEGORY_TYPE_CODE_PERSONNEL)) continue;
            for (BudgetCategoryMappingContract categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategory().getCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.personnelCost = (ScaleTwoDecimal)this.personnelCost.add((AbstractDecimal)lineItem.getLineItemCost());
                    this.personnelCostCS = (ScaleTwoDecimal)this.personnelCostCS.add((AbstractDecimal)lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected String getAgencyName() {
        ArrayList organizationIdcs;
        String agencyName = "";
        List list = organizationIdcs = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization() != null ? this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationIdcs() : new ArrayList();
        if (organizationIdcs.isEmpty()) {
            agencyName = AGENCY_VALUE;
        } else {
            OrganizationIndirectcostContract idc = (OrganizationIndirectcostContract)organizationIdcs.get(organizationIdcs.size() - 1);
            if (idc.getFederalApprovingAgency().equalsIgnoreCase(APPROVING_FEDERAL_AGENCY_ED)) {
                agencyName = APPROVING_FEDERAL_AGENCY_ED;
            } else if (idc.getFederalApprovingAgency().equalsIgnoreCase(APPROVING_FEDERAL_AGENCY_OT)) {
                agencyName = idc.getFederalApprovingAgencyName();
            }
        }
        return agencyName;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public S2SBudgetCategoryMapService getS2SBudgetCategoryMapService() {
        return this.s2SBudgetCategoryMapService;
    }

    public void setS2SBudgetCategoryMapService(S2SBudgetCategoryMapService s2SBudgetCategoryMapService) {
        this.s2SBudgetCategoryMapService = s2SBudgetCategoryMapService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }
}

