/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phsFellowshipSupplemental11V11.CitizenshipDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental11V11.DegreeTypeDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental11V11.FieldOfTrainingDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental11V11.PHSFellowshipSupplemental11Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireQuestionContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398FellowshipSupplementalBaseGenerator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398FellowshipSupplementalV1_1Generator")
public class PHS398FellowshipSupplementalV1_1Generator
extends PHS398FellowshipSupplementalBaseGenerator<PHSFellowshipSupplemental11Document> {
    private static final int DEGREE_TYPE_SOUGHT = 15;
    private static final int OTHER_DBOTH = 20;
    private static final ScaleTwoDecimal POINT_ZERO_ONE = new ScaleTwoDecimal(0.01);
    @Value(value="http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_1_1-V1.1")
    private String namespace;
    @Value(value="PHS_Fellowship_Supplemental_1_1-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS_fellowship_supplemental-V1.1.xsl")
    private List<Resource> stylesheets;
    @Value(value="210")
    private int sortIndex;

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11 getPHSFellowshipSupplemental11() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11 phsFellowshipSupplemental = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Factory.newInstance();
        phsFellowshipSupplemental.setFormVersion(FormVersion.v1_1.getVersion());
        phsFellowshipSupplemental.setApplicationType(this.getApplicationType());
        phsFellowshipSupplemental.setAppendix(this.getAppendix());
        phsFellowshipSupplemental.setAdditionalInformation(this.getAdditionalInformation());
        phsFellowshipSupplemental.setResearchTrainingPlan(this.getResearchTrainingPlan());
        phsFellowshipSupplemental.setBudget(this.getBudget());
        return phsFellowshipSupplemental;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget getBudget() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget budget = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.Factory.newInstance();
        HashMap<Integer, String> budgetMap = new HashMap<Integer, String>();
        for (AnswerContract questionnaireAnswer : this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            if (answer == null) continue;
            switch (this.getQuestionAnswerService().findQuestionById(questionnaireAnswer.getQuestionId()).getQuestionSeqId()) {
                case 36: {
                    budgetMap.put(36, answer);
                    break;
                }
                case 37: {
                    budgetMap.put(37, answer);
                    break;
                }
                case 41: {
                    budgetMap.put(41, answer);
                    break;
                }
                case 38: {
                    budgetMap.put(38, answer);
                    break;
                }
                case 51: {
                    budgetMap.put(51, answer);
                    break;
                }
                case 40: {
                    budgetMap.put(40, answer);
                    break;
                }
                case 50: {
                    budgetMap.put(50, answer);
                    break;
                }
                case 48: {
                    budgetMap.put(48, answer);
                    break;
                }
                case 47: {
                    budgetMap.put(47, answer);
                    break;
                }
            }
        }
        budget.setTuitionAndFeesRequested(YesNoDataType.N_NO);
        if (this.getInstitutionalBaseSalary(budgetMap) != null) {
            budget.setInstitutionalBaseSalary(this.getInstitutionalBaseSalary(budgetMap));
        }
        this.getFederalStipendRequested(budget);
        if (this.getSupplementationFromOtherSources(budgetMap) != null) {
            budget.setSupplementationFromOtherSources(this.getSupplementationFromOtherSources(budgetMap));
        }
        this.setTutionRequestedYears(budget);
        return budget;
    }

    private void setTutionRequestedYears(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget budget) {
        ProposalDevelopmentBudgetExtContract budgetEx = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (budgetEx == null) {
            return;
        }
        ScaleTwoDecimal tutionTotal = ScaleTwoDecimal.ZERO;
        for (BudgetPeriodContract budgetPeriod : budgetEx.getBudgetPeriods()) {
            ScaleTwoDecimal tution = ScaleTwoDecimal.ZERO;
            for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("TUITION_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                tution = (ScaleTwoDecimal)tution.add((AbstractDecimal)budgetLineItem.getLineItemCost());
            }
            tutionTotal = (ScaleTwoDecimal)tutionTotal.add((AbstractDecimal)tution);
            switch (budgetPeriod.getBudgetPeriod()) {
                case 1: {
                    budget.setTuitionRequestedYear1(tution.bigDecimalValue());
                    break;
                }
                case 2: {
                    budget.setTuitionRequestedYear2(tution.bigDecimalValue());
                    break;
                }
                case 3: {
                    budget.setTuitionRequestedYear3(tution.bigDecimalValue());
                    break;
                }
                case 4: {
                    budget.setTuitionRequestedYear4(tution.bigDecimalValue());
                    break;
                }
                case 5: {
                    budget.setTuitionRequestedYear5(tution.bigDecimalValue());
                    break;
                }
                case 6: {
                    budget.setTuitionRequestedYear6(tution.bigDecimalValue());
                    break;
                }
            }
        }
        budget.setTuitionRequestedTotal(tutionTotal.bigDecimalValue());
        if (!tutionTotal.equals((Object)ScaleTwoDecimal.ZERO)) {
            budget.setTuitionAndFeesRequested(YesNoDataType.Y_YES);
        }
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.SupplementationFromOtherSources getSupplementationFromOtherSources(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.SupplementationFromOtherSources supplementationFromOtherSources = null;
        if (budgetMap.get(37) != null && budgetMap.get(37).equals(YnqConstant.YES.code())) {
            supplementationFromOtherSources = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.SupplementationFromOtherSources)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.SupplementationFromOtherSources.Factory.newInstance();
            if (budgetMap.get(41) != null) {
                supplementationFromOtherSources.setSource(budgetMap.get(41));
            }
            if (budgetMap.get(38) != null) {
                supplementationFromOtherSources.setAmount(new BigDecimal(budgetMap.get(38)));
            } else {
                supplementationFromOtherSources.setAmount(null);
            }
            if (budgetMap.get(51) != null) {
                supplementationFromOtherSources.setNumberOfMonths(new BigDecimal(budgetMap.get(51)));
            }
            if (budgetMap.get(40) != null) {
                supplementationFromOtherSources.setType(budgetMap.get(40));
            }
        }
        return supplementationFromOtherSources;
    }

    protected void getFederalStipendRequested(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget budget) {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.FederalStipendRequested federalStipendRequested = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.FederalStipendRequested)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.FederalStipendRequested.Factory.newInstance();
        ProposalDevelopmentBudgetExtContract pBudget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (pBudget != null) {
            ScaleTwoDecimal sumOfLineItemCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal numberOfMonths = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : pBudget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                for (BudgetLineItemContract budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!this.getCostElementsByParam("STIPEND_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                    sumOfLineItemCost = (ScaleTwoDecimal)sumOfLineItemCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                    if (CollectionUtils.isNotEmpty((Collection)budgetLineItem.getBudgetPersonnelDetailsList())) {
                        for (BudgetPersonnelDetailsContract details : budgetLineItem.getBudgetPersonnelDetailsList()) {
                            ScaleTwoDecimal detailsNumberOfMonths = details.getPercentEffort() != null ? (ScaleTwoDecimal)this.getNumberOfMonths(details.getStartDate(), details.getEndDate()).multiply((AbstractDecimal)((ScaleTwoDecimal)details.getPercentEffort().multiply((AbstractDecimal)POINT_ZERO_ONE))) : this.getNumberOfMonths(details.getStartDate(), details.getEndDate());
                            numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)detailsNumberOfMonths);
                        }
                        continue;
                    }
                    numberOfMonths = (ScaleTwoDecimal)numberOfMonths.add((AbstractDecimal)this.getNumberOfMonths(budgetLineItem.getStartDate(), budgetLineItem.getEndDate()));
                }
            }
            federalStipendRequested.setAmount(sumOfLineItemCost.bigDecimalValue());
            federalStipendRequested.setNumberOfMonths(numberOfMonths.bigDecimalValue());
            budget.setFederalStipendRequested(federalStipendRequested);
        }
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary getInstitutionalBaseSalary(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary institutionalBaseSalary = null;
        if (budgetMap.get(36) != null && budgetMap.get(36).equals(YnqConstant.YES.code())) {
            institutionalBaseSalary = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary.Factory.newInstance();
            if (budgetMap.get(47) != null) {
                institutionalBaseSalary.setAmount(new BigDecimal(budgetMap.get(47)));
            } else {
                institutionalBaseSalary.setAmount(null);
            }
            if (budgetMap.get(48) != null) {
                institutionalBaseSalary.setAcademicPeriod(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary.AcademicPeriod.Enum.forString(budgetMap.get(48)));
            }
            if (budgetMap.get(50) != null) {
                institutionalBaseSalary.setNumberOfMonths(new BigDecimal(budgetMap.get(50)));
            }
        }
        return institutionalBaseSalary;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan getResearchTrainingPlan() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.Factory.newInstance();
        this.setHumanSubjectInvolvedAndVertebrateAnimalUsed(researchTrainingPlan);
        this.setQuestionnareAnswerForResearchTrainingPlan(researchTrainingPlan);
        this.setNarrativeDataForResearchTrainingPlan(researchTrainingPlan);
        return researchTrainingPlan;
    }

    private void setNarrativeDataForResearchTrainingPlan(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan) {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SpecificAims specificAims = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SpecificAims)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SpecificAims.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResearchStrategy researchStrategy = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResearchStrategy)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResearchStrategy.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.RespectiveContributions respectiveContributions = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.RespectiveContributions)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.RespectiveContributions.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectionOfSponsorAndInstitution selectionOfSponsorAndInstitution = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectionOfSponsorAndInstitution)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectionOfSponsorAndInstitution.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResponsibleConductOfResearch responsibleConductOfResearch = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResponsibleConductOfResearch)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResponsibleConductOfResearch.Factory.newInstance();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                    case 97: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.IntroductionToApplication introductionToApplication = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.IntroductionToApplication)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.IntroductionToApplication.Factory.newInstance();
                        introductionToApplication.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setIntroductionToApplication(introductionToApplication);
                        break;
                    }
                    case 98: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        specificAims.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 102: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionEnrollmentReport inclusionEnrollmentReport = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionEnrollmentReport)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionEnrollmentReport.Factory.newInstance();
                        inclusionEnrollmentReport.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionEnrollmentReport(inclusionEnrollmentReport);
                        break;
                    }
                    case 103: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProgressReportPublicationList)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProgressReportPublicationList.Factory.newInstance();
                        progressReportPublicationList.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProgressReportPublicationList(progressReportPublicationList);
                        break;
                    }
                    case 104: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProtectionOfHumanSubjects protectionOfHumanSubjects = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProtectionOfHumanSubjects)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProtectionOfHumanSubjects.Factory.newInstance();
                        protectionOfHumanSubjects.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
                        break;
                    }
                    case 105: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfWomenAndMinorities)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfWomenAndMinorities.Factory.newInstance();
                        inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
                        break;
                    }
                    case 106: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.TargetedPlannedEnrollment tarPlannedEnrollmentTable = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.TargetedPlannedEnrollment)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.TargetedPlannedEnrollment.Factory.newInstance();
                        tarPlannedEnrollmentTable.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setTargetedPlannedEnrollment(tarPlannedEnrollmentTable);
                        break;
                    }
                    case 107: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfChildren inclusionOfChildren = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfChildren)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfChildren.Factory.newInstance();
                        inclusionOfChildren.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfChildren(inclusionOfChildren);
                        break;
                    }
                    case 108: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.VertebrateAnimals)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.VertebrateAnimals.Factory.newInstance();
                        vertebrateAnimals.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setVertebrateAnimals(vertebrateAnimals);
                        break;
                    }
                    case 109: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectAgentResearch selectAgentResearch = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectAgentResearch)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectAgentResearch.Factory.newInstance();
                        selectAgentResearch.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSelectAgentResearch(selectAgentResearch);
                        break;
                    }
                    case 110: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResourceSharingPlan)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResourceSharingPlan.Factory.newInstance();
                        resourceSharingPlan.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResourceSharingPlan(resourceSharingPlan);
                        break;
                    }
                    case 88: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        respectiveContributions.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 89: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        selectionOfSponsorAndInstitution.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 90: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        responsibleConductOfResearch.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 127: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        researchStrategy.setAttFile(attachedFileDataType);
                        break;
                    }
                }
            }
        }
        researchTrainingPlan.setSpecificAims(specificAims);
        researchTrainingPlan.setResearchStrategy(researchStrategy);
        researchTrainingPlan.setRespectiveContributions(respectiveContributions);
        researchTrainingPlan.setSelectionOfSponsorAndInstitution(selectionOfSponsorAndInstitution);
        researchTrainingPlan.setResponsibleConductOfResearch(responsibleConductOfResearch);
    }

    private void setQuestionnareAnswerForResearchTrainingPlan(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setHumanSubjectsIndefinite(YesNoDataType.N_NO);
        researchTrainingPlan.setVertebrateAnimalsIndefinite(YesNoDataType.N_NO);
        researchTrainingPlan.setHumanSubjectsIndefinite(YesNoDataType.N_NO);
        researchTrainingPlan.setClinicalTrial(YesNoDataType.N_NO);
        researchTrainingPlan.setPhase3ClinicalTrial(YesNoDataType.N_NO);
        for (AnswerContract questionnaireAnswer : this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            if (answer == null) continue;
            switch (this.getQuestionAnswerService().findQuestionById(questionnaireAnswer.getQuestionId()).getQuestionSeqId()) {
                case 1: {
                    researchTrainingPlan.setHumanSubjectsIndefinite(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 4: {
                    researchTrainingPlan.setVertebrateAnimalsIndefinite(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 2: {
                    researchTrainingPlan.setClinicalTrial(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 3: {
                    researchTrainingPlan.setPhase3ClinicalTrial(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
            }
        }
    }

    private void setHumanSubjectInvolvedAndVertebrateAnimalUsed(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.N_NO);
        researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.N_NO);
        for (ProposalSpecialReviewContract propSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if ("1".equals(propSpecialReview.getSpecialReviewType().getCode())) {
                researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.Y_YES);
                continue;
            }
            if (!"2".equals(propSpecialReview.getSpecialReviewType().getCode())) continue;
            researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.Y_YES);
        }
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation getAdditionalInformation() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation additionalInformation = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.Factory.newInstance();
        additionalInformation.setCitizenship(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL);
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.StemCells stemCells = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.StemCells)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.StemCells.Factory.newInstance();
        stemCells.setIsHumanStemCellsInvolved(YesNoDataType.N_NO);
        stemCells.setStemCellsIndicator(YesNoDataType.N_NO);
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.GraduateDegreeSought graduateDegreeSought = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.GraduateDegreeSought)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.GraduateDegreeSought.Factory.newInstance();
        ProposalPersonContract principalInvestigator = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        ArrayList<String> cellLinesList = new ArrayList<String>(Arrays.asList(stemCells.getCellLinesArray()));
        for (Object proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!proposalPerson.isPrincipalInvestigator()) continue;
            CitizenshipType citizenShip = this.s2SProposalPersonService.getCitizenship((ProposalPersonContract)proposalPerson);
            if (citizenShip != null && StringUtils.isNotBlank((CharSequence)citizenShip.getCitizenShip())) {
                if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA.toString())) {
                    additionalInformation.setCitizenship(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA);
                    continue;
                }
                if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S.toString())) {
                    additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S);
                    continue;
                }
                if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL.toString())) {
                    additionalInformation.setCitizenship(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL);
                    continue;
                }
                if (!citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING.toString())) continue;
                additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING);
                continue;
            }
            additionalInformation.setCitizenship(null);
        }
        if (principalInvestigator != null && principalInvestigator.getMobilePhoneNumber() != null) {
            additionalInformation.setAlernatePhoneNumber(principalInvestigator.getMobilePhoneNumber());
        }
        List answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        for (AnswerHeaderContract answerHeader : answerHeaders) {
            for (AnswerContract questionnaireAnswer : answerHeader.getAnswers()) {
                String answer = questionnaireAnswer.getAnswer();
                Integer seqId = this.getQuestionAnswerService().findQuestionById(questionnaireAnswer.getQuestionId()).getQuestionSeqId();
                if (seqId.equals(7)) {
                    List<AnswerContract> answerList = this.getAnswers(questionnaireAnswer.getQuestionnaireQuestionsId(), answerHeader);
                    for (AnswerContract questionnaireAnswerBO : answerList) {
                        String questionnaireSubAnswer = questionnaireAnswerBO.getAnswer();
                        if (questionnaireSubAnswer == null) continue;
                        cellLinesList.add(questionnaireSubAnswer);
                        stemCells.addCellLines(questionnaireSubAnswer);
                    }
                }
                if (answer == null) continue;
                switch (seqId) {
                    case 22: 
                    case 23: {
                        if (answer.toUpperCase().equals("SUB CATEGORY NOT FOUND")) break;
                        FieldOfTrainingDataType.Enum e = FieldOfTrainingDataType.Enum.forString(answer);
                        additionalInformation.setFieldOfTraining(e);
                        break;
                    }
                    case 24: {
                        additionalInformation.setCurrentPriorNRSASupportIndicator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        break;
                    }
                    case 28: {
                        additionalInformation.setChangeOfInstitution(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        break;
                    }
                    case 29: {
                        additionalInformation.setFormerInstitution(answer);
                        break;
                    }
                    case 5: {
                        stemCells.setIsHumanStemCellsInvolved(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        break;
                    }
                    case 6: {
                        stemCells.setStemCellsIndicator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        break;
                    }
                    case 15: {
                        graduateDegreeSought.setDegreeType(DegreeTypeDataType.Enum.forString(answer));
                        break;
                    }
                    case 35: {
                        graduateDegreeSought.setDegreeDate(answer.substring(6, 10) + "-" + answer.substring(0, 2));
                        break;
                    }
                    case 16: {
                        graduateDegreeSought.setOtherDegreeTypeText(answer);
                        break;
                    }
                    case 17: {
                        graduateDegreeSought.setOtherDegreeTypeText(answer);
                        break;
                    }
                    case 18: {
                        graduateDegreeSought.setDegreeType(DegreeTypeDataType.DDOT_OTHER_DOCTOR_OF_MEDICAL_DENTISTRY);
                        graduateDegreeSought.setOtherDegreeTypeText(answer);
                        break;
                    }
                    case 19: {
                        graduateDegreeSought.setDegreeType(DegreeTypeDataType.VDOT_OTHER_DOCTOR_OF_VETERINARY_MEDICINE);
                        graduateDegreeSought.setOtherDegreeTypeText(answer);
                        break;
                    }
                    case 20: {
                        graduateDegreeSought.setDegreeType(DegreeTypeDataType.DBOTH_OTHER_DOUBLE_DEGREE_PROGRAM);
                        graduateDegreeSought.setOtherDegreeTypeText(answer);
                        break;
                    }
                    case 21: {
                        graduateDegreeSought.setDegreeType(DegreeTypeDataType.MDOT_OTHER_DOCTOR_OF_MEDICINE);
                        graduateDegreeSought.setOtherDegreeTypeText(answer);
                        break;
                    }
                }
            }
        }
        additionalInformation.setStemCells(stemCells);
        if (graduateDegreeSought.getDegreeType() != null) {
            additionalInformation.setGraduateDegreeSought(graduateDegreeSought);
        }
        additionalInformation.setCurrentPriorNRSASupportArray(this.getCurrentPriorNRSASupportArray());
        additionalInformation.setConcurrentSupport(YesNoDataType.N_NO);
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.FellowshipTrainingAndCareerGoals fellowshipTrainingAndCareerGoals = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.FellowshipTrainingAndCareerGoals)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.FellowshipTrainingAndCareerGoals.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ActivitiesPlannedUnderThisAward activitiesPlannedUnderThisAward = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ActivitiesPlannedUnderThisAward)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ActivitiesPlannedUnderThisAward.Factory.newInstance();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                    case 91: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ConcurrentSupportDescription)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ConcurrentSupportDescription.Factory.newInstance();
                        concurrentSupportDescription.setAttFile(attachedFileDataType);
                        additionalInformation.setConcurrentSupport(YesNoDataType.Y_YES);
                        additionalInformation.setConcurrentSupportDescription(concurrentSupportDescription);
                        break;
                    }
                    case 92: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        fellowshipTrainingAndCareerGoals.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 93: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.DissertationAndResearchExperience dissertationAndResearchExperience = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.DissertationAndResearchExperience)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.DissertationAndResearchExperience.Factory.newInstance();
                        dissertationAndResearchExperience.setAttFile(attachedFileDataType);
                        additionalInformation.setDissertationAndResearchExperience(dissertationAndResearchExperience);
                        break;
                    }
                    case 94: {
                        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        activitiesPlannedUnderThisAward.setAttFile(attachedFileDataType);
                        break;
                    }
                }
            }
        }
        additionalInformation.setFellowshipTrainingAndCareerGoals(fellowshipTrainingAndCareerGoals);
        additionalInformation.setActivitiesPlannedUnderThisAward(activitiesPlannedUnderThisAward);
        return additionalInformation;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport[] getCurrentPriorNRSASupportArray() {
        ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport> currentPriorNRSASupportList = new ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport>();
        ArrayList<AnswerContract> answerList = new ArrayList<AnswerContract>();
        String nsrSupport = null;
        List<AnswerHeaderContract> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        for (AnswerHeaderContract answerHeader : answers) {
            QuestionnaireContract questionnaire = this.questionAnswerService.findQuestionnaireById(answerHeader.getQuestionnaireId());
            List questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            for (Object questionnaireQuestion : questionnaireQuestions) {
                AnswerContract answerBO = this.getAnswer((QuestionnaireQuestionContract)questionnaireQuestion, answerHeader);
                String answer = answerBO != null ? answerBO.getAnswer() : null;
                QuestionContract question = questionnaireQuestion.getQuestion();
                if (answer == null) continue;
                int questionSeqId = question.getQuestionSeqId();
                switch (questionSeqId) {
                    case 27: 
                    case 32: 
                    case 33: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 49: {
                        if (questionSeqId == 43) {
                            if (!answer.equals("N")) break;
                            answer = "Unknown";
                            questionSeqId = 44;
                        }
                        if (questionSeqId == 49) {
                            if (!answer.equals("N")) break;
                            answer = "Unknown";
                            questionSeqId = 45;
                        }
                        if (questionSeqId == 46) {
                            if (!answer.equals("N")) break;
                            answer = "Unknown";
                            questionSeqId = 27;
                        }
                        InternalAnswer quesAnswer = new InternalAnswer();
                        quesAnswer.setAnswer(answer);
                        quesAnswer.setQuestionSeqId(questionSeqId);
                        answerList.add(quesAnswer);
                        break;
                    }
                    case 24: {
                        nsrSupport = answer.equals(YnqConstant.YES.code()) ? "Yes" : "No";
                        break;
                    }
                }
            }
        }
        answerList.sort(Comparator.comparing(AnswerContract::getQuestionSeqId));
        ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum> levelList = new ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum>();
        ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum> typeList = new ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum>();
        ArrayList<Calendar> startDateList = new ArrayList<Calendar>();
        ArrayList<Calendar> endDateList = new ArrayList<Calendar>();
        ArrayList<String> grantNumberList = new ArrayList<String>();
        for (AnswerContract questionnaireAnswer : answerList) {
            if (nsrSupport == null || !nsrSupport.equals("Yes")) continue;
            if (questionnaireAnswer.getQuestionSeqId() == 32) {
                levelList.add(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum.forString(questionnaireAnswer.getAnswer()));
            }
            if (questionnaireAnswer.getQuestionSeqId() == 33) {
                typeList.add(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum.forString(questionnaireAnswer.getAnswer()));
            }
            if (questionnaireAnswer.getQuestionSeqId() == 44) {
                if (questionnaireAnswer.getAnswer().equals("Unknown")) {
                    startDateList.add(null);
                } else {
                    startDateList.add(this.s2SDateTimeService.convertDateStringToCalendar(questionnaireAnswer.getAnswer()));
                }
            }
            if (questionnaireAnswer.getQuestionSeqId() == 45) {
                if (questionnaireAnswer.getAnswer().equals("Unknown")) {
                    endDateList.add(null);
                } else {
                    endDateList.add(this.s2SDateTimeService.convertDateStringToCalendar(questionnaireAnswer.getAnswer()));
                }
            }
            if (questionnaireAnswer.getQuestionSeqId() != 27) continue;
            grantNumberList.add(questionnaireAnswer.getAnswer());
        }
        for (int index = 0; levelList.size() > index; ++index) {
            PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport currentPriorNRSASupport = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Factory.newInstance();
            currentPriorNRSASupport.setLevel((PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum)((Object)levelList.get(index)));
            currentPriorNRSASupport.setType((PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum)((Object)typeList.get(index)));
            if (!startDateList.isEmpty() && startDateList.get(index) != null) {
                currentPriorNRSASupport.setStartDate((Calendar)startDateList.get(index));
            }
            if (!endDateList.isEmpty() && endDateList.get(index) != null) {
                currentPriorNRSASupport.setEndDate((Calendar)endDateList.get(index));
            }
            currentPriorNRSASupport.setGrantNumber((String)grantNumberList.get(index));
            currentPriorNRSASupportList.add(currentPriorNRSASupport);
        }
        return currentPriorNRSASupportList.toArray(new PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport[0]);
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType getApplicationType() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType applicationType = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType)PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.Factory.newInstance();
        applicationType.setTypeOfApplication(this.getTypeOfApplication());
        return applicationType;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.Enum getTypeOfApplication() {
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.Enum typeOfApplication = null;
        if (proposalTypeCode != null) {
            if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.NEW;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_CONTINUATION").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.CONTINUATION;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.REVISION;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.RENEWAL;
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION").contains(proposalTypeCode)) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.RESUBMISSION;
            }
        }
        return typeOfApplication;
    }

    @Override
    public PHSFellowshipSupplemental11Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11 phsFellowshipSupplemental = this.getPHSFellowshipSupplemental11();
        PHSFellowshipSupplemental11Document phsFellowshipSupplementalDocument = (PHSFellowshipSupplemental11Document)PHSFellowshipSupplemental11Document.Factory.newInstance();
        phsFellowshipSupplementalDocument.setPHSFellowshipSupplemental11(phsFellowshipSupplemental);
        return phsFellowshipSupplementalDocument;
    }

    @Override
    public DocumentFactory<PHSFellowshipSupplemental11Document> factory() {
        return PHSFellowshipSupplemental11Document.Factory;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    private static class InternalAnswer
    implements AnswerContract {
        private Long id;
        private Integer questionNumber;
        private Integer answerNumber;
        private String answer;
        private Long answerHeaderId;
        private Long questionId;
        private Integer questionSeqId;
        private Long questionnaireQuestionsId;
        private List<InternalAnswer> parentAnswers;

        private InternalAnswer() {
        }

        public Long getId() {
            return this.id;
        }

        public Integer getQuestionNumber() {
            return this.questionNumber;
        }

        public Integer getAnswerNumber() {
            return this.answerNumber;
        }

        public String getAnswer() {
            return this.answer;
        }

        public Long getAnswerHeaderId() {
            return this.answerHeaderId;
        }

        public Long getQuestionId() {
            return this.questionId;
        }

        public Integer getQuestionSeqId() {
            return this.questionSeqId;
        }

        public void setQuestionSeqId(Integer questionSeqId) {
            this.questionSeqId = questionSeqId;
        }

        public Long getQuestionnaireQuestionsId() {
            return this.questionnaireQuestionsId;
        }

        public List<InternalAnswer> getParentAnswers() {
            return this.parentAnswers;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setQuestionNumber(Integer questionNumber) {
            this.questionNumber = questionNumber;
        }

        public void setAnswerNumber(Integer answerNumber) {
            this.answerNumber = answerNumber;
        }

        public void setAnswer(String answer) {
            this.answer = answer;
        }

        public void setAnswerHeaderId(Long answerHeaderId) {
            this.answerHeaderId = answerHeaderId;
        }

        public void setQuestionId(Long questionId) {
            this.questionId = questionId;
        }

        public void setQuestionnaireQuestionsId(Long questionnaireQuestionsId) {
            this.questionnaireQuestionsId = questionnaireQuestionsId;
        }

        public void setParentAnswers(List<InternalAnswer> parentAnswers) {
            this.parentAnswers = parentAnswers;
        }
    }
}

