/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.s2sgen.api.budget.S2SKeyPersonDto;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetValidationService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class RRFedNonFedBudgetBaseGenerator<T extends XmlObject>
extends S2SBaseFormGenerator<T>
implements S2SFormGeneratorPdfFillable<T> {
    public static final String OTHERPERSONNEL_POSTDOC = "PostDoc";
    public static final String OTHERPERSONNEL_GRADUATE = "Grad";
    public static final String OTHERPERSONNEL_UNDERGRADUATE = "UnderGrad";
    public static final String OTHERPERSONNEL_SECRETARIAL = "Sec";
    public static final String OTHERCOST_DESCRIPTION = "Other";
    protected static final String NID_PD_PI = "PD/PI";
    public static final int BUDGET_JUSTIFICATION_ATTACHMENT = 131;
    protected static final int OTHERPERSONNEL_MAX_ALLOWED = 6;
    protected static final int ARRAY_LIMIT_IN_SCHEMA = 4;
    @Autowired
    @Qualifier(value="s2SBudgetInfoService")
    protected S2SBudgetInfoService s2sBudgetInfoService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    protected S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    protected S2SCommonBudgetService s2SCommonBudgetService;
    @Autowired
    @Qualifier(value="s2SBudgetValidationService")
    protected S2SBudgetValidationService s2SBudgetValidationService;

    protected Boolean hasPersonnelBudget(S2SKeyPersonDto keyPerson, int period) {
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        List budgetLineItemList = ((BudgetPeriodContract)budget.getBudgetPeriods().get(period - 1)).getBudgetLineItems();
        for (BudgetLineItemContract budgetLineItem : budgetLineItemList) {
            for (BudgetPersonnelDetailsContract budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (budgetPersonnelDetails.getPersonId().equals(keyPerson.getPersonId())) {
                    return true;
                }
                if (keyPerson.getRolodexId() == null || !budgetPersonnelDetails.getPersonId().equals(keyPerson.getRolodexId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validateBudgetForForm(ProposalDevelopmentDocumentContract pdDoc) {
        List<AuditError> errors = this.s2SBudgetValidationService.validateBudgetForForm(pdDoc, this.getFormName());
        this.getAuditErrors().addAll(errors);
        return errors.isEmpty();
    }

    public S2SBudgetInfoService getS2sBudgetInfoService() {
        return this.s2sBudgetInfoService;
    }

    public void setS2sBudgetInfoService(S2SBudgetInfoService s2sBudgetInfoService) {
        this.s2sBudgetInfoService = s2sBudgetInfoService;
    }

    public S2SBudgetValidationService getS2SBudgetValidationService() {
        return this.s2SBudgetValidationService;
    }

    public void setS2SBudgetValidationService(S2SBudgetValidationService s2SBudgetValidationService) {
        this.s2SBudgetValidationService = s2SBudgetValidationService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }
}

