/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrKeyPersonExpandedV11.PersonProfileDataType;
import gov.grants.apply.forms.rrKeyPersonExpandedV11.ProjectRoleDataType;
import gov.grants.apply.forms.rrKeyPersonExpandedV11.RRKeyPersonExpandedDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.ProposalPersonComparator;
import org.kuali.coeus.s2sgen.impl.generate.support.RRKeyPersonExpandedBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRKeyPersonExpandedV1_1Generator")
public class RRKeyPersonExpandedV1_1Generator
extends RRKeyPersonExpandedBaseGenerator<RRKeyPersonExpandedDocument> {
    @Value(value="http://apply.grants.gov/forms/RR_KeyPersonExpanded-V1.1")
    private String namespace;
    @Value(value="RR_KeyPersonExpanded-V1-1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_KeyPersonExpanded-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="155")
    private int sortIndex;

    private RRKeyPersonExpandedDocument getRRKeyPersonExpanded() {
        AttachedFileDataType attachedFileDataType;
        RRKeyPersonExpandedDocument rrKeyPersonExpandedDocument = (RRKeyPersonExpandedDocument)RRKeyPersonExpandedDocument.Factory.newInstance();
        RRKeyPersonExpandedDocument.RRKeyPersonExpanded rrKeyPersonExpanded = (RRKeyPersonExpandedDocument.RRKeyPersonExpanded)RRKeyPersonExpandedDocument.RRKeyPersonExpanded.Factory.newInstance();
        rrKeyPersonExpanded.setFormVersion(FormVersion.v1_1.getVersion());
        rrKeyPersonExpanded.setPDPI(this.getPersonProfilePI());
        rrKeyPersonExpanded.setKeyPersonArray(this.getPersonProfileKeyPerson());
        this.saveKeyPersonAttachmentsToProposal();
        RRKeyPersonExpandedDocument.RRKeyPersonExpanded.BioSketchsAttached bioSketchAttached = (RRKeyPersonExpandedDocument.RRKeyPersonExpanded.BioSketchsAttached)RRKeyPersonExpandedDocument.RRKeyPersonExpanded.BioSketchsAttached.Factory.newInstance();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 16 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            bioSketchAttached.setBioSketchAttached(attachedFileDataType);
            rrKeyPersonExpanded.setBioSketchsAttached(bioSketchAttached);
            break;
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 17 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            RRKeyPersonExpandedDocument.RRKeyPersonExpanded.SupportsAttached supportsAttached = (RRKeyPersonExpandedDocument.RRKeyPersonExpanded.SupportsAttached)RRKeyPersonExpandedDocument.RRKeyPersonExpanded.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(attachedFileDataType);
            rrKeyPersonExpanded.setSupportsAttached(supportsAttached);
            break;
        }
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 18 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            RRKeyPersonExpandedDocument.RRKeyPersonExpanded.AdditionalProfilesAttached additionalProfilesAttached = (RRKeyPersonExpandedDocument.RRKeyPersonExpanded.AdditionalProfilesAttached)RRKeyPersonExpandedDocument.RRKeyPersonExpanded.AdditionalProfilesAttached.Factory.newInstance();
            additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
            rrKeyPersonExpanded.setAdditionalProfilesAttached(additionalProfilesAttached);
            break;
        }
        rrKeyPersonExpandedDocument.setRRKeyPersonExpanded(rrKeyPersonExpanded);
        return rrKeyPersonExpandedDocument;
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType profileDataType = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
        PersonProfileDataType.Profile profile = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            if (PI.getPersonId() != null) {
                this.pIPersonOrRolodexId = PI.getPersonId();
            } else if (PI.getRolodexId() != null) {
                this.pIPersonOrRolodexId = PI.getRolodexId().toString();
            }
            profile.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            if (PI.getDirectoryTitle() != null) {
                if (PI.getDirectoryTitle().length() > 45) {
                    profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
                } else {
                    profile.setTitle(PI.getDirectoryTitle());
                }
            }
            profile.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)PI));
            profile.setPhone(PI.getOfficePhone());
            if (StringUtils.isNotEmpty((CharSequence)PI.getFaxNumber())) {
                profile.setFax(PI.getFaxNumber());
            }
            profile.setEmail(PI.getEmailAddress());
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                profile.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
            }
            if (PI.getHomeUnit() != null) {
                KcPersonContract kcPerson = PI.getPerson();
                String departmentName = kcPerson.getOrganizationIdentifier();
                profile.setDepartmentName(StringUtils.substring((String)departmentName, (int)0, (int)30));
            } else if (PI.getRolodexId() != null && PI.getDirectoryDepartment() != null) {
                profile.setDepartmentName(StringUtils.substring((String)PI.getDirectoryDepartment(), (int)0, (int)30));
            } else {
                DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
                profile.setDepartmentName(StringUtils.substring((String)developmentProposal.getOwnedByUnit().getUnitName(), (int)0, (int)30));
            }
            String divisionName = this.getS2sDivisionService().getDivision(PI);
            if (divisionName != null) {
                profile.setDivisionName(divisionName);
            }
            if (PI.getEraCommonsUserName() != null) {
                profile.setCredential(PI.getEraCommonsUserName());
            } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + PI.getFullName(), "grantsGov.Opportunity", new String[0]));
            }
            profile.setProjectRole(ProjectRoleDataType.PD_PI);
            PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = (PersonProfileDataType.Profile.BioSketchsAttached)PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
            AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "1");
            personBioSketch.setBioSketchAttached(bioSketchAttachment);
            profile.setBioSketchsAttached(personBioSketch);
            AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "2");
            if (supportAttachment != null) {
                PersonProfileDataType.Profile.SupportsAttached supportsAttached = (PersonProfileDataType.Profile.SupportsAttached)PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                supportsAttached.setSupportAttached(supportAttachment);
                profile.setSupportsAttached(supportsAttached);
            }
            profileDataType.setProfile(profile);
        }
        return profileDataType;
    }

    private PersonProfileDataType[] getPersonProfileKeyPerson() {
        ArrayList<PersonProfileDataType> personProfileDataTypeList = new ArrayList<PersonProfileDataType>();
        List keyPersons = this.pdDoc.getDevelopmentProposal().getProposalPersons();
        keyPersons.sort(new ProposalPersonComparator());
        List<ProposalPersonContract> nKeyPersons = this.s2SProposalPersonService.getNKeyPersons(keyPersons, 40);
        this.extraPersons = keyPersons.stream().filter(kp -> !nKeyPersons.contains(kp)).collect(Collectors.toList());
        if (nKeyPersons.size() > 0) {
            for (ProposalPersonContract keyPerson : nKeyPersons) {
                if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
                PersonProfileDataType.Profile profileKeyPerson = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
                profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                if (keyPerson.getDirectoryTitle() != null) {
                    if (keyPerson.getDirectoryTitle().length() > 45) {
                        profileKeyPerson.setTitle(keyPerson.getDirectoryTitle().substring(0, 45));
                    } else {
                        profileKeyPerson.setTitle(keyPerson.getDirectoryTitle());
                    }
                }
                profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)keyPerson));
                profileKeyPerson.setPhone(keyPerson.getOfficePhone());
                if (StringUtils.isNotEmpty((CharSequence)keyPerson.getFaxNumber())) {
                    profileKeyPerson.setFax(keyPerson.getFaxNumber());
                }
                profileKeyPerson.setEmail(keyPerson.getEmailAddress());
                if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                    profileKeyPerson.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
                }
                if (keyPerson.getHomeUnit() != null) {
                    KcPersonContract kcPerson = keyPerson.getPerson();
                    String departmentName = kcPerson.getOrganizationIdentifier();
                    profileKeyPerson.setDepartmentName(StringUtils.substring((String)departmentName, (int)0, (int)30));
                } else {
                    DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
                    profileKeyPerson.setDepartmentName(StringUtils.substring((String)developmentProposal.getOwnedByUnit().getUnitName(), (int)0, (int)30));
                }
                String divisionName = this.getS2sDivisionService().getDivision(keyPerson);
                if (divisionName != null) {
                    profileKeyPerson.setDivisionName(divisionName);
                }
                if (keyPerson.getEraCommonsUserName() != null) {
                    profileKeyPerson.setCredential(keyPerson.getEraCommonsUserName());
                } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode()) && keyPerson.isMultiplePi()) {
                    this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + keyPerson.getFullName(), "grantsGov.Opportunity", new String[0]));
                }
                if (keyPerson.isMultiplePi() || keyPerson.isCoInvestigator()) {
                    if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                        if (keyPerson.isMultiplePi()) {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                        } else {
                            profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                        }
                    } else {
                        profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
                    }
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
                    PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = (PersonProfileDataType.Profile.OtherProjectRoleCategory)PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
                    String otherRole = keyPerson.getProjectRole() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
                    otherProjectRole.setStringValue(otherRole);
                    profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
                }
                PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = (PersonProfileDataType.Profile.BioSketchsAttached)PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
                AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "1");
                personBioSketch.setBioSketchAttached(bioSketchAttachment);
                profileKeyPerson.setBioSketchsAttached(personBioSketch);
                AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, keyPerson.getPersonId(), keyPerson.getRolodexId(), "2");
                if (supportAttachment != null) {
                    PersonProfileDataType.Profile.SupportsAttached supportsAttached = (PersonProfileDataType.Profile.SupportsAttached)PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
                    supportsAttached.setSupportAttached(supportAttachment);
                    profileKeyPerson.setSupportsAttached(supportsAttached);
                }
                PersonProfileDataType personProfileDataTypeKeyPerson = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
                personProfileDataTypeKeyPerson.setProfile(profileKeyPerson);
                personProfileDataTypeList.add(personProfileDataTypeKeyPerson);
            }
        }
        return personProfileDataTypeList.toArray(new PersonProfileDataType[0]);
    }

    @Override
    public RRKeyPersonExpandedDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRKeyPersonExpanded();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<RRKeyPersonExpandedDocument> factory() {
        return RRKeyPersonExpandedDocument.Factory;
    }
}

