/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrKeyPersonExpanded12V12.PersonProfileDataType;
import gov.grants.apply.forms.rrKeyPersonExpanded12V12.ProjectRoleDataType;
import gov.grants.apply.forms.rrKeyPersonExpanded12V12.RRKeyPersonExpanded12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonDegreeContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.ProposalPersonComparator;
import org.kuali.coeus.s2sgen.impl.generate.support.RRKeyPersonExpandedBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRKeyPersonExpandedV1_2Generator")
public class RRKeyPersonExpandedV1_2Generator
extends RRKeyPersonExpandedBaseGenerator<RRKeyPersonExpanded12Document> {
    private RolodexContract rolodex;
    @Value(value="http://apply.grants.gov/forms/RR_KeyPersonExpanded_1_2-V1.2")
    private String namespace;
    @Value(value="RR_KeyPersonExpanded_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_KeyPersonExpanded-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="155")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private RRKeyPersonExpanded12Document getRRKeyPersonExpanded() {
        RRKeyPersonExpanded12Document rrKeyPersonExpandedDocument = (RRKeyPersonExpanded12Document)RRKeyPersonExpanded12Document.Factory.newInstance();
        RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded = (RRKeyPersonExpanded12Document.RRKeyPersonExpanded12)RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.Factory.newInstance();
        this.setRRKeyPersonExpandedAttributes(rrKeyPersonExpanded);
        rrKeyPersonExpandedDocument.setRRKeyPersonExpanded12(rrKeyPersonExpanded);
        return rrKeyPersonExpandedDocument;
    }

    private void setRRKeyPersonExpandedAttributes(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded) {
        rrKeyPersonExpanded.setFormVersion(FormVersion.v1_2.getVersion());
        rrKeyPersonExpanded.setPDPI(this.getPersonProfilePI());
        PersonProfileDataType[] keyPersonArray = this.getPersonProfileKeyPerson();
        if (keyPersonArray.length > 0) {
            rrKeyPersonExpanded.setKeyPersonArray(keyPersonArray);
        }
        this.saveKeyPersonAttachmentsToProposal();
        if (this.extraPersons.size() > 0) {
            for (ProposalPersonContract extraPerson : this.extraPersons) {
                this.setBioSketchAttchment(rrKeyPersonExpanded, extraPerson);
                this.setCurrentPendingTypeAttachment(rrKeyPersonExpanded, extraPerson);
            }
            for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
                if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 18) continue;
                this.setProfileTypeAttachment(rrKeyPersonExpanded, narrative);
            }
        }
    }

    private void setProfileTypeAttachment(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded, NarrativeContract narrative) {
        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
        if (attachedFileDataType != null) {
            RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.AdditionalProfilesAttached additionalProfilesAttached = (RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.AdditionalProfilesAttached)RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.AdditionalProfilesAttached.Factory.newInstance();
            additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
            rrKeyPersonExpanded.setAdditionalProfilesAttached(additionalProfilesAttached);
        }
    }

    private void setCurrentPendingTypeAttachment(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded, ProposalPersonContract extraPerson) {
        AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), "2");
        if (supportAttachment != null) {
            RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.SupportsAttached supportsAttached = (RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.SupportsAttached)RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(supportAttachment);
            rrKeyPersonExpanded.setSupportsAttached(supportsAttached);
        }
    }

    private void setBioSketchAttchment(RRKeyPersonExpanded12Document.RRKeyPersonExpanded12 rrKeyPersonExpanded, ProposalPersonContract extraPerson) {
        RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.BioSketchsAttached personBioSketch = (RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.BioSketchsAttached)RRKeyPersonExpanded12Document.RRKeyPersonExpanded12.BioSketchsAttached.Factory.newInstance();
        AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), "1");
        personBioSketch.setBioSketchAttached(bioSketchAttachment);
        rrKeyPersonExpanded.setBioSketchsAttached(personBioSketch);
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType profileDataType = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
        PersonProfileDataType.Profile profile = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            this.setPersonalProfileDetailsToProfile(profileDataType, profile, PI);
        }
        return profileDataType;
    }

    private void setPersonalProfileDetailsToProfile(PersonProfileDataType profileDataType, PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        ProposalPersonDegreeContract proposalPersonDegree;
        this.assignRolodexId(PI);
        profile.setName(this.globLibV20Generator.getHumanNameDataType(PI));
        this.setDirectoryTitleToProfile(profile, PI);
        profile.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)PI));
        profile.setPhone(PI.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)PI.getFaxNumber())) {
            profile.setFax(PI.getFaxNumber());
        }
        if (PI.getDegree() != null) {
            profile.setDegreeType(PI.getDegree());
        }
        if (PI.getYearGraduated() != null) {
            profile.setDegreeYear(PI.getYearGraduated());
        }
        if (PI.getDegree() == null && PI.getYearGraduated() == null && PI.getProposalPersonDegrees() != null && PI.getProposalPersonDegrees().size() > 0 && (proposalPersonDegree = (ProposalPersonDegreeContract)PI.getProposalPersonDegrees().get(0)) != null) {
            if (proposalPersonDegree.getDegreeType() != null && proposalPersonDegree.getDegreeType().getDescription() != null) {
                profile.setDegreeType(proposalPersonDegree.getDegreeType().getDescription());
            }
            if (proposalPersonDegree.getGraduationYear() != null) {
                profile.setDegreeYear(proposalPersonDegree.getGraduationYear());
            }
        }
        profile.setEmail(PI.getEmailAddress());
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profile, developmentProposal);
        this.setDepartmentNameToProfile(profile, PI);
        String divisionName = this.getS2sDivisionService().getDivision(PI);
        if (divisionName != null) {
            profile.setDivisionName(divisionName);
        }
        if (PI.getEraCommonsUserName() != null) {
            profile.setCredential(PI.getEraCommonsUserName());
        } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
            this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + PI.getFullName(), "grantsGov.Opportunity", new String[0]));
        }
        profile.setProjectRole(ProjectRoleDataType.PD_PI);
        this.setAttachments(profile, PI);
        profileDataType.setProfile(profile);
    }

    private void setDepartmentNameToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract keyPerson) {
        if (keyPerson.getHomeUnit() != null && keyPerson.getPerson() != null) {
            String departmentName = keyPerson.getPerson().getOrganizationIdentifier();
            profile.setDepartmentName(StringUtils.substring((String)departmentName, (int)0, (int)30));
        } else if (keyPerson.getRolodexId() != null && keyPerson.getDirectoryDepartment() != null) {
            profile.setDepartmentName(StringUtils.substring((String)keyPerson.getDirectoryDepartment(), (int)0, (int)30));
        } else {
            DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
            profile.setDepartmentName(StringUtils.substring((String)developmentProposal.getOwnedByUnit().getUnitName(), (int)0, (int)30));
        }
    }

    private void setDirectoryTitleToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        if (PI.getDirectoryTitle() != null) {
            if (PI.getDirectoryTitle().length() > 45) {
                profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
            } else {
                profile.setTitle(PI.getDirectoryTitle());
            }
        }
    }

    private void assignRolodexId(ProposalPersonContract PI) {
        if (PI.getPersonId() != null) {
            this.pIPersonOrRolodexId = PI.getPersonId();
            this.rolodex = null;
        } else if (PI.getRolodexId() != null) {
            this.pIPersonOrRolodexId = PI.getRolodexId().toString();
            this.rolodex = this.rolodexService.getRolodex(Integer.valueOf(this.pIPersonOrRolodexId));
        }
    }

    private void setAttachments(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        this.setBioSketchAttachment(profile, PI);
        this.setCurrentPendingAttachment(profile, PI);
    }

    private void setCurrentPendingAttachment(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "2");
        if (supportAttachment != null) {
            PersonProfileDataType.Profile.SupportsAttached supportsAttached = (PersonProfileDataType.Profile.SupportsAttached)PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(supportAttachment);
            profile.setSupportsAttached(supportsAttached);
        }
    }

    private void setBioSketchAttachment(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        PersonProfileDataType.Profile.BioSketchsAttached personBioSketch = (PersonProfileDataType.Profile.BioSketchsAttached)PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance();
        AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), "1");
        personBioSketch.setBioSketchAttached(bioSketchAttachment);
        profile.setBioSketchsAttached(personBioSketch);
    }

    private PersonProfileDataType[] getPersonProfileKeyPerson() {
        ArrayList<PersonProfileDataType> personProfileDataTypeList = new ArrayList<PersonProfileDataType>();
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        List keyPersons = developmentProposal.getProposalPersons();
        if (keyPersons != null) {
            keyPersons.sort(new ProposalPersonComparator());
        }
        List<ProposalPersonContract> nKeyPersons = this.s2SProposalPersonService.getNKeyPersons(keyPersons, 40);
        List list = this.extraPersons = keyPersons != null ? keyPersons.stream().filter(kp -> !nKeyPersons.contains(kp)).collect(Collectors.toList()) : Collections.emptyList();
        if (nKeyPersons.size() > 0) {
            this.setKeyPersonToPersonProfileDataType(personProfileDataTypeList, nKeyPersons);
        }
        return personProfileDataTypeList.toArray(new PersonProfileDataType[0]);
    }

    private void setKeyPersonToPersonProfileDataType(List<PersonProfileDataType> personProfileDataTypeList, List<ProposalPersonContract> nKeyPersons) {
        for (ProposalPersonContract keyPerson : nKeyPersons) {
            if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
            PersonProfileDataType.Profile profileKeyPerson = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
            this.setAllkeyPersonDetailsToKeyPerson(keyPerson, profileKeyPerson);
            this.setAttachments(profileKeyPerson, keyPerson);
            PersonProfileDataType personProfileDataTypeKeyPerson = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
            personProfileDataTypeKeyPerson.setProfile(profileKeyPerson);
            personProfileDataTypeList.add(personProfileDataTypeKeyPerson);
        }
    }

    private void setAllkeyPersonDetailsToKeyPerson(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        ProposalPersonDegreeContract proposalPersonDegree;
        this.assignRolodexId(keyPerson);
        profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
        this.setDirectoryTitleToProfile(profileKeyPerson, keyPerson);
        profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)keyPerson));
        profileKeyPerson.setPhone(keyPerson.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)keyPerson.getFaxNumber())) {
            profileKeyPerson.setFax(keyPerson.getFaxNumber());
        }
        if (keyPerson.getDegree() != null) {
            profileKeyPerson.setDegreeType(keyPerson.getDegree());
        }
        if (keyPerson.getYearGraduated() != null) {
            profileKeyPerson.setDegreeYear(keyPerson.getYearGraduated());
        }
        if (keyPerson.getDegree() == null && keyPerson.getYearGraduated() == null && keyPerson.getProposalPersonDegrees() != null && keyPerson.getProposalPersonDegrees().size() > 0 && (proposalPersonDegree = (ProposalPersonDegreeContract)keyPerson.getProposalPersonDegrees().get(0)) != null) {
            if (proposalPersonDegree.getDegreeType() != null && proposalPersonDegree.getDegreeType().getDescription() != null) {
                profileKeyPerson.setDegreeType(proposalPersonDegree.getDegreeType().getDescription());
            }
            if (proposalPersonDegree.getGraduationYear() != null) {
                profileKeyPerson.setDegreeYear(proposalPersonDegree.getGraduationYear());
            }
        }
        profileKeyPerson.setEmail(keyPerson.getEmailAddress());
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profileKeyPerson, developmentProposal);
        this.setDepartmentNameToProfile(profileKeyPerson, keyPerson);
        String divisionName = this.getS2sDivisionService().getDivision(keyPerson);
        if (divisionName != null) {
            profileKeyPerson.setDivisionName(divisionName);
        }
        if (keyPerson.getEraCommonsUserName() != null) {
            profileKeyPerson.setCredential(keyPerson.getEraCommonsUserName());
        } else if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode()) && keyPerson.isMultiplePi()) {
            this.getAuditErrors().add(new AuditError("noField", "eRA Commons User Name is missing for " + keyPerson.getFullName(), "grantsGov.Opportunity", new String[0]));
        }
        if (keyPerson.isMultiplePi() || keyPerson.isCoInvestigator()) {
            if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                if (keyPerson.isMultiplePi()) {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_INVESTIGATOR);
                }
            } else {
                profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
            }
        } else {
            this.setProjectRoleCategoryToProfile(keyPerson, profileKeyPerson);
        }
    }

    private void setOrganizationName(PersonProfileDataType.Profile profileKeyPerson, DevelopmentProposalContract developmentProposal) {
        if (developmentProposal.getApplicantOrganization() != null) {
            profileKeyPerson.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
        }
    }

    private void setProjectRoleCategoryToProfile(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
        PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = (PersonProfileDataType.Profile.OtherProjectRoleCategory)PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
        String otherRole = keyPerson.getProjectRole() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
        otherProjectRole.setStringValue(otherRole);
        profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
    }

    @Override
    public RRKeyPersonExpanded12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRKeyPersonExpanded();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<RRKeyPersonExpanded12Document> factory() {
        return RRKeyPersonExpanded12Document.Factory;
    }
}

