/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrBudget10V11.RRBudget10Document;
import gov.grants.apply.forms.rrSubawardBudget1010V12.RRSubawardBudget1010Document;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.S2SAdobeFormAttachmentBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@FormGenerator(value="RRSubAwardBudget10_10V1_2Generator")
public class RRSubAwardBudget10_10V1_2Generator
extends S2SAdobeFormAttachmentBaseGenerator<RRSubawardBudget1010Document> {
    private static final String RR_BUDGET10_11_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget10-V1.1";
    private static final String RR_BUDGET10_11_LOCAL_NAME = "RR_Budget10";
    @Value(value="http://apply.grants.gov/forms/RR_SubawardBudget10_10-V1.2")
    private String namespace;
    @Value(value="RR_SubawardBudget10_10-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SubawardBudget10_10-V1.2.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="178")
    private int sortIndex;

    private RRSubawardBudget1010Document getRRSubawardBudgetDocument() {
        RRSubawardBudget1010Document rrSubawardBudgetDocument = (RRSubawardBudget1010Document)RRSubawardBudget1010Document.Factory.newInstance();
        RRSubawardBudget1010Document.RRSubawardBudget1010 rrSubawardBudget = (RRSubawardBudget1010Document.RRSubawardBudget1010)RRSubawardBudget1010Document.RRSubawardBudget1010.Factory.newInstance();
        RRSubawardBudget1010Document.RRSubawardBudget1010.BudgetAttachments budgetAttachments = (RRSubawardBudget1010Document.RRSubawardBudget1010.BudgetAttachments)RRSubawardBudget1010Document.RRSubawardBudget1010.BudgetAttachments.Factory.newInstance();
        List<BudgetSubAwardsContract> budgetSubAwardsList = this.getBudgetSubAwards(this.pdDoc, RR_BUDGET10_11_NAMESPACE_URI, false);
        RRBudget10Document.RRBudget10[] budgetList = new RRBudget10Document.RRBudget10[budgetSubAwardsList.size()];
        rrSubawardBudget.setFormVersion(FormVersion.v1_2.getVersion());
        int attCount = 1;
        for (BudgetSubAwardsContract budgetSubAwards : budgetSubAwardsList) {
            RRBudget10Document.RRBudget10 rrBudget = this.getRRBudget10(budgetSubAwards).getRRBudget10();
            switch (attCount) {
                case 1: {
                    rrSubawardBudget.setATT1(this.prepareAttName(budgetSubAwards));
                    budgetList[0] = rrBudget;
                    break;
                }
                case 2: {
                    rrSubawardBudget.setATT2(this.prepareAttName(budgetSubAwards));
                    budgetList[1] = rrBudget;
                    break;
                }
                case 3: {
                    rrSubawardBudget.setATT3(this.prepareAttName(budgetSubAwards));
                    budgetList[2] = rrBudget;
                    break;
                }
                case 4: {
                    rrSubawardBudget.setATT4(this.prepareAttName(budgetSubAwards));
                    budgetList[3] = rrBudget;
                    break;
                }
                case 5: {
                    rrSubawardBudget.setATT5(this.prepareAttName(budgetSubAwards));
                    budgetList[4] = rrBudget;
                    break;
                }
                case 6: {
                    rrSubawardBudget.setATT6(this.prepareAttName(budgetSubAwards));
                    budgetList[5] = rrBudget;
                    break;
                }
                case 7: {
                    rrSubawardBudget.setATT7(this.prepareAttName(budgetSubAwards));
                    budgetList[6] = rrBudget;
                    break;
                }
                case 8: {
                    rrSubawardBudget.setATT8(this.prepareAttName(budgetSubAwards));
                    budgetList[7] = rrBudget;
                    break;
                }
                case 9: {
                    rrSubawardBudget.setATT9(this.prepareAttName(budgetSubAwards));
                    budgetList[8] = rrBudget;
                    break;
                }
                case 10: {
                    rrSubawardBudget.setATT10(this.prepareAttName(budgetSubAwards));
                    budgetList[9] = rrBudget;
                }
            }
            this.addSubAwdAttachments(budgetSubAwards);
            ++attCount;
        }
        budgetAttachments.setRRBudget10Array(budgetList);
        rrSubawardBudget.setBudgetAttachments(budgetAttachments);
        rrSubawardBudgetDocument.setRRSubawardBudget1010(rrSubawardBudget);
        return rrSubawardBudgetDocument;
    }

    private RRBudget10Document getRRBudget10(BudgetSubAwardsContract budgetSubAwards) {
        Document subAwdFormsDoc;
        RRBudget10Document rrBudget = (RRBudget10Document)RRBudget10Document.Factory.newInstance();
        String subAwdXML = budgetSubAwards.getSubAwardXmlFileData();
        try {
            subAwdFormsDoc = this.stringToDom(subAwdXML);
        }
        catch (S2SException e1) {
            return rrBudget;
        }
        Element subAwdFormsElement = subAwdFormsDoc.getDocumentElement();
        NodeList subAwdNodeList = subAwdFormsElement.getElementsByTagNameNS(RR_BUDGET10_11_NAMESPACE_URI, RR_BUDGET10_11_LOCAL_NAME);
        Node subAwdNode = null;
        if (subAwdNodeList != null) {
            if (subAwdNodeList.getLength() == 0) {
                return null;
            }
            subAwdNode = subAwdNodeList.item(0);
        }
        byte[] subAwdNodeBytes = null;
        try {
            subAwdNodeBytes = this.docToBytes(this.nodeToDom(subAwdNode));
            ByteArrayInputStream bgtIS = new ByteArrayInputStream(subAwdNodeBytes);
            rrBudget = (RRBudget10Document)RRBudget10Document.Factory.parse((InputStream)bgtIS);
        }
        catch (IOException | XmlException | S2SException e) {
            return rrBudget;
        }
        return rrBudget;
    }

    @Override
    public RRSubawardBudget1010Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRSubawardBudgetDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<RRSubawardBudget1010Document> factory() {
        return RRSubawardBudget1010Document.Factory;
    }
}

