/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.budget;

import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.springframework.stereotype.Component;

@Component("s2SCommonBudgetService")
public class S2SCommonBudgetServiceImpl implements S2SCommonBudgetService {
    @Override
    public ProposalDevelopmentBudgetExtContract getBudget(DevelopmentProposalContract developmentProposal) {
        if (developmentProposal == null) {
            throw new IllegalArgumentException("developmentProposal is null");
        }

        final ProposalDevelopmentBudgetExtContract finalBudget = developmentProposal.getFinalBudget();
        return finalBudget != null ? finalBudget : developmentProposal.getLatestBudget();
    }
}
