/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.s2sgen.api.generate.FormMappingInfo;
import org.kuali.coeus.s2sgen.api.generate.FormMappingService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.*;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;


@Component("formMappingService")
public class FormMappingServiceImpl implements FormMappingService, InitializingBean {

    private Map<String, FormMappingInfo> namespaceToInfo;

    @Autowired
    @Qualifier("s2SFormGeneratorRetrievalService")
    private S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService;

    @Override
    public FormMappingInfo getFormInfo(String namespace) {

        if (StringUtils.isBlank(namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }

        return namespaceToInfo.get(namespace);
    }

    @Override
    public Set<FormMappingInfo> getAllFormInfo() {
        return new HashSet<>(namespaceToInfo.values());
    }

    public S2SFormGeneratorRetrievalService getS2SFormGeneratorRetrievalService() {
        return s2SFormGeneratorRetrievalService;
    }

    public void setS2SFormGeneratorRetrievalService(S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService) {
        this.s2SFormGeneratorRetrievalService = s2SFormGeneratorRetrievalService;
    }

    @Override
    public void afterPropertiesSet() {
        namespaceToInfo = getS2SFormGeneratorRetrievalService().getS2SGenerators().stream()
                .map(s2sGenerator -> entry(s2sGenerator.getNamespace(), new FormMappingInfo(s2sGenerator.getNamespace(), s2sGenerator.getFormName())))
                .collect(entriesToMap());
    }
}
