/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.var.schemes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.PropertiesUtil;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;

public class URLScheme
implements PropertyScheme {
    private static final Logger LOG = LogManager.getLogger(URLScheme.class);

    @Override
    public String getName() {
        return "url";
    }

    @Override
    public String getShortName() {
        return "url";
    }

    @Override
    public Object load(Property property, RouteContext context) {
        LOG.info("Reading url '" + property.locator + "'...");
        try {
            InputStream is = new URL(property.locator).openStream();
            if (is == null) {
                throw new RuntimeException("Unable to access URL: " + property.locator);
            }
            return PropertiesUtil.readResource(is);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error loading resource: " + property.locator, ioe);
        }
    }

    public String toString() {
        return "[URLScheme]";
    }
}

