/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kns.kim.permission.PermissionTypeServiceBase;

public class BackdoorRestrictionPermissionTypeServiceImpl
extends PermissionTypeServiceBase {
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        HashSet<String> permissionAppCodes = new HashSet<String>(permissionsList.size());
        for (Permission permission : permissionsList) {
            String appCode = (String)permission.getAttributes().get("appCode");
            if (!StringUtils.isNotBlank((String)appCode)) continue;
            permissionAppCodes.add(appCode);
        }
        String requestedAppCode = requestedDetails.get("appCode");
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission permission : permissionsList) {
            String currentAppCode = (String)permission.getAttributes().get("appCode");
            if (!StringUtils.isNotEmpty((String)requestedAppCode) || !requestedAppCode.equals(currentAppCode)) continue;
            matchingPermissions.add(permission);
        }
        return matchingPermissions;
    }
}

