/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.permission;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.permission.PermissionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="permission")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="PermissionType", propOrder={"id", "namespaceCode", "name", "description", "template", "active", "attributes", "versionNumber", "objectId", "_futureElements"})
public final class Permission
extends AbstractDataTransferObject
implements PermissionContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="template", required=true)
    private final Template template;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElement(name="active", required=false)
    private boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Permission() {
        this.id = null;
        this.namespaceCode = null;
        this.name = null;
        this.description = null;
        this.template = null;
        this.attributes = null;
        this.active = false;
        this.versionNumber = 1L;
        this.objectId = null;
    }

    private Permission(Builder builder) {
        this.id = builder.getId();
        this.namespaceCode = builder.getNamespaceCode();
        this.name = builder.getName();
        this.description = builder.getDescription();
        this.template = builder.getTemplate() != null ? builder.getTemplate().build() : null;
        this.attributes = builder.getAttributes() != null ? builder.getAttributes() : Collections.emptyMap();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static final class Builder
    implements PermissionContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String namespaceCode;
        private String name;
        private String description;
        private Template.Builder template;
        private Map<String, String> attributes;
        private Long versionNumber;
        private String objectId;
        private boolean active;

        private Builder(String namespaceCode, String name) {
            this.setNamespaceCode(namespaceCode);
            this.setName(name);
        }

        public static Builder create(String namespaceCode, String name) {
            return new Builder(namespaceCode, name);
        }

        public static Builder create(PermissionContract contract) {
            Builder builder = new Builder(contract.getNamespaceCode(), contract.getName());
            builder.setId(contract.getId());
            builder.setDescription(contract.getDescription());
            if (contract.getAttributes() != null) {
                builder.setAttributes(contract.getAttributes());
            }
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            if (contract.getTemplate() != null && contract.getTemplate().getName() != null && contract.getTemplate().getNamespaceCode() != null) {
                builder.setTemplate(Template.Builder.create(contract.getTemplate()));
            }
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isBlank((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode is blank");
            }
            this.namespaceCode = namespaceCode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Template.Builder getTemplate() {
            return this.template;
        }

        public void setTemplate(Template.Builder template) {
            if (template == null) {
                throw new IllegalArgumentException("template is null");
            }
            this.template = StringUtils.isNotBlank((String)template.getName()) && StringUtils.isNotBlank((String)template.getNamespaceCode()) ? template : null;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            if (versionNumber != null && versionNumber <= 0L) {
                throw new IllegalArgumentException("versionNumber is invalid");
            }
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = Collections.unmodifiableMap(Maps.newHashMap(attributes));
        }

        public Permission build() {
            return new Permission(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/PermissionType";
    }

    static class Elements {
        static final String ID = "id";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String TEMPLATE = "template";
        static final String ATTRIBUTES = "attributes";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "permission";
        static final String TYPE_NAME = "PermissionType";

        Constants() {
        }
    }
}

