/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.web;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.web.KSBAction;
import org.kuali.rice.ksb.messaging.web.QuartzQueueForm;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

public class QuartzQueueAction
extends KSBAction {
    private static final String RENDER_LIST_OVERRIDE = "_renderlistoverride";

    @Override
    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm form) throws Exception {
        if ("moveToRouteQueue".equals(request.getParameter("methodToCall")) && request.getAttribute(RENDER_LIST_OVERRIDE) == null) {
            return null;
        }
        Scheduler scheduler = KSBServiceLocator.getScheduler();
        ArrayList<QuartzQueueForm> jobs = new ArrayList<QuartzQueueForm>();
        List jobGroups = KSBServiceLocator.getScheduler().getJobGroupNames();
        for (int i = 0; i < jobGroups.size(); ++i) {
            String jobGroup = (String)KSBServiceLocator.getScheduler().getJobGroupNames().get(i);
            for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)jobGroup))) {
                Trigger trigger = (Trigger)scheduler.getTriggersOfJob(jobKey).get(0);
                JobDetail jobDetail = scheduler.getJobDetail(jobKey);
                jobs.add(new QuartzQueueForm(jobDetail, trigger));
            }
        }
        request.setAttribute("jobs", jobs);
        return null;
    }

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("joblisting");
    }

    public ActionForward moveToRouteQueue(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuartzQueueForm quartzForm = (QuartzQueueForm)form;
        JobKey jobKey = new JobKey(quartzForm.getJobName(), quartzForm.getJobGroup());
        JobDetail job = KSBServiceLocator.getScheduler().getJobDetail(jobKey);
        PersistedMessageBO message = (PersistedMessageBO)job.getJobDataMap().get((Object)"message");
        if (message != null) {
            message.setQueueStatus("E");
            message = KSBServiceLocator.getMessageQueueService().save(message);
            KSBServiceLocator.getScheduler().deleteJob(jobKey);
        }
        request.setAttribute(RENDER_LIST_OVERRIDE, new Object());
        this.establishRequiredState(request, form);
        return mapping.findForward("joblisting");
    }
}

