/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.WrapperStore;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceProvider;

public final class StoreSupport {
    private StoreSupport() {
    }

    public static Store.Provider selectWrapperStoreProvider(ServiceProvider<Service> serviceProvider, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        Collection storeProviders = serviceProvider.getServicesOfType(WrapperStore.Provider.class);
        Optional<Tuple> wrapperProvider = storeProviders.stream().map(provider -> new Tuple<Integer, WrapperStore.Provider>(provider.wrapperStoreRank(serviceConfigs), (WrapperStore.Provider)provider)).filter(providerTuple -> (Integer)providerTuple.x != 0).max(Comparator.comparingInt(value -> (Integer)value.x));
        return wrapperProvider.map(providerTuple -> (WrapperStore.Provider)providerTuple.y).orElse(null);
    }

    public static Store.Provider selectStoreProvider(ServiceProvider<Service> serviceProvider, Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        StringBuilder sb;
        Collection storeProviders = serviceProvider.getServicesOfType(Store.Provider.class);
        List<Store.Provider> filteredStoreProviders = storeProviders.stream().filter(provider -> !(provider instanceof WrapperStore.Provider)).collect(Collectors.toList());
        int highRank = 0;
        ArrayList<Store.Provider> rankingProviders = new ArrayList<Store.Provider>();
        for (Store.Provider provider2 : filteredStoreProviders) {
            int rank = provider2.rank(resourceTypes, serviceConfigs);
            if (rank > highRank) {
                highRank = rank;
                rankingProviders.clear();
                rankingProviders.add(provider2);
                continue;
            }
            if (rank == 0 || rank != highRank) continue;
            rankingProviders.add(provider2);
        }
        if (rankingProviders.isEmpty()) {
            sb = new StringBuilder("No Store.Provider found to handle configured resource types ");
            sb.append(resourceTypes);
            sb.append(" from ");
            StoreSupport.formatStoreProviders(filteredStoreProviders, sb);
            throw new IllegalStateException(sb.toString());
        }
        if (rankingProviders.size() > 1) {
            sb = new StringBuilder("Multiple Store.Providers found to handle configured resource types ");
            sb.append(resourceTypes);
            sb.append(": ");
            StoreSupport.formatStoreProviders(rankingProviders, sb);
            throw new IllegalStateException(sb.toString());
        }
        return (Store.Provider)rankingProviders.get(0);
    }

    private static void formatStoreProviders(Collection<Store.Provider> storeProviders, StringBuilder sb) {
        sb.append('{');
        boolean prependSeparator = false;
        for (Store.Provider provider : storeProviders) {
            if (prependSeparator) {
                sb.append(", ");
            } else {
                prependSeparator = true;
            }
            sb.append(provider.getClass().getName());
        }
        sb.append('}');
    }

    private static class Tuple<X, Y> {
        final X x;
        final Y y;

        Tuple(X x, Y y) {
            this.x = x;
            this.y = y;
        }
    }
}

