/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="messageField", parent="Uif-MessageField")
public class MessageField
extends FieldBase {
    private static final long serialVersionUID = -7045208136391722063L;
    private Message message;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.getFieldLabel() != null && this.getMessage() != null && StringUtils.isNotBlank((String)this.getMessage().getId())) {
            if (this.getMessage().getMessageComponentStructure() != null && !this.getMessage().getMessageComponentStructure().isEmpty()) {
                this.getFieldLabel().setLabelForComponentId(this.getMessage().getId());
            } else {
                this.getFieldLabel().setLabelForComponentId(this.getMessage().getId() + "_span");
            }
        }
    }

    @BeanTagAttribute
    public String getMessageText() {
        if (this.message != null) {
            return this.message.getMessageText();
        }
        return null;
    }

    public void setMessageText(String messageText) {
        if (this.message != null) {
            this.message.setMessageText(messageText);
        }
    }

    @BeanTagAttribute
    public List<Component> getInlineComponents() {
        if (this.message != null) {
            return this.message.getInlineComponents();
        }
        return null;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        if (this.message != null) {
            this.message.setInlineComponents(inlineComponents);
        }
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getMessage() == null && Validator.checkExpressions(this, "message")) {
            currentValues = new String[]{"message =" + String.valueOf(this.getMessage())};
            tracer.createWarning("Message should not be null", currentValues);
        }
        if (this.getLabel() == null && Validator.checkExpressions(this, "label")) {
            currentValues = new String[]{"label =" + this.getLabel(), "Message =" + String.valueOf(this.getMessage())};
            tracer.createWarning("Label is null, message should be used instead", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

