/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.curry;

import com.codiform.moo.session.TranslationSession;
import com.codiform.moo.translator.CachingTranslatorFactory;
import com.codiform.moo.translator.TranslatorFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Translate<T> {
    Map<String, Object> variables;
    private TranslatorFactory translatorFactory;
    private Class<T> destinationClass;

    public Translate(TranslatorFactory translatorFactory, Class<T> destinationClass) {
        this.translatorFactory = translatorFactory;
        this.destinationClass = destinationClass;
        this.variables = new HashMap<String, Object>();
    }

    public T from(Object source) {
        return new TranslationSession(this.translatorFactory, this.variables).getTranslation(source, this.destinationClass);
    }

    public Collection<T> fromEach(Collection<?> source) {
        return new TranslationSession(this.translatorFactory, this.variables).getEachTranslation(source, this.destinationClass);
    }

    public Set<T> fromEach(Set<?> source) {
        return new TranslationSession(this.translatorFactory, this.variables).getEachTranslation(source, this.destinationClass);
    }

    public List<T> fromEach(List<?> source) {
        return new TranslationSession(this.translatorFactory, this.variables).getEachTranslation(source, this.destinationClass);
    }

    public Translate<T> withVariable(String variableName, Object variableValue) {
        this.variables.put(variableName, variableValue);
        return this;
    }

    public static <T> Translate<T> to(Class<T> destinationClass) {
        return new Translate<T>(new CachingTranslatorFactory(), destinationClass);
    }
}

