/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.struts.BudgetAction;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularIdc;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularService;
import org.kuali.coeus.propdev.impl.budget.modular.SyncModularBudgetKcEvent;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.KualiRuleService;

public class BudgetModularBudgetAction
extends BudgetAction {
    private static final String CONFIRM_SYNC_BUDGET_MODULAR = "confirmSyncBudgetModular";

    public ActionForward updateView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        this.generateModularPeriod(budgetForm);
        return mapping.findForward("basic");
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        BudgetModularIdc newBudgetModularIdc = budgetForm.getNewBudgetModularIdc();
        newBudgetModularIdc.setRateNumber(budget.getNextValue("rateNumber"));
        newBudgetModularIdc.calculateFundsRequested();
        BudgetModular budgetModular = budget.getBudgetPeriods().get(budgetForm.getModularSelectedPeriod() - 1).getBudgetModular();
        if (this.roundFandAbase()) {
            budgetModular.addNewBudgetModularIdcBaseRounded(newBudgetModularIdc);
        } else {
            budgetModular.addNewBudgetModularIdcBaseUnrounded(newBudgetModularIdc);
        }
        this.generateModularPeriod(budgetForm);
        budgetForm.setNewBudgetModularIdc(new BudgetModularIdc());
        return mapping.findForward("basic");
    }

    public boolean roundFandAbase() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ModularBudget_Round_F_and_A_Base");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        BudgetModular budgetModular = budget.getBudgetPeriods().get(budgetForm.getModularSelectedPeriod() - 1).getBudgetModular();
        budgetModular.getBudgetModularIdcs().remove(this.getLineToDelete(request));
        this.generateModularPeriod(budgetForm);
        return mapping.findForward("basic");
    }

    public ActionForward recalculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        if (!budgetForm.getModularSelectedPeriod().equals(0)) {
            this.generateModularPeriod(budgetForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward sync(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean passed = this.getKcBusinessRulesEngine().applyRules(new SyncModularBudgetKcEvent((ProposalDevelopmentBudgetExt)((BudgetForm)form).getBudget()));
        if (passed) {
            return this.confirm(this.buildSyncBudgetModularConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_BUDGET_MODULAR, "");
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.reload(mapping, form, request, response);
        this.generateModularPeriod((BudgetForm)form);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.save(mapping, form, request, response);
        this.generateModularPeriod((BudgetForm)form);
        return mapping.findForward("basic");
    }

    public ActionForward confirmSyncBudgetModular(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SYNC_BUDGET_MODULAR.equals(question)) {
            BudgetModularService budgetModularService = KcServiceLocator.getService(BudgetModularService.class);
            BudgetForm budgetForm = (BudgetForm)form;
            AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
            budgetModularService.synchModularBudget(budget, false);
            budgetForm.setBudgetModularSummary(budgetModularService.processModularSummary(budget, false));
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildSyncBudgetModularConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_BUDGET_MODULAR, "document.question.syncBudgetModular.text", "");
    }

    private void generateModularPeriod(BudgetForm budgetForm) {
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        BudgetModularService budgetModularService = KcServiceLocator.getService(BudgetModularService.class);
        if (budgetForm.getModularSelectedPeriod().equals(0)) {
            budgetForm.setBudgetModularSummary(budgetModularService.processModularSummary(budget, false));
            return;
        }
        BudgetPeriod budgetPeriod = budget.getBudgetPeriods().get(budgetForm.getModularSelectedPeriod() - 1);
        budgetModularService.generateModularPeriod(budgetPeriod);
        budgetForm.setBudgetModularSummary(budgetModularService.processModularSummary(budget, false));
    }

    protected KualiRuleService getKualiRuleService() {
        return KcServiceLocator.getService(KualiRuleService.class);
    }

    protected ParameterService getParameterService() {
        return KcServiceLocator.getService(ParameterService.class);
    }
}

