/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitContactType;
import org.kuali.coeus.common.framework.unit.admin.AbstractUnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;

public class AwardUnitContact
extends AwardContact
implements AbstractUnitAdministrator {
    public static final String OSP_ADMINISTRATOR = "OSP_ADMINISTRATOR";
    private static final String UNIT_ADMINISTRATOR_TYPE_CODE = "UNIT_ADMINISTRATOR_TYPE_CODE";
    private static final String CONTACT_TYPE_CODE = "CONTACT_TYPE_CODE";
    private static final long serialVersionUID = -9168956728201616266L;
    private UnitContactType unitContactType;
    private UnitAdministratorType unitAdministratorType;
    private String unitAdministratorTypeCode;
    private String unitAdministratorUnitNumber;
    private boolean defaultUnitContact;
    private Unit unitAdministratorUnit;

    public AwardUnitContact() {
    }

    public AwardUnitContact(NonOrganizationalRolodex rolodex, ContactRole role, UnitContactType unitContactType) {
        super(rolodex, role);
        this.unitContactType = unitContactType;
    }

    public AwardUnitContact(KcPerson person, ContactRole role, UnitContactType unitContactType) {
        super(person, role);
        this.unitContactType = unitContactType;
        this.unitAdministratorUnitNumber = person.getUnit() != null ? person.getUnit().getUnitNumber() : null;
    }

    AwardUnitContact(UnitContactType unitContactType) {
        this.unitContactType = unitContactType;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AwardUnitContact)) {
            return false;
        }
        AwardUnitContact that = (AwardUnitContact)obj;
        return super.equals(that) && this.defaultUnitContact == that.defaultUnitContact && Objects.equals(this.unitAdministratorTypeCode, that.unitAdministratorTypeCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultUnitContact, this.unitAdministratorTypeCode);
    }

    @Override
    public void setPersonId(String personId) {
        super.setPersonId(personId);
        if (this.getPerson() != null && this.getPerson().getUnit() != null) {
            this.setUnitAdministratorUnitNumber(this.getPerson().getUnit().getUnitNumber());
        }
    }

    @Override
    public void setPerson(KcPerson person) {
        super.setPerson(person);
        if (this.getPerson() != null && this.getPerson().getUnit() != null) {
            this.setUnitAdministratorUnitNumber(this.getPerson().getUnit().getUnitNumber());
        }
    }

    public String getUnitAdministratorUnitNumberByPersonId() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("unitNumber", this.getAward().getLeadUnitNumber());
        criteria.put("personId", this.getPerson().getPersonId());
        ArrayList results = new ArrayList(this.getBusinessObjectService().findMatching(UnitAdministrator.class, criteria));
        if (results.size() == 0) {
            return this.getPerson().getUnit().getUnitNumber();
        }
        return ((UnitAdministrator)results.get(0)).getUnitNumber();
    }

    public String getUnitNumberForDisplay() {
        if (this.unitAdministratorUnitNumber == null) {
            if (this.getPerson() != null && this.getPerson().getUnit() != null) {
                return this.getPerson().getUnit().getUnitNumber();
            }
            return "";
        }
        return this.unitAdministratorUnitNumber;
    }

    public UnitContactType getUnitContactType() {
        return this.unitContactType;
    }

    @Override
    public UnitAdministratorType getUnitAdministratorType() {
        return this.unitAdministratorType;
    }

    @Override
    public Unit getUnit() {
        return this.getUnitAdministratorUnit();
    }

    public void setUnitAdministratorType(UnitAdministratorType unitAdministratorType) {
        this.unitAdministratorType = unitAdministratorType;
    }

    @Override
    public String getUnitAdministratorTypeCode() {
        return this.unitAdministratorTypeCode;
    }

    @Override
    public String getUnitNumber() {
        return this.unitAdministratorUnitNumber;
    }

    public void setUnitAdministratorTypeCode(String unitAdministratorTypeCode) {
        this.unitAdministratorTypeCode = unitAdministratorTypeCode;
    }

    public String getUnitAdministratorUnitNumber() {
        return this.unitAdministratorUnitNumber;
    }

    public void setUnitAdministratorUnitNumber(String unitAdministratorUnitNumber) {
        this.unitAdministratorUnitNumber = unitAdministratorUnitNumber;
    }

    public boolean isOspAdministrator() {
        return this.getUnitAdministratorType() != null && StringUtils.equals((CharSequence)this.getUnitAdministratorType().getDescription(), (CharSequence)OSP_ADMINISTRATOR);
    }

    public void setUnitContactType(UnitContactType contactType) {
        this.unitContactType = contactType;
    }

    protected Class<? extends ContactRole> getContactRoleType() {
        return this.getUnitContactType() == UnitContactType.ADMINISTRATOR ? UnitAdministratorType.class : ContactType.class;
    }

    protected String getContactRoleTypeIdentifier() {
        return this.getUnitContactType() == UnitContactType.ADMINISTRATOR ? UNIT_ADMINISTRATOR_TYPE_CODE : CONTACT_TYPE_CODE;
    }

    @Override
    protected Map<String, Object> getContactRoleIdentifierMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getContactRoleTypeIdentifier(), this.getRoleCode());
        return map;
    }

    public boolean isDefaultUnitContact() {
        return this.defaultUnitContact;
    }

    public void setDefaultUnitContact(boolean defaultUnitContact) {
        this.defaultUnitContact = defaultUnitContact;
    }

    public Unit getUnitAdministratorUnit() {
        return this.unitAdministratorUnit;
    }

    public void setUnitAdministratorUnit(Unit unitAdministratorUnit) {
        this.unitAdministratorUnit = unitAdministratorUnit;
    }
}

