/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardTransferringSponsor;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.xmlstream.AwardBaseStream;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.printing.schema.AwardHierarchyType;
import org.kuali.kra.printing.schema.AwardNoticeDocument;
import org.kuali.kra.printing.schema.AwardType;
import org.kuali.kra.printing.schema.ChildAwardType;
import org.kuali.kra.printing.schema.OtherGroupDetailsType;
import org.kuali.kra.printing.schema.OtherGroupType;
import org.kuali.kra.printing.schema.SpecialReviewType;

public class AwardNoticeXmlStream
extends AwardBaseStream {
    private static final String REPORTING = "reporting";
    private static final String TECHNICAL_REPORTING = "technicalReporting";
    private static final String TERMS = "terms";
    private static final String SPECIAL_REVIEW = "specialReview";
    private static final String SUBCONTRACT = "subcontract";
    private static final String SCIENCE_CODE = "keywords";
    private static final String PROPOSAL_DUE = "proposalDue";
    private static final String PAYMENT = "payment";
    private static final String INDIRECT_COST = "fACost";
    private static final String FUNDING_SUMMARY = "fundingSummary";
    private static final String HIERARCHY_INFO = "hierarchyInfo";
    private static final String FOREIGN_TRAVEL = "foreignTravel";
    private static final String FLOW_THRU = "flowThru";
    private static final String EQUIPMENT = "equipment";
    private static final String COST_SHARING = "costSharing";
    private static final String COMMENTS = "comments";
    private static final String CLOSEOUT = "closeout";
    private static final String ADDRESS_LIST = "addressList";
    private VersionHistoryService versionHistoryService;

    @Override
    public Map<String, AwardNoticeDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, AwardNoticeDocument> xmlObjectList = new LinkedHashMap<String, AwardNoticeDocument>();
        AwardNoticeDocument awardNoticeDocument = (AwardNoticeDocument)AwardNoticeDocument.Factory.newInstance();
        this.initialize((Award)printableBusinessObject);
        if (this.award != null) {
            awardNoticeDocument.setAwardNotice(this.getAwardNotice(reportParameters));
        }
        xmlObjectList.put(AwardPrintType.AWARD_NOTICE_REPORT.getAwardPrintType(), awardNoticeDocument);
        return xmlObjectList;
    }

    private void initialize(Award award) {
        this.awardDocument = award.getAwardDocument();
        this.award = award;
        List<AwardAmountInfo> awardAmountInfos = award.getAwardAmountInfos();
        if (awardAmountInfos != null && !awardAmountInfos.isEmpty()) {
            this.awardAmountInfo = awardAmountInfos.get(awardAmountInfos.size() - 1);
        }
    }

    @Override
    protected AwardType getAward() {
        AwardType awardType = super.getAward();
        awardType.setAwardTransferringSponsors(this.getAwardTransferringSponsors());
        awardType.setAwardPaymentSchedules(this.getAwardPaymentSchedules());
        awardType.setAwardSpecialReviews(this.getAwardSpecialReviews());
        awardType.setAwardOtherDatas(this.getAwardOtherDatas());
        awardType.setAwardBudgetDetails(this.getAwardBudgetDetails());
        awardType.setAwardFundingSummary(this.getAwardFundingSummary());
        awardType.setChildAwardDetails(this.getChildAwardDetails());
        return awardType;
    }

    private AwardType.AwardSpecialReviews getAwardSpecialReviews() {
        AwardType.AwardSpecialReviews awardSpecialReviews = (AwardType.AwardSpecialReviews)AwardType.AwardSpecialReviews.Factory.newInstance();
        LinkedList<SpecialReviewType> specialReviewTypesList = new LinkedList<SpecialReviewType>();
        List<AwardSpecialReview> specialReviewList = this.award.getSpecialReviews();
        for (AwardSpecialReview awardSpecialReview : specialReviewList) {
            SpecialReviewType specialReviewType = this.getAwardSpecialReview(awardSpecialReview);
            specialReviewTypesList.add(specialReviewType);
        }
        awardSpecialReviews.setSpecialReviewArray(specialReviewTypesList.toArray(new SpecialReviewType[0]));
        return awardSpecialReviews;
    }

    private AwardType.AwardTransferringSponsors getAwardTransferringSponsors() {
        AwardType.AwardTransferringSponsors transferringSponsors = (AwardType.AwardTransferringSponsors)AwardType.AwardTransferringSponsors.Factory.newInstance();
        LinkedList<AwardType.AwardTransferringSponsors.TransferringSponsor> transferringSponsorList = new LinkedList<AwardType.AwardTransferringSponsors.TransferringSponsor>();
        List<AwardTransferringSponsor> awardTransferringSponsorList = this.award.getAwardTransferringSponsors();
        for (AwardTransferringSponsor awardTransferringSponsor : awardTransferringSponsorList) {
            AwardType.AwardTransferringSponsors.TransferringSponsor transferringSponsor = this.getAwardTransferringSponsor(awardTransferringSponsor);
            transferringSponsorList.add(transferringSponsor);
        }
        transferringSponsors.setTransferringSponsorArray(transferringSponsorList.toArray(new AwardType.AwardTransferringSponsors.TransferringSponsor[0]));
        return transferringSponsors;
    }

    private AwardType.AwardPaymentSchedules getAwardPaymentSchedules() {
        AwardType.AwardPaymentSchedules awardPaymentSchedules = (AwardType.AwardPaymentSchedules)AwardType.AwardPaymentSchedules.Factory.newInstance();
        LinkedList<AwardType.AwardPaymentSchedules.PaymentSchedule> paymentSchedulesList = new LinkedList<AwardType.AwardPaymentSchedules.PaymentSchedule>();
        for (AwardPaymentSchedule awardPaymentSchedule : this.award.getPaymentScheduleItems()) {
            AwardType.AwardPaymentSchedules.PaymentSchedule paymentSchedule = this.getAwardPaymentSchedule(awardPaymentSchedule);
            paymentSchedulesList.add(paymentSchedule);
        }
        awardPaymentSchedules.setPaymentScheduleArray(paymentSchedulesList.toArray(new AwardType.AwardPaymentSchedules.PaymentSchedule[0]));
        return awardPaymentSchedules;
    }

    private AwardType.AwardOtherDatas getAwardOtherDatas() {
        AwardType.AwardOtherDatas awardOtherDatas = (AwardType.AwardOtherDatas)AwardType.AwardOtherDatas.Factory.newInstance();
        CustomAttributeService.getSortedAttributeGroups(this.awardDocument.getCustomAttributeDocuments().values()).forEach((groupName, customAttributeDocList) -> {
            AwardType.AwardOtherDatas.OtherData otherData = awardOtherDatas.addNewOtherData();
            OtherGroupType otherGroupType = otherData.addNewOtherDetails();
            otherGroupType.setDescription((String)groupName);
            customAttributeDocList.forEach(customAttributeDocument -> this.award.getAwardCustomDataList().stream().filter(awardCustomData -> awardCustomData.getCustomAttributeId().equals(customAttributeDocument.getId())).findFirst().ifPresent(awardCustomData -> this.addAwardOtherDataGroup(otherGroupType, (AwardCustomData)awardCustomData)));
        });
        return awardOtherDatas;
    }

    private void addAwardOtherDataGroup(OtherGroupType otherGroupType, AwardCustomData awardCustomData) {
        awardCustomData.refreshReferenceObject("customAttribute");
        String attributeLabel = Optional.ofNullable(awardCustomData.getCustomAttribute()).map(CustomAttribute::getLabel).orElse("");
        OtherGroupDetailsType otherGroupDetailsType = otherGroupType.addNewOtherGroupDetails();
        otherGroupDetailsType.setColumnName(attributeLabel);
        otherGroupDetailsType.setColumnValue(CustomDataUtils.getFormattedValueString(awardCustomData));
    }

    private AwardType.AwardFundingSummary getAwardFundingSummary() {
        AwardType.AwardFundingSummary awardFundingSummary = (AwardType.AwardFundingSummary)AwardType.AwardFundingSummary.Factory.newInstance();
        awardFundingSummary.setFundingSummaryArray(this.getAwardAmountInfo().getAmountInfoArray());
        return awardFundingSummary;
    }

    private AwardType.AwardBudgetDetails getAwardBudgetDetails() {
        AwardType.AwardBudgetDetails awardBudgetDetails = (AwardType.AwardBudgetDetails)AwardType.AwardBudgetDetails.Factory.newInstance();
        ArrayList<AwardType.AwardBudgetDetails.BudgetDetails> budgetDetailsList = new ArrayList<AwardType.AwardBudgetDetails.BudgetDetails>();
        AwardBudgetDocument awardBudgetDocument = this.getBudgetDocument();
        if (awardBudgetDocument != null) {
            for (BudgetLineItem budgetLineItem : awardBudgetDocument.getBudget().getBudgetPeriod(0).getBudgetLineItems()) {
                AwardType.AwardBudgetDetails.BudgetDetails budgetDetails = (AwardType.AwardBudgetDetails.BudgetDetails)AwardType.AwardBudgetDetails.BudgetDetails.Factory.newInstance();
                budgetDetails.setAwardNumber(this.award.getAwardNumber());
                budgetDetails.setSequenceNumber(this.award.getSequenceNumber());
                budgetDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
                budgetDetails.setCostElementCode(budgetLineItem.getCostElement());
                budgetDetails.setCostElementDescription(budgetLineItem.getCostElementBO().getDescription());
                budgetDetails.setLineItemDescription(budgetLineItem.getLineItemDescription());
                budgetDetailsList.add(budgetDetails);
            }
        }
        awardBudgetDetails.setBudgetDetailsArray(budgetDetailsList.toArray(new AwardType.AwardBudgetDetails.BudgetDetails[0]));
        return awardBudgetDetails;
    }

    private AwardType.ChildAwardDetails getChildAwardDetails() {
        AwardType.ChildAwardDetails childAwardDetails = (AwardType.ChildAwardDetails)AwardType.ChildAwardDetails.Factory.newInstance();
        AwardHierarchy awardHierarchy = this.getAwardHierarchyService().loadAwardHierarchyBranch(this.award.getAwardNumber());
        List<AwardHierarchy> children = awardHierarchy.getChildren();
        for (AwardHierarchy awardHierarchy2 : children) {
            this.setAwardHierarchy(awardHierarchy2, childAwardDetails);
        }
        return childAwardDetails;
    }

    private void setAwardHierarchy(AwardHierarchy awardHierarchy, AwardType.ChildAwardDetails childAwardDetails) {
        if (awardHierarchy != null) {
            ChildAwardType childAwardType = childAwardDetails.addNewChildAward();
            AwardHierarchyType hierarchyType = childAwardType.addNewAwardHierarchy();
            hierarchyType.setAwardNumber(awardHierarchy.getAwardNumber());
            hierarchyType.setParentAwardNumber(awardHierarchy.getParentAwardNumber());
            hierarchyType.setRootAwardNumber(awardHierarchy.getRootAwardNumber());
            this.setAwardAmountInfoDetails(awardHierarchy, childAwardType);
            List<AwardHierarchy> children = awardHierarchy.getChildren();
            for (AwardHierarchy awardHierarchy2 : children) {
                this.setAwardHierarchy(awardHierarchy2, childAwardDetails);
            }
        }
    }

    private void setAwardAmountInfoDetails(AwardHierarchy awardHierarchy, ChildAwardType childAwardType) {
        awardHierarchy.refreshReferenceObject("award");
        Award childAward = awardHierarchy.getAward();
        AwardAmountInfo awardAmountInfo = childAward.getLastAwardAmountInfo();
        if (awardHierarchy.getAward().getAccountNumber() != null) {
            childAwardType.setAccountNumber(awardHierarchy.getAward().getAccountNumber());
        }
        if (awardAmountInfo.getAnticipatedTotalAmount() != null) {
            childAwardType.setAnticipatedTotalAmt(awardAmountInfo.getAnticipatedTotalAmount().bigDecimalValue());
        }
        if (awardAmountInfo.getFinalExpirationDate() != null) {
            Calendar finalExpDate = this.dateTimeService.getCalendar((Date)awardAmountInfo.getFinalExpirationDate());
            childAwardType.setFinalExpirationDate(finalExpDate);
        }
        if (awardAmountInfo.getCurrentFundEffectiveDate() != null) {
            Calendar currentFundEffectiveDate = this.dateTimeService.getCalendar((Date)awardAmountInfo.getCurrentFundEffectiveDate());
            childAwardType.setCurrentFundEffectiveDate(currentFundEffectiveDate);
        }
        if (awardAmountInfo.getAmountObligatedToDate() != null) {
            childAwardType.setAmtObligatedToDate(awardAmountInfo.getAmountObligatedToDate().bigDecimalValue());
        }
        if (awardAmountInfo.getObligationExpirationDate() != null) {
            Calendar obligationExpirationDate = this.dateTimeService.getCalendar((Date)awardAmountInfo.getObligationExpirationDate());
            childAwardType.setObligationExpirationDate(obligationExpirationDate);
        }
        childAwardType.setPIName(childAward.getPrincipalInvestigator().getFullName());
    }

    @Override
    protected AwardNoticeDocument.AwardNotice.PrintRequirement getPrintRequirement(Map<String, Object> reportParameters) {
        AwardNoticeDocument.AwardNotice.PrintRequirement printRequirement = (AwardNoticeDocument.AwardNotice.PrintRequirement)AwardNoticeDocument.AwardNotice.PrintRequirement.Factory.newInstance();
        if (reportParameters != null) {
            printRequirement.setAddressListRequired(this.getPrintRequirementTypeRequired(reportParameters, ADDRESS_LIST));
            printRequirement.setCloseoutRequired(this.getPrintRequirementTypeRequired(reportParameters, CLOSEOUT));
            printRequirement.setCommentsRequired(this.getPrintRequirementTypeRequired(reportParameters, COMMENTS));
            printRequirement.setCostSharingRequired(this.getPrintRequirementTypeRequired(reportParameters, COST_SHARING));
            printRequirement.setEquipmentRequired(this.getPrintRequirementTypeRequired(reportParameters, EQUIPMENT));
            printRequirement.setFlowThruRequired(this.getPrintRequirementTypeRequired(reportParameters, FLOW_THRU));
            printRequirement.setForeignTravelRequired(this.getPrintRequirementTypeRequired(reportParameters, FOREIGN_TRAVEL));
            printRequirement.setFundingSummaryRequired(this.getPrintRequirementTypeRequired(reportParameters, FUNDING_SUMMARY));
            printRequirement.setHierarchyInfoRequired(this.getPrintRequirementTypeRequired(reportParameters, HIERARCHY_INFO));
            printRequirement.setIndirectCostRequired(this.getPrintRequirementTypeRequired(reportParameters, INDIRECT_COST));
            printRequirement.setPaymentRequired(this.getPrintRequirementTypeRequired(reportParameters, PAYMENT));
            printRequirement.setProposalDueRequired(this.getPrintRequirementTypeRequired(reportParameters, PROPOSAL_DUE));
            printRequirement.setSubcontractRequired(this.getPrintRequirementTypeRequired(reportParameters, SUBCONTRACT));
            printRequirement.setScienceCodeRequired(this.getPrintRequirementTypeRequired(reportParameters, SCIENCE_CODE));
            printRequirement.setSpecialReviewRequired(this.getPrintRequirementTypeRequired(reportParameters, SPECIAL_REVIEW));
            printRequirement.setTermsRequired(this.getPrintRequirementTypeRequired(reportParameters, TERMS));
            printRequirement.setTechnicalReportingRequired(this.getPrintRequirementTypeRequired(reportParameters, TECHNICAL_REPORTING));
            printRequirement.setReportingRequired(this.getPrintRequirementTypeRequired(reportParameters, REPORTING));
            printRequirement.setCurrentDate(this.dateTimeService.getCurrentCalendar());
            printRequirement.setOtherDataRequired(this.getPrintRequirementTypeRequired(reportParameters, "otherData"));
            printRequirement.setSignatureRequired(this.getPrintRequirementTypeRequired(reportParameters, "signatureRequired"));
        }
        return printRequirement;
    }

    private String getPrintRequirementTypeRequired(Map<String, Object> reportParameters, String printRequirementType) {
        String required = reportParameters.get(printRequirementType) != null && (Boolean)reportParameters.get(printRequirementType) != false ? "1" : "0";
        return required;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

