/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class UpgradeJobModelSnapshotRequest
implements Validatable,
ToXContentObject {
    public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final ParseField WAIT_FOR_COMPLETION = new ParseField("wait_for_completion", new String[0]);
    private static final ConstructingObjectParser<UpgradeJobModelSnapshotRequest, Void> PARSER = new ConstructingObjectParser("upgrade_job_snapshot_request", true, a -> new UpgradeJobModelSnapshotRequest((String)a[0], (String)a[1], (String)a[2], (Boolean)a[3]));
    private final String jobId;
    private final String snapshotId;
    private final TimeValue timeout;
    private final Boolean waitForCompletion;

    UpgradeJobModelSnapshotRequest(String jobId, String snapshotId, String timeout, Boolean waitForCompletion) {
        this(jobId, snapshotId, timeout == null ? null : TimeValue.parseTimeValue((String)timeout, (String)TIMEOUT.getPreferredName()), waitForCompletion);
    }

    public UpgradeJobModelSnapshotRequest(String jobId, String snapshotId, TimeValue timeValue, Boolean waitForCompletion) {
        this.jobId = Objects.requireNonNull(jobId, Job.ID.getPreferredName());
        this.snapshotId = Objects.requireNonNull(snapshotId, SNAPSHOT_ID.getPreferredName());
        this.timeout = timeValue;
        this.waitForCompletion = waitForCompletion;
    }

    public static UpgradeJobModelSnapshotRequest fromXContent(XContentParser parser) {
        return (UpgradeJobModelSnapshotRequest)PARSER.apply(parser, null);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public Boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeJobModelSnapshotRequest request = (UpgradeJobModelSnapshotRequest)o;
        return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.timeout, request.timeout) && Objects.equals(this.waitForCompletion, request.waitForCompletion) && Objects.equals(this.snapshotId, request.snapshotId);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.snapshotId, this.timeout, this.waitForCompletion);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        if (this.timeout != null) {
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
        }
        if (this.waitForCompletion != null) {
            builder.field(WAIT_FOR_COMPLETION.getPreferredName(), this.waitForCompletion);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TIMEOUT);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), WAIT_FOR_COMPLETION);
    }
}

