/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.xml;

import java.util.Date;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.kuali.rice.core.api.util.RiceConstants;

public class XmlRenderer {
    private Namespace namespace;

    public XmlRenderer() {
    }

    public XmlRenderer(Namespace namespace) {
        this.namespace = namespace;
    }

    public Element renderElement(Element parent, String elementName) {
        Element element = new Element(elementName, this.namespace);
        if (parent != null) {
            parent.addContent((Content)element);
        }
        return element;
    }

    public Element renderTextElement(Element parent, String elementName, String text) {
        Element element = null;
        if (text != null) {
            element = this.renderElement(parent, elementName);
            element.setText(text);
        }
        return element;
    }

    public Element renderBooleanElement(Element parent, String elementName, Boolean bool, boolean defaultValue) {
        if (bool == null) {
            bool = new Boolean(defaultValue);
        }
        return this.renderTextElement(parent, elementName, bool != false ? "true" : "false");
    }

    public Element renderDateElement(Element parent, String elementName, Date date) {
        Element element = null;
        if (date != null) {
            element = this.renderTextElement(parent, elementName, RiceConstants.getDefaultDateFormat().format(date));
        }
        return element;
    }

    public void renderAttribute(Element element, String attributeName, String attributeValue) {
        element.setAttribute(attributeName, attributeValue);
    }

    public Element renderCDATAElement(Element parent, String elementName, String data) {
        Element element = null;
        if (data != null) {
            element = this.renderElement(parent, elementName);
            element.addContent((Content)new CDATA(data));
        }
        return element;
    }
}

