/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.rest.editor;

import java.beans.PropertyEditorSupport;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class CustomSqlDateEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String value) {
        this.setValue(value);
    }

    @Override
    public Object getValue() {
        ArrayList<SimpleDateFormat> knownFormats = new ArrayList<SimpleDateFormat>();
        knownFormats.add(new SimpleDateFormat("MM/dd/yyyy"));
        knownFormats.add(new SimpleDateFormat("MM/dd/yyyy"));
        knownFormats.add(new SimpleDateFormat("yyyy-MM-dd"));
        knownFormats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        SimpleDateFormat target = new SimpleDateFormat("yyyy-MM-dd");
        String oldDate = super.getValue().toString();
        if (super.getValue() == null || StringUtils.isBlank((CharSequence)oldDate)) {
            return null;
        }
        for (SimpleDateFormat format : knownFormats) {
            try {
                return Date.valueOf(target.format(format.parse(oldDate)));
            }
            catch (ParseException parseException) {
            }
        }
        try {
            return new Date(Long.parseLong(oldDate));
        }
        catch (NumberFormatException e) {
            try {
                return new Date(target.parse(oldDate).getTime());
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

