/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.resilience;

import java.util.Map;
import java.util.Objects;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.impl.internal.resilience.AbstractResilienceStrategy;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.resilience.RecoveryStore;
import org.ehcache.spi.resilience.StoreAccessException;

public class RobustLoaderWriterResilienceStrategy<K, V>
extends AbstractResilienceStrategy<K, V> {
    private final CacheLoaderWriter<? super K, V> loaderWriter;

    public RobustLoaderWriterResilienceStrategy(RecoveryStore<K> store, CacheLoaderWriter<? super K, V> loaderWriter) {
        super(store);
        this.loaderWriter = Objects.requireNonNull(loaderWriter);
    }

    public V getFailure(K key, StoreAccessException e) {
        try {
            Object object = this.loaderWriter.load(key);
            return (V)object;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheLoadingException((Exception)e1, (Exception)((Object)e));
        }
        finally {
            this.cleanup(key, e);
        }
    }

    public boolean containsKeyFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
        return false;
    }

    public void putFailure(K key, V value, StoreAccessException e) {
        try {
            this.loaderWriter.write(key, value);
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
        }
        finally {
            this.cleanup(key, e);
        }
    }

    public void removeFailure(K key, StoreAccessException e) {
        try {
            this.loaderWriter.delete(key);
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
        }
        finally {
            this.cleanup(key, e);
        }
    }

    public void clearFailure(StoreAccessException e) {
        this.cleanup(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V putIfAbsentFailure(K key, V value, StoreAccessException e) {
        try {
            Object loaded = this.loaderWriter.load(key);
            if (loaded != null) {
                Object object = loaded;
                return (V)object;
            }
            try {
                this.loaderWriter.write(key, value);
                return null;
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
            }
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheLoadingException((Exception)e1, (Exception)((Object)e));
        }
        finally {
            this.cleanup(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFailure(K key, V value, StoreAccessException e) {
        try {
            Object loadedValue;
            try {
                loadedValue = this.loaderWriter.load(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheLoadingException((Exception)e1, (Exception)((Object)e));
            }
            if (loadedValue == null) {
                boolean e1 = false;
                return e1;
            }
            if (!loadedValue.equals(value)) {
                boolean e1 = false;
                return e1;
            }
            try {
                this.loaderWriter.delete(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.cleanup(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V replaceFailure(K key, V value, StoreAccessException e) {
        try {
            Object oldValue;
            try {
                oldValue = this.loaderWriter.load(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheLoadingException((Exception)e1, (Exception)((Object)e));
            }
            if (oldValue != null) {
                try {
                    this.loaderWriter.write(key, value);
                }
                catch (Exception e1) {
                    throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
                }
            }
            Object object = oldValue;
            return (V)object;
        }
        finally {
            this.cleanup(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceFailure(K key, V value, V newValue, StoreAccessException e) {
        try {
            Object oldValue;
            try {
                oldValue = this.loaderWriter.load(key);
            }
            catch (Exception e1) {
                throw ExceptionFactory.newCacheLoadingException((Exception)e1, (Exception)((Object)e));
            }
            if (oldValue != null && oldValue.equals(value)) {
                try {
                    this.loaderWriter.write(key, newValue);
                    boolean e1 = true;
                    return e1;
                }
                catch (Exception e1) {
                    throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanup(key, e);
        }
    }

    public Map<K, V> getAllFailure(Iterable<? extends K> keys, StoreAccessException e) {
        try {
            Map map = this.loaderWriter.loadAll(keys);
            return map;
        }
        catch (BulkCacheLoadingException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheLoadingException((Exception)e1, (Exception)((Object)e));
        }
        finally {
            this.cleanup(keys, e);
        }
    }

    public void putAllFailure(Map<? extends K, ? extends V> entries, StoreAccessException e) {
        try {
            this.loaderWriter.writeAll(entries.entrySet());
        }
        catch (BulkCacheWritingException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
        }
        finally {
            this.cleanup(entries.keySet(), e);
        }
    }

    public void removeAllFailure(Iterable<? extends K> keys, StoreAccessException e) {
        try {
            this.loaderWriter.deleteAll(keys);
        }
        catch (BulkCacheWritingException e1) {
            throw e1;
        }
        catch (Exception e1) {
            throw ExceptionFactory.newCacheWritingException((Exception)e1, (Exception)((Object)e));
        }
        finally {
            this.cleanup(keys, e);
        }
    }
}

