/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.session;

import com.codiform.moo.NoDestinationException;
import com.codiform.moo.TranslationException;
import com.codiform.moo.session.TranslationCache;
import com.codiform.moo.session.TranslationSource;
import com.codiform.moo.translator.CachingTranslatorFactory;
import com.codiform.moo.translator.DefaultObjectTargetFactory;
import com.codiform.moo.translator.ObjectTranslator;
import com.codiform.moo.translator.TranslationTargetFactory;
import com.codiform.moo.translator.TranslatorFactory;
import com.codiform.moo.translator.ValueTypeTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TranslationSession
implements TranslationSource {
    protected TranslationCache translationCache = new TranslationCache();
    private TranslatorFactory translatorFactory;
    private Map<String, Object> variables;
    protected Map<Class<? extends TranslationTargetFactory>, TranslationTargetFactory> translationTargetFactoryCache;

    public TranslationSession() {
        this(new CachingTranslatorFactory());
    }

    public TranslationSession(TranslatorFactory translatorFactory) {
        this.translatorFactory = translatorFactory;
        this.translationTargetFactoryCache = new HashMap<Class<? extends TranslationTargetFactory>, TranslationTargetFactory>();
    }

    public TranslationSession(TranslatorFactory translatorFactory, Map<String, Object> variables) {
        this(translatorFactory);
        this.variables = variables;
    }

    @Override
    public <T> T getTranslation(Object source, Class<T> destinationClass) {
        return this.getTranslation(source, DefaultObjectTargetFactory.class, destinationClass);
    }

    @Override
    public <T> T getTranslation(Object source, Class<? extends TranslationTargetFactory> factory, Class<T> destinationClass) {
        T translated = this.translationCache.getTranslation(source, destinationClass);
        if (translated == null) {
            translated = this.translate(source, factory, destinationClass);
        }
        return translated;
    }

    @Override
    public void update(Object source, Object destination) {
        this.assureDestination(destination);
        this.translatorFactory.getTranslator(destination.getClass()).castAndUpdate(source, destination, this, this.variables);
    }

    private void assureDestination(Object destination) {
        if (destination == null) {
            throw new NoDestinationException();
        }
    }

    private <T> T translate(Object source, Class<? extends TranslationTargetFactory> factory, Class<T> destinationClass) {
        if (source == null) {
            return null;
        }
        ValueTypeTranslator<T> vtt = this.translatorFactory.getValueTypeTranslator(destinationClass);
        if (vtt != null) {
            return vtt.getTranslation(source, destinationClass);
        }
        return this.getObjectTranslation(source, factory, destinationClass);
    }

    private <T, S extends T> T getObjectTranslation(Object source, Class<? extends TranslationTargetFactory> factoryType, Class<T> destinationClass) {
        TranslationTargetFactory factory = this.getTranslationTargetFactory(factoryType);
        T target = factory.getTranslationTargetInstance(source, destinationClass);
        if (target == null) {
            throw new TranslationException("Translation target factory (" + factory + ") returned null instance; cannot translate.");
        }
        this.translationCache.putTranslation(source, target);
        Class<?> targetClass = target.getClass();
        ObjectTranslator<?> translator = this.getTranslator(targetClass);
        translator.update(source, target, this, this.variables);
        return target;
    }

    @Override
    public TranslationTargetFactory getTranslationTargetFactory(Class<? extends TranslationTargetFactory> factoryType) {
        if (this.translationTargetFactoryCache.containsKey(factoryType)) {
            return this.translationTargetFactoryCache.get(factoryType);
        }
        try {
            TranslationTargetFactory instance = factoryType.newInstance();
            this.translationTargetFactoryCache.put(factoryType, instance);
            return instance;
        }
        catch (InstantiationException cause) {
            throw new TranslationException("Could not create translation target factory: " + factoryType, cause);
        }
        catch (IllegalAccessException cause) {
            throw new TranslationException("Could not create translation target factory: " + factoryType, cause);
        }
    }

    private <T> ObjectTranslator<T> getTranslator(Class<T> destination) {
        return this.translatorFactory.getTranslator(destination);
    }

    @Override
    public <T> List<T> getEachTranslation(List<?> sources, Class<T> destinationClass) {
        ArrayList<T> results = new ArrayList<T>();
        for (Object source : sources) {
            results.add(this.getTranslation(source, destinationClass));
        }
        return results;
    }

    @Override
    public <T> Set<T> getEachTranslation(Set<?> sources, Class<T> destinationClass) {
        HashSet<T> results = new HashSet<T>();
        for (Object source : sources) {
            results.add(this.getTranslation(source, destinationClass));
        }
        return results;
    }

    @Override
    public <T> Collection<T> getEachTranslation(Collection<?> sources, Class<T> destinationClass) {
        ArrayList<T> results = new ArrayList<T>();
        for (Object source : sources) {
            results.add(this.getTranslation(source, destinationClass));
        }
        return results;
    }
}

