/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.core.framework.security.XStreamSecurityService;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationResponseBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.service.NotificationMessageContentService;
import org.kuali.rice.ken.util.CompoundNamespaceContext;
import org.kuali.rice.ken.util.ConfiguredNamespaceContext;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NotificationMessageContentServiceImpl
implements NotificationMessageContentService {
    private static final Logger LOG = LogManager.getLogger(NotificationMessageContentServiceImpl.class);
    static final String CONTENT_TYPE_NAMESPACE_PREFIX = "ns:notification/ContentType";
    private static final DateFormat DATEFORMAT_CURR_TZ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    private final DataObjectService dataObjectService;
    private final NotificationContentTypeService notificationContentTypeService;
    private final XStreamSecurityService xStreamSecurityService;

    public NotificationMessageContentServiceImpl(DataObjectService dataObjectService, NotificationContentTypeService notificationContentTypeService, XStreamSecurityService xStreamSecurityService) {
        this.dataObjectService = dataObjectService;
        this.notificationContentTypeService = notificationContentTypeService;
        this.xStreamSecurityService = xStreamSecurityService;
    }

    @Override
    public NotificationBo parseNotificationRequestMessage(String notificationMessageAsXml) throws IOException, XmlException {
        byte[] bytes = notificationMessageAsXml.getBytes();
        return this.parseNotificationRequestMessage(bytes);
    }

    @Override
    public NotificationBo parseNotificationRequestMessage(InputStream stream) throws IOException, XmlException {
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        return this.parseNotificationRequestMessage(bytes);
    }

    private NotificationBo parseNotificationRequestMessage(byte[] bytes) throws IOException, XmlException {
        Document doc;
        try {
            doc = Util.parseWithNotificationEntityResolver(new InputSource(new ByteArrayInputStream(bytes)), true, true, this.notificationContentTypeService);
        }
        catch (ParserConfigurationException pce) {
            throw new XmlException("Error obtaining XML parser", (Throwable)pce);
        }
        catch (SAXException se) {
            throw new XmlException("Error validating notification request", (Throwable)se);
        }
        Element root = doc.getDocumentElement();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(Util.getNotificationNamespaceContext(doc));
        LOG.debug("URI: " + xpath.getNamespaceContext().getNamespaceURI("nreq"));
        try {
            Date d;
            NotificationBo notification = new NotificationBo();
            String channelName = xpath.evaluate("/nreq:notification/nreq:channel", root);
            LOG.debug("CHANNELNAME: " + channelName);
            String producerName = xpath.evaluate("/nreq:notification/nreq:producer", root);
            ArrayList<String> senders = new ArrayList<String>();
            NodeList nodes = (NodeList)xpath.evaluate("/nreq:notification/nreq:senders/nreq:sender", root, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                LOG.debug("sender node: " + String.valueOf(nodes.item(i)));
                LOG.debug("sender node VALUE: " + nodes.item(i).getTextContent());
                senders.add(nodes.item(i).getTextContent());
            }
            nodes = (NodeList)xpath.evaluate("/nreq:notification/nreq:recipients/nreq:group|/nreq:notification/nreq:recipients/nreq:user", root, XPathConstants.NODESET);
            ArrayList<NotificationRecipientBo> recipients = new ArrayList<NotificationRecipientBo>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                NotificationRecipientBo recipient = new NotificationRecipientBo();
                if ("GROUP".equalsIgnoreCase(node.getLocalName())) {
                    recipient.setRecipientType(KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
                    recipient.setRecipientId(KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(Utilities.parseGroupNamespaceCode(node.getTextContent()), Utilities.parseGroupName(node.getTextContent())).getId());
                } else if ("USER".equalsIgnoreCase(node.getLocalName())) {
                    recipient.setRecipientType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
                    recipient.setRecipientId(node.getTextContent());
                } else {
                    throw new XmlException("Invalid 'recipientType' value: '" + node.getLocalName() + "'.  Needs to either be 'user' or 'group'");
                }
                recipient.setNotification(notification);
                recipients.add(recipient);
            }
            String deliveryType = xpath.evaluate("/nreq:notification/nreq:deliveryType", root);
            String sendDateTime = xpath.evaluate("/nreq:notification/nreq:sendDateTime", root);
            String autoRemoveDateTime = xpath.evaluate("/nreq:notification/nreq:autoRemoveDateTime", root);
            String priorityName = xpath.evaluate("/nreq:notification/nreq:priority", root);
            String title = xpath.evaluate("/nreq:notification/nreq:title", root);
            String contentTypeName = xpath.evaluate("/nreq:notification/nreq:contentType", root);
            if (!StringUtils.isBlank((String)title)) {
                notification.setTitle(title);
            }
            NotificationChannelBo channel = (NotificationChannelBo)((Object)Util.retrieveFieldReference("channel", "name", channelName, NotificationChannelBo.class, this.dataObjectService));
            notification.setChannel(channel);
            NotificationProducerBo producer = (NotificationProducerBo)((Object)Util.retrieveFieldReference("producer", "name", producerName, NotificationProducerBo.class, this.dataObjectService));
            notification.setProducer(producer);
            for (String sender : senders) {
                NotificationSenderBo ns = new NotificationSenderBo();
                LOG.debug("Setting sender: " + sender);
                ns.setSenderName(sender);
                ns.setNotification(notification);
                notification.addSender(ns);
            }
            for (NotificationRecipientBo recipient : recipients) {
                LOG.debug("Setting recipient id: " + recipient.getRecipientId());
                notification.addRecipient(recipient);
            }
            if (!"ACK".equalsIgnoreCase(deliveryType) && !"FYI".equalsIgnoreCase(deliveryType)) {
                throw new XmlException("Invalid 'deliveryType' value: '" + deliveryType + "'.  Must be either 'ACK' or 'FYI'.");
            }
            notification.setDeliveryType(deliveryType);
            if (StringUtils.isNotBlank((String)sendDateTime)) {
                try {
                    d = Util.parseXSDDateTime(sendDateTime);
                }
                catch (ParseException pe) {
                    throw new XmlException("Invalid 'sendDateTime' value: " + sendDateTime, (Throwable)pe);
                }
                notification.setSendDateTimeValue(new Timestamp(d.getTime()));
            }
            if (StringUtils.isNotBlank((String)autoRemoveDateTime)) {
                try {
                    d = Util.parseXSDDateTime(autoRemoveDateTime);
                }
                catch (ParseException pe) {
                    throw new XmlException("Invalid 'autoRemoveDateTime' value: " + autoRemoveDateTime, (Throwable)pe);
                }
                notification.setAutoRemoveDateTimeValue(new Timestamp(d.getTime()));
            }
            NotificationPriorityBo priority = (NotificationPriorityBo)((Object)Util.retrieveFieldReference("priority", "name", priorityName, NotificationPriorityBo.class, this.dataObjectService));
            notification.setPriority(priority);
            NotificationContentTypeBo contentType = (NotificationContentTypeBo)((Object)Util.retrieveFieldReference("contentType", "name", contentTypeName, NotificationContentTypeBo.class, this.dataObjectService, Boolean.TRUE));
            notification.setContentType(contentType);
            HashMap<String, String> contentTypeNamespace = new HashMap<String, String>();
            String ephemeralNamespace = "contentNS_" + System.currentTimeMillis();
            contentTypeNamespace.put(ephemeralNamespace, CONTENT_TYPE_NAMESPACE_PREFIX + contentType.getName());
            xpath.setNamespaceContext(new CompoundNamespaceContext(new ConfiguredNamespaceContext(contentTypeNamespace), xpath.getNamespaceContext()));
            Node contentNode = (Node)xpath.evaluate("/nreq:notification/" + ephemeralNamespace + ":content", root, XPathConstants.NODE);
            if (contentNode == null) {
                throw new XmlException("The 'content' element is mandatory.");
            }
            if (!(contentNode instanceof Element)) {
                throw new XmlException("The 'content' node is not an Element! (???).");
            }
            Element contentElement = (Element)contentNode;
            String content = XmlJotter.jotNode((Node)contentNode, (boolean)true);
            notification.setContent(content);
            LOG.debug("Content type: " + contentType.getName());
            LOG.debug("Content: " + content);
            this.validateContent(notification, contentType.getName(), contentElement, content);
            return notification;
        }
        catch (XPathExpressionException xpee) {
            throw new XmlException("Error parsing request", (Throwable)xpee);
        }
    }

    private void validateContent(NotificationBo notification, String contentType, Element contentElement, String content) throws XmlException {
        String contentTypeTitleCase = Character.toTitleCase(contentType.charAt(0)) + contentType.substring(1);
        String expectedNamespaceURI = CONTENT_TYPE_NAMESPACE_PREFIX + contentTypeTitleCase;
        String actualNamespaceURI = contentElement.getNamespaceURI();
        if (!actualNamespaceURI.equals(expectedNamespaceURI)) {
            throw new XmlException("Namespace URI of 'content' node, '" + actualNamespaceURI + "', does not match expected namespace URI, '" + expectedNamespaceURI + "', for content type '" + contentType + "'");
        }
    }

    @Override
    public String generateNotificationResponseMessage(NotificationResponseBo response) {
        XStream xstream = this.xStreamSecurityService.applySecurityRules(new XStream((HierarchicalStreamDriver)new DomDriver()));
        xstream.alias("response", NotificationResponseBo.class);
        xstream.alias("status", String.class);
        xstream.alias("message", String.class);
        xstream.alias("notificationId", Long.class);
        return xstream.toXML((Object)response);
    }

    @Override
    public String generateNotificationMessage(NotificationBo notification, String userRecipientId) {
        NotificationBo clone = Util.cloneNotificationWithoutObjectReferences(notification);
        if (StringUtils.isNotBlank((String)userRecipientId)) {
            clone.getRecipients().clear();
            NotificationRecipientBo recipient = new NotificationRecipientBo();
            recipient.setRecipientId(userRecipientId);
            recipient.setRecipientType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
            clone.getRecipients().add(recipient);
        }
        XStream xstream = this.xStreamSecurityService.applySecurityRules(new XStream((HierarchicalStreamDriver)new DomDriver()));
        xstream.alias("notification", NotificationBo.class);
        xstream.alias("channel", NotificationChannelBo.class);
        xstream.alias("contentType", NotificationContentTypeBo.class);
        xstream.alias("title", String.class);
        xstream.alias("priority", NotificationPriorityBo.class);
        xstream.alias("producer", NotificationProducerBo.class);
        xstream.alias("recipient", NotificationRecipientBo.class);
        xstream.alias("sender", NotificationSenderBo.class);
        return xstream.toXML((Object)clone);
    }

    @Override
    public String generateNotificationMessage(NotificationBo notification) {
        return this.generateNotificationMessage(notification, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationBo parseSerializedNotificationXml(byte[] xmlAsBytes) {
        Document doc;
        NotificationBo notification = new NotificationBo();
        try {
            doc = Util.parse(new InputSource(new ByteArrayInputStream(xmlAsBytes)), false, false, null);
        }
        catch (Exception pce) {
            throw new XmlException("Error obtaining XML parser", (Throwable)pce);
        }
        Element root = doc.getDocumentElement();
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(Util.getNotificationNamespaceContext(doc));
        try {
            NotificationRecipientBo recipient;
            String title = xpath.evaluate("//notification/title", root).trim();
            String channelName = xpath.evaluate("//notification/channel/name", root).trim();
            String contentTypeName = xpath.evaluate("//notification/contentType/name", root).trim();
            String priorityName = xpath.evaluate("//notification/priority/name", root).trim();
            ArrayList<String> senders = new ArrayList<String>();
            NodeList senderNodes = (NodeList)xpath.evaluate("//notification/senders/sender/senderName", root, XPathConstants.NODESET);
            for (int i = 0; i < senderNodes.getLength(); ++i) {
                senders.add(senderNodes.item(i).getTextContent().trim());
            }
            String deliveryType = xpath.evaluate("//notification/deliveryType", root).trim();
            deliveryType = deliveryType.equalsIgnoreCase("FYI") ? "FYI" : "ACK";
            String sendDateTime = xpath.evaluate("//notification/sendDateTime", root).trim();
            String autoRemoveDateTime = xpath.evaluate("//notification/autoRemoveDateTime", root).trim();
            ArrayList<String> userRecipients = new ArrayList<String>();
            ArrayList<String> workgroupRecipients = new ArrayList<String>();
            NodeList recipientIds = (NodeList)xpath.evaluate("//notification/recipients/recipient/recipientId", root, XPathConstants.NODESET);
            NodeList recipientTypes = (NodeList)xpath.evaluate("//notification/recipients/recipient/recipientType", root, XPathConstants.NODESET);
            for (int i = 0; i < recipientIds.getLength(); ++i) {
                if (KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode().equalsIgnoreCase(recipientTypes.item(i).getTextContent().trim())) {
                    userRecipients.add(recipientIds.item(i).getTextContent().trim());
                    continue;
                }
                workgroupRecipients.add(recipientIds.item(i).getTextContent().trim());
            }
            String content = xpath.evaluate("//notification/content", root).trim();
            NotificationChannelBo channel = (NotificationChannelBo)((Object)Util.retrieveFieldReference("channel", "name", channelName, NotificationChannelBo.class, this.dataObjectService));
            notification.setChannel(channel);
            NotificationPriorityBo priority = (NotificationPriorityBo)((Object)Util.retrieveFieldReference("priority", "name", priorityName, NotificationPriorityBo.class, this.dataObjectService));
            notification.setPriority(priority);
            NotificationContentTypeBo contentType = (NotificationContentTypeBo)((Object)Util.retrieveFieldReference("contentType", "name", contentTypeName, NotificationContentTypeBo.class, this.dataObjectService, Boolean.TRUE));
            notification.setContentType(contentType);
            NotificationProducerBo producer = (NotificationProducerBo)((Object)Util.retrieveFieldReference("producer", "name", "Notification System", NotificationProducerBo.class, this.dataObjectService));
            notification.setProducer(producer);
            for (String senderName : senders) {
                NotificationSenderBo ns = new NotificationSenderBo();
                ns.setSenderName(senderName);
                notification.addSender(ns);
            }
            for (String userRecipientId : userRecipients) {
                recipient = new NotificationRecipientBo();
                recipient.setRecipientType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
                recipient.setRecipientId(userRecipientId);
                notification.addRecipient(recipient);
            }
            for (String workgroupRecipientId : workgroupRecipients) {
                recipient = new NotificationRecipientBo();
                recipient.setRecipientType(KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode());
                recipient.setRecipientId(workgroupRecipientId);
                notification.addRecipient(recipient);
            }
            if (!StringUtils.isBlank((String)title)) {
                notification.setTitle(title);
            }
            notification.setDeliveryType(deliveryType);
            DateFormat dateFormat = DATEFORMAT_CURR_TZ;
            synchronized (dateFormat) {
                Date d = null;
                if (StringUtils.isNotBlank((String)sendDateTime)) {
                    try {
                        d = DATEFORMAT_CURR_TZ.parse(sendDateTime);
                    }
                    catch (ParseException pe) {
                        LOG.warn("Invalid 'sendDateTime' value: " + sendDateTime, (Throwable)pe);
                    }
                    notification.setSendDateTimeValue(new Timestamp(d.getTime()));
                }
                Date d2 = null;
                if (StringUtils.isNotBlank((String)autoRemoveDateTime)) {
                    try {
                        d2 = DATEFORMAT_CURR_TZ.parse(autoRemoveDateTime);
                    }
                    catch (ParseException pe) {
                        LOG.warn("Invalid 'autoRemoveDateTime' value: " + autoRemoveDateTime, (Throwable)pe);
                    }
                    notification.setAutoRemoveDateTimeValue(new Timestamp(d2.getTime()));
                }
            }
            notification.setContent(content);
            return notification;
        }
        catch (XPathExpressionException xpee) {
            throw new XmlException("Error parsing request", (Throwable)xpee);
        }
    }
}

