/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.impl.unit.admin.UnitAdministratorDerivedRoleTypeServiceImpl;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityHistoryLineBean;
import org.kuali.kra.negotiations.bo.NegotiationAssociatedDetailBean;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.bo.NegotiationsGroupingBase;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationNotification;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationServiceImpl
implements NegotiationService {
    static final String ZERO_DAYS_LONG_STRING = "0 Days";
    private static final String PARAMETER_DELIMITER = ",";
    private ParameterService parameterService;
    private AwardBudgetService awardBudgetService;
    private InstitutionalProposalService institutionalProposalService;
    private UnitAdministratorDerivedRoleTypeServiceImpl unitAdministratorDerivedRoleTypeServiceImpl;
    private KcPersonService kcPersonService;
    private VersionHistoryService versionHistoryService;
    private BusinessObjectService businessObjectService;

    @Override
    public List<String> getInProgressStatusCodes() {
        String value = this.getParameterService().getParameterValueAsString(NegotiationDocument.class, "negotiationInProgressStatusCodes");
        return Arrays.asList(value.split(PARAMETER_DELIMITER));
    }

    @Override
    public List<String> getCompletedStatusCodes() {
        String value = this.getParameterService().getParameterValueAsString(NegotiationDocument.class, "negotiationCompletedStatusCodes");
        return Arrays.asList(value.split(PARAMETER_DELIMITER));
    }

    @Override
    public String getCompleteStatusCode() {
        String value = this.getParameterService().getParameterValueAsString(NegotiationDocument.class, "CLOSED_NEGOTIATION_STATUS");
        return value;
    }

    @Override
    public Negotiable getAssociatedObject(Negotiation negotiation) {
        if (negotiation != null && negotiation.getNegotiationAssociationType() != null) {
            KcPersistableBusinessObjectBase bo = null;
            if (negotiation.getNegotiationAssociationType().isLinkedTo(Award.class)) {
                bo = this.getAward(negotiation.getAssociatedDocumentId());
            } else if (negotiation.getNegotiationAssociationType().isLinkedTo(InstitutionalProposal.class)) {
                bo = this.getInstitutionalProposal(negotiation.getAssociatedDocumentId());
            } else if (negotiation.getNegotiationAssociationType().isUnassociated()) {
                negotiation.refreshReferenceObject("unAssociatedDetail");
                bo = negotiation.getUnAssociatedDetail();
            } else if (negotiation.getNegotiationAssociationType().isLinkedTo(ProposalLog.class)) {
                bo = this.getProposalLog(negotiation.getAssociatedDocumentId());
            } else if (negotiation.getNegotiationAssociationType().isLinkedTo(SubAward.class)) {
                bo = this.getSubAward(negotiation.getAssociatedDocumentId());
            }
            return bo;
        }
        return null;
    }

    @Override
    public NegotiationAssociatedDetailBean buildNegotiationAssociatedDetailBean(Negotiation negotiation) {
        negotiation.refreshReferenceObject("negotiationAssociationType");
        if (negotiation.getNegotiationAssociationType() != null) {
            Negotiable negotiable = negotiation.getAssociatedDocument();
            NegotiationAssociatedDetailBean bean = new NegotiationAssociatedDetailBean(negotiable);
            return bean;
        }
        return new NegotiationAssociatedDetailBean("");
    }

    private Award getAward(String awardNumber) {
        Award award = this.getAwardBudgetService().getActiveOrNewestAward(awardNumber);
        return award;
    }

    private ProposalLog getProposalLog(String proposalNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("PROPOSAL_NUMBER", proposalNumber);
        ProposalLog pl = (ProposalLog)this.getBusinessObjectService().findByPrimaryKey(ProposalLog.class, primaryKeys);
        return pl;
    }

    private SubAward getSubAward(String subAwardId) {
        VersionHistory versionHistory = this.getVersionHistoryService().getActiveOrNewestVersion(SubAward.class, subAwardId);
        if (versionHistory != null) {
            return (SubAward)versionHistory.getSequenceOwner();
        }
        return null;
    }

    private InstitutionalProposal getInstitutionalProposal(String proposalNumber) {
        InstitutionalProposal ip = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(proposalNumber);
        if (ip == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("PROPOSAL_NUMBER", proposalNumber);
            List proposals = this.businessObjectService.findMatching(InstitutionalProposal.class, params);
            if (proposals != null && proposals.size() > 0) {
                ip = (InstitutionalProposal)proposals.iterator().next();
            }
        }
        return ip;
    }

    @Override
    public List<Negotiation> getAssociatedNegotiations(BusinessObject bo) {
        List<Long> associationTypeIds = this.getAssociationTypeIdsLinkedTo(bo.getClass());
        String associatedId = null;
        if (bo instanceof ProposalLog) {
            ProposalLog propLog = (ProposalLog)bo;
            associatedId = propLog.getProposalNumber();
        } else if (bo instanceof InstitutionalProposal) {
            InstitutionalProposal ip = (InstitutionalProposal)bo;
            associatedId = ip.getProposalNumber();
        } else if (bo instanceof Award) {
            Award award = (Award)bo;
            associatedId = award.getAwardNumber();
        } else if (bo instanceof SubAward) {
            SubAward subAward = (SubAward)bo;
            associatedId = subAward.getSubAwardCode();
        }
        if (associationTypeIds.isEmpty() || associatedId == null) {
            return new ArrayList<Negotiation>();
        }
        return this.getAssociatedNegotiations(associatedId, associationTypeIds);
    }

    protected List<Long> getAssociationTypeIdsLinkedTo(Class boClass) {
        return this.getAssociationTypeIdsLinkedTo(boClass, false);
    }

    protected List<Long> getAssociationTypeIdsLinkedTo(Class boClass, boolean activeOnly) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("linkedBoClass", boClass.getSimpleName());
        if (activeOnly) {
            fieldValues.put("active", "Y");
        }
        return this.getBusinessObjectService().findMatching(NegotiationAssociationType.class, fieldValues).stream().map(NegotiationsGroupingBase::getId).collect(Collectors.toList());
    }

    protected List<Negotiation> getAssociatedNegotiations(String associatedId, List<Long> associationTypeIds) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("associatedDocumentId", associatedId);
        values.put("negotiationAssociationTypeId", associationTypeIds);
        return new ArrayList<Negotiation>(this.getBusinessObjectService().findMatching(Negotiation.class, values));
    }

    @Override
    public NegotiationAssociationType getNegotiationAssociationType(String associationTypeCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", associationTypeCode);
        return (NegotiationAssociationType)this.getBusinessObjectService().findMatching(NegotiationAssociationType.class, params).iterator().next();
    }

    @Override
    public NegotiationStatus getNegotiationStatus(String statusCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", statusCode);
        return (NegotiationStatus)this.getBusinessObjectService().findMatching(NegotiationStatus.class, params).iterator().next();
    }

    @Override
    public boolean isAwardLinkingEnabled() {
        return !this.getAssociationTypeIdsLinkedTo(Award.class, true).isEmpty();
    }

    @Override
    public boolean isInstitutionalProposalLinkingEnabled() {
        return !this.getAssociationTypeIdsLinkedTo(InstitutionalProposal.class, true).isEmpty();
    }

    @Override
    public boolean isNoModuleLinkingEnabled() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("linkedBoClass", "None");
        params.put("active", "Y");
        return this.getBusinessObjectService().countMatching(NegotiationAssociationType.class, params) > 0;
    }

    @Override
    public boolean isProposalLogLinkingEnabled() {
        return !this.getAssociationTypeIdsLinkedTo(ProposalLog.class, true).isEmpty();
    }

    @Override
    public boolean isSubawardLinkingEnabled() {
        return !this.getAssociationTypeIdsLinkedTo(SubAward.class, true).isEmpty();
    }

    protected boolean isNegotaitionAssociationTypeActive(String associationTypeCode) {
        NegotiationAssociationType nat = this.getNegotiationAssociationType(associationTypeCode);
        return nat.isActive();
    }

    @Override
    public void checkForPropLogPromotion(Negotiation negotiation) {
        ProposalLog propLog;
        if (negotiation.getNegotiationAssociationType() != null && negotiation.getNegotiationAssociationType().isLinkedTo(ProposalLog.class) && this.isInstitutionalProposalLinkingEnabled() && (propLog = (ProposalLog)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalLog.class, (Object)negotiation.getAssociatedDocumentId())) != null && StringUtils.isNotBlank((CharSequence)propLog.getInstProposalNumber())) {
            negotiation.setNegotiationAssociationType(this.getNegotiationAssociationType("IP"));
            InstitutionalProposal proposal = (InstitutionalProposal)this.getBusinessObjectService().findBySinglePrimaryKey(InstitutionalProposal.class, (Object)propLog.getInstProposalNumber());
            if (proposal != null) {
                negotiation.setNegotiationAssociationTypeId(negotiation.getNegotiationAssociationType().getId());
                negotiation.setAssociatedDocumentId(proposal.getProposalNumber());
            }
        }
    }

    @Override
    public NegotiationUnassociatedDetail findAndLoadNegotiationUnassociatedDetail(Negotiation negotiation) {
        if (negotiation.getNegotiationAssociationType() != null && negotiation.getNegotiationAssociationType().isUnassociated() && StringUtils.isNotEmpty((CharSequence)negotiation.getAssociatedDocumentId()) && negotiation.getAssociatedDocumentId().matches("\\d*")) {
            NegotiationUnassociatedDetail unAssociatedDetail = (NegotiationUnassociatedDetail)this.getBusinessObjectService().findBySinglePrimaryKey(NegotiationUnassociatedDetail.class, (Object)negotiation.getAssociatedDocumentId());
            return unAssociatedDetail;
        }
        return null;
    }

    @Override
    public List<NegotiationActivityHistoryLineBean> getNegotiationActivityHistoryLineBeans(List<NegotiationActivity> activities) {
        ArrayList<NegotiationActivityHistoryLineBean> beans = new ArrayList<NegotiationActivityHistoryLineBean>();
        for (NegotiationActivity activity : activities) {
            if (activity.getLocation() == null || activity.getActivityType() == null) continue;
            NegotiationActivityHistoryLineBean bean = new NegotiationActivityHistoryLineBean(activity);
            beans.add(bean);
        }
        Date previousStartDate = null;
        Date previousEndDate = null;
        String previousLocation = "";
        int counter = 1;
        ArrayList<NegotiationActivityHistoryLineBean> beansToReturn = new ArrayList<NegotiationActivityHistoryLineBean>();
        for (NegotiationActivityHistoryLineBean bean : beans) {
            if (StringUtils.equals((CharSequence)previousLocation, (CharSequence)bean.getLocation())) {
                if (this.isDateBetween(bean.getStartDate(), previousStartDate, previousEndDate) && this.isDateBetween(bean.getEndDate(), previousStartDate, previousEndDate)) {
                    this.setBeanStuff(bean, null, null, ZERO_DAYS_LONG_STRING);
                } else if (this.isDateBetween(bean.getStartDate(), previousStartDate, previousEndDate) && (bean.getEndDate() == null || bean.getEndDate().after(previousEndDate))) {
                    Date previousEndDatePlusOneDay = new Date(previousEndDate.getTime() + 86400000L);
                    previousEndDate = bean.getEndDate() != null ? bean.getEndDate() : new Date(Calendar.getInstance().getTimeInMillis());
                    this.setBeanStuff(bean, previousEndDatePlusOneDay, bean.getEndDate(), NegotiationActivity.getNumberOfDays(previousEndDatePlusOneDay, bean.getEndDate()));
                } else {
                    previousStartDate = bean.getStartDate();
                    previousEndDate = bean.getEndDate();
                    this.setBeanStuff(bean, bean.getStartDate(), bean.getEndDate(), NegotiationActivity.getNumberOfDays(bean.getStartDate(), bean.getEndDate()));
                }
            } else {
                previousStartDate = bean.getStartDate();
                previousEndDate = bean.getEndDate();
                previousLocation = bean.getLocation();
                this.setBeanStuff(bean, bean.getStartDate(), bean.getEndDate(), NegotiationActivity.getNumberOfDays(bean.getStartDate(), bean.getEndDate()));
                if (!beansToReturn.isEmpty()) {
                    beansToReturn.add(new NegotiationActivityHistoryLineBean());
                }
            }
            bean.setLineNumber(String.valueOf(counter));
            beansToReturn.add(bean);
            ++counter;
        }
        return beansToReturn;
    }

    @Override
    public List<NegotiationNotification> getNegotiationNotifications(Negotiation negotiation) {
        List<NegotiationNotification> notifications = new ArrayList<NegotiationNotification>();
        if (negotiation.getNegotiationDocument() != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("documentNumber", negotiation.getNegotiationDocument().getDocumentNumber());
            notifications = this.getBusinessObjectService().findMatching(NegotiationNotification.class, fieldValues);
        }
        return notifications;
    }

    private void setBeanStuff(NegotiationActivityHistoryLineBean bean, Date efectiveLocationStartDate, Date efectiveLocationEndDate, String locationDays) {
        bean.setEfectiveLocationEndDate(efectiveLocationEndDate);
        bean.setEfectiveLocationStartDate(efectiveLocationStartDate);
        bean.setLocationDays(locationDays);
    }

    private boolean isDateBetween(Date checkDate, Date rangeStart, Date rangeEnd) {
        if (rangeStart == null) {
            return false;
        }
        if (checkDate == null) {
            checkDate = new Date(Calendar.getInstance().getTimeInMillis());
        }
        if (rangeEnd == null) {
            rangeEnd = new Date(Calendar.getInstance().getTimeInMillis());
        }
        boolean startOk = rangeStart.equals(checkDate) || rangeStart.before(checkDate);
        boolean endOk = rangeEnd.equals(checkDate) || rangeEnd.after(checkDate);
        return startOk && endOk;
    }

    @Override
    public void promoteProposalLogNegotiation(String proposalLogProposalNumber, String institutionalProposalProposalNumber) {
        List<Negotiation> negotiations = this.getAssociatedNegotiations(proposalLogProposalNumber, this.getAssociationTypeIdsLinkedTo(ProposalLog.class));
        ArrayList<Negotiation> negotiationsToSave = new ArrayList<Negotiation>();
        if (negotiations != null && !negotiations.isEmpty()) {
            NegotiationAssociationType ipAssocationType = this.getNegotiationAssociationType("IP");
            for (Negotiation negotiation : negotiations) {
                negotiation.setNegotiationAssociationType(ipAssocationType);
                negotiation.setNegotiationAssociationTypeId(ipAssocationType.getId());
                negotiation.setAssociatedDocumentId(institutionalProposalProposalNumber);
                negotiationsToSave.add(negotiation);
            }
        }
        this.getBusinessObjectService().save(negotiationsToSave);
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AwardBudgetService getAwardBudgetService() {
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public UnitAdministratorDerivedRoleTypeServiceImpl getUnitAdministratorDerivedRoleTypeServiceImpl() {
        return this.unitAdministratorDerivedRoleTypeServiceImpl;
    }

    public void setUnitAdministratorDerivedRoleTypeServiceImpl(UnitAdministratorDerivedRoleTypeServiceImpl unitAdministratorDerivedRoleTypeServiceImpl) {
        this.unitAdministratorDerivedRoleTypeServiceImpl = unitAdministratorDerivedRoleTypeServiceImpl;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

