/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.budget.api.core.CostElementContract;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.BooleanNFConverter;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.data.jpa.FilterGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="COST_ELEMENT")
public class CostElement
extends KcPersistableBusinessObjectBase
implements Comparable<CostElement>,
MutableInactivatable,
CostElementContract {
    @Id
    @Column(name="COST_ELEMENT")
    private String costElement;
    @Column(name="BUDGET_CATEGORY_CODE")
    private String budgetCategoryCode;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="ON_OFF_CAMPUS_FLAG")
    @Convert(converter=BooleanNFConverter.class)
    private Boolean onOffCampusFlag;
    @Column(name="ACTIVE_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;
    @Column(name="FIN_OBJECT_CODE")
    private String financialObjectCode;
    @Column(name="UNIT_NUMBER")
    private String unitNumber;
    @ManyToOne(targetEntity=Unit.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="UNIT_NUMBER", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit unit;
    @OneToMany(mappedBy="costElementBo", fetch=FetchType.EAGER)
    @FilterGenerator(attributeName="active", attributeValue="true")
    private List<ValidCeRateType> validCeRateTypes = new ArrayList<ValidCeRateType>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_CATEGORY_CODE", referencedColumnName="BUDGET_CATEGORY_CODE", insertable=false, updatable=false)
    private BudgetCategory budgetCategory;
    @Transient
    private String budgetCategoryTypeCode;

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getCostElement() {
        return this.costElement;
    }

    public void setCostElement(String costElement) {
        this.costElement = costElement;
    }

    public String getBudgetCategoryCode() {
        return this.budgetCategoryCode;
    }

    public void setBudgetCategoryCode(String budgetCategoryCode) {
        this.budgetCategoryCode = budgetCategoryCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    public void setOnOffCampusFlag(Boolean onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<ValidCeRateType> getValidCeRateTypes() {
        return this.validCeRateTypes;
    }

    public void setValidCeRateTypes(List<ValidCeRateType> validCeRateTypes) {
        this.validCeRateTypes = validCeRateTypes;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public int compareTo(CostElement costElement) {
        return this.costElement.compareTo(costElement.costElement);
    }

    public BudgetCategory getBudgetCategory() {
        return this.budgetCategory;
    }

    public void setBudgetCategory(BudgetCategory budgetCategory) {
        this.budgetCategory = budgetCategory;
    }

    public String getBudgetCategoryTypeCode() {
        return this.budgetCategoryTypeCode;
    }

    public void setBudgetCategoryTypeCode(String budgetCategoryTypeCode) {
        this.budgetCategoryTypeCode = budgetCategoryTypeCode;
    }
}

