/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.collapse;

import java.util.List;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.InnerHitBuilder;

public class CollapseContext {
    private final String fieldName;
    private final MappedFieldType fieldType;
    private final List<InnerHitBuilder> innerHits;

    public CollapseContext(String fieldName, MappedFieldType fieldType, List<InnerHitBuilder> innerHits) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.innerHits = innerHits;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public MappedFieldType getFieldType() {
        return this.fieldType;
    }

    public List<InnerHitBuilder> getInnerHit() {
        return this.innerHits;
    }

    public CollapsingTopDocsCollector<?> createTopDocs(Sort sort, int topN, FieldDoc after) {
        if (this.fieldType.collapseType() == MappedFieldType.CollapseType.KEYWORD) {
            return CollapsingTopDocsCollector.createKeyword(this.fieldName, this.fieldType, sort, topN, after);
        }
        if (this.fieldType.collapseType() == MappedFieldType.CollapseType.NUMERIC) {
            return CollapsingTopDocsCollector.createNumeric(this.fieldName, this.fieldType, sort, topN, after);
        }
        throw new IllegalStateException("collapse is not supported on this field type");
    }
}

