/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.component;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.util.ChecksumUtils;
import org.kuali.rice.coreservice.api.component.Component;
import org.kuali.rice.coreservice.api.component.ComponentContract;
import org.kuali.rice.coreservice.api.component.ComponentService;
import org.kuali.rice.coreservice.impl.component.ComponentBo;
import org.kuali.rice.coreservice.impl.component.ComponentSetBo;
import org.kuali.rice.coreservice.impl.component.ComponentSetDao;
import org.kuali.rice.coreservice.impl.component.DerivedComponentBo;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ComponentServiceImpl
implements ComponentService {
    private static final Logger LOG = LogManager.getLogger(ComponentServiceImpl.class);
    private ComponentSetDao componentSetDao;
    private DataObjectService dataObjectService;

    public Component getComponentByCode(String namespaceCode, String componentCode) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        if (StringUtils.isBlank((String)componentCode)) {
            throw new RiceIllegalArgumentException("componentCode was a null or blank value");
        }
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("namespaceCode", namespaceCode);
        primaryKeys.put("code", componentCode);
        ComponentBo componentBo = (ComponentBo)((Object)this.dataObjectService.find(ComponentBo.class, (Object)new CompoundKey(primaryKeys)));
        if (componentBo != null) {
            return ComponentBo.to(componentBo);
        }
        DerivedComponentBo derivedComponentBo = (DerivedComponentBo)((Object)this.dataObjectService.find(DerivedComponentBo.class, (Object)new CompoundKey(primaryKeys)));
        return derivedComponentBo == null ? null : DerivedComponentBo.to(derivedComponentBo);
    }

    public List<Component> getAllComponentsByNamespaceCode(String namespaceCode) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespaceCode", namespaceCode);
        QueryResults componentBos = this.getDataObjectService().findMatching(ComponentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        QueryResults derivedComponentBos = this.getDataObjectService().findMatching(DerivedComponentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        return this.translateCollections((QueryResults<ComponentBo>)componentBos, (QueryResults<DerivedComponentBo>)derivedComponentBos);
    }

    public List<Component> getActiveComponentsByNamespaceCode(String namespaceCode) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("active", Boolean.TRUE);
        QueryResults componentBos = this.getDataObjectService().findMatching(ComponentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        criteria.remove("active");
        QueryResults derivedComponentBos = this.getDataObjectService().findMatching(DerivedComponentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        return this.translateCollections((QueryResults<ComponentBo>)componentBos, (QueryResults<DerivedComponentBo>)derivedComponentBos);
    }

    public List<Component> getDerivedComponentSet(String componentSetId) {
        if (StringUtils.isBlank((String)componentSetId)) {
            throw new RiceIllegalArgumentException("componentSetId was a null or blank value");
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("componentSetId", componentSetId);
        QueryResults derivedComponentBos = this.getDataObjectService().findMatching(DerivedComponentBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
        return this.translateCollections(null, (QueryResults<DerivedComponentBo>)derivedComponentBos);
    }

    @Transactional
    public void publishDerivedComponents(String componentSetId, List<Component> components) {
        String checksum;
        if (StringUtils.isBlank((String)componentSetId)) {
            throw new RiceIllegalArgumentException("componentSetId was a null or blank value");
        }
        components = this.validateAndNormalizeComponents(componentSetId, components);
        LOG.info("Requesting to publish " + components.size() + " derived components for componentSetId=" + componentSetId);
        ComponentSetBo componentSet = (ComponentSetBo)this.getDataObjectService().find(ComponentSetBo.class, (Object)componentSetId);
        if (componentSet == null) {
            componentSet = new ComponentSetBo();
            componentSet.setComponentSetId(componentSetId);
        }
        if (!(checksum = this.calculateChecksum(components)).equals(componentSet.getChecksum())) {
            LOG.info("Checksums were different, proceeding with update of derived components for componentSetId=" + componentSetId);
            componentSet.setChecksum(checksum);
            componentSet.setLastUpdateTimestamp(new Timestamp(System.currentTimeMillis()));
            if (this.getComponentSetDao().saveIgnoreLockingFailure(componentSet)) {
                this.updateDerivedComponents(componentSetId, components);
            }
        } else {
            LOG.info("Checksums were the same, no derived component update needed for componentSetId=" + componentSetId);
        }
    }

    protected List<Component> validateAndNormalizeComponents(String componentSetId, List<Component> components) {
        ArrayList<Component> processedComponents = new ArrayList<Component>();
        components = components == null ? new ArrayList<Component>() : new ArrayList<Component>(components);
        for (Component component : components) {
            String currentComponentSetId;
            if (component.getComponentSetId() == null) {
                Component.Builder builder = Component.Builder.create((ComponentContract)component);
                builder.setComponentSetId(componentSetId);
                component = builder.build();
            }
            if (!componentSetId.equals(currentComponentSetId = component.getComponentSetId())) {
                throw new RiceIllegalArgumentException("Encountered a component with an invalid componentSetId of '" + currentComponentSetId + "'.  Expected null or '" + componentSetId + "'.");
            }
            processedComponents.add(component);
        }
        return processedComponents;
    }

    protected String calculateChecksum(List<Component> components) {
        Collections.sort(components, new Comparator<Component>(this){

            @Override
            public int compare(Component component1, Component component2) {
                return CompareToBuilder.reflectionCompare((Object)component1, (Object)component2);
            }
        });
        return ChecksumUtils.calculateChecksum(components);
    }

    protected void updateDerivedComponents(String componentSetId, List<Component> components) {
        HashMap<String, String> deleteCriteria = new HashMap<String, String>();
        deleteCriteria.put("componentSetId", componentSetId);
        this.dataObjectService.deleteMatching(DerivedComponentBo.class, QueryByCriteria.Builder.andAttributes(deleteCriteria).build());
        this.dataObjectService.flush(DerivedComponentBo.class);
        if (CollectionUtils.isNotEmpty(components)) {
            ArrayList<DerivedComponentBo> derivedComponentBos = new ArrayList<DerivedComponentBo>();
            for (Component component : components) {
                derivedComponentBos.add(DerivedComponentBo.from(component));
            }
            for (DerivedComponentBo derivedComponentBo : derivedComponentBos) {
                this.dataObjectService.save((Object)derivedComponentBo, new PersistenceOption[0]);
            }
        }
    }

    protected List<Component> translateCollections(QueryResults<ComponentBo> componentBos, QueryResults<DerivedComponentBo> derivedComponentBos) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (componentBos != null && CollectionUtils.isNotEmpty((Collection)componentBos.getResults())) {
            for (ComponentBo componentBo : componentBos.getResults()) {
                components.add(ComponentBo.to(componentBo));
            }
        }
        if (derivedComponentBos != null && CollectionUtils.isNotEmpty((Collection)derivedComponentBos.getResults())) {
            for (DerivedComponentBo derivedComponentBo : derivedComponentBos.getResults()) {
                components.add(DerivedComponentBo.to(derivedComponentBo));
            }
        }
        return Collections.unmodifiableList(components);
    }

    public ComponentSetDao getComponentSetDao() {
        return this.componentSetDao;
    }

    public void setComponentSetDao(ComponentSetDao componentSetDao) {
        this.componentSetDao = componentSetDao;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

