/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.control.RadioGroupControl;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.InputFieldBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.KeyMessage;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="lookupCriteria", parent="Uif-LookupCriteriaInputField")
public class LookupInputField
extends InputFieldBase {
    private static final long serialVersionUID = -8294275596836322699L;
    private boolean disableWildcardsAndOperators;
    private boolean addControlSelectAllOption;
    private boolean ranged;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.addControlSelectAllOption && this.getControl() != null && this.getControl() instanceof MultiValueControl) {
            String allOptionText = KRADServiceLocatorWeb.getMessageService().getMessageText("option.all");
            MultiValueControl multiValueControl = (MultiValueControl)((Object)this.getControl());
            if (multiValueControl.getOptions() != null) {
                multiValueControl.getOptions().add(0, (KeyValue)new ConcreteKeyValue("", allOptionText));
            }
            if (multiValueControl.getRichOptions() != null) {
                Message message = ComponentFactory.getMessage();
                message.setMessageText(allOptionText);
                message.setRenderWrapperTag(false);
                multiValueControl.getRichOptions().add(0, new KeyMessage("", allOptionText, message));
            }
        }
    }

    @Override
    protected void addComponentPostMetadata() {
        ValidCharactersConstraint validCharactersConstraint;
        super.addComponentPostMetadata();
        Map<String, Map<String, Object>> lookupCriteriaFields = ViewLifecycle.getViewPostMetadata().getLookupCriteria();
        HashMap<String, Object> criteriaAttributes = new HashMap<String, Object>();
        criteriaAttributes.put("componentId", this.getId());
        if (this.isDisableWildcardsAndOperators()) {
            criteriaAttributes.put("disableWildcardsAndOperators", true);
        }
        if (this.getRequired().booleanValue()) {
            criteriaAttributes.put("required", true);
        }
        if (this.hasSecureValue()) {
            criteriaAttributes.put("secureValue", true);
        }
        if ((validCharactersConstraint = this.getValidCharactersConstraint()) != null) {
            criteriaAttributes.put("validCharactersConstraint", validCharactersConstraint);
        }
        lookupCriteriaFields.put(this.getPropertyName(), criteriaAttributes);
        this.addHiddenComponentPostMetadata(lookupCriteriaFields);
    }

    protected void addHiddenComponentPostMetadata(Map<String, Map<String, Object>> lookupCriteriaFields) {
        for (String hiddenPropertyName : this.getAdditionalHiddenPropertyNames()) {
            if (lookupCriteriaFields.containsKey(hiddenPropertyName = StringUtils.substringBetween((String)hiddenPropertyName, (String)"lookupCriteria[", (String)"]"))) continue;
            HashMap<String, Boolean> criteriaAttributes = new HashMap<String, Boolean>();
            criteriaAttributes.put("hidden", true);
            lookupCriteriaFields.put(hiddenPropertyName, criteriaAttributes);
        }
    }

    @Override
    public void copyFromAttributeDefinition(AttributeDefinition attributeDefinition) {
        if (StringUtils.isEmpty((String)this.getLabel())) {
            this.setLabel(attributeDefinition.getLabel());
        }
        if (StringUtils.isEmpty((String)this.getShortLabel())) {
            this.setShortLabel(attributeDefinition.getShortLabel());
        }
        if (attributeDefinition.getAttributeSecurity() != null && (this.getDataFieldSecurity() == null || this.getDataFieldSecurity().getAttributeSecurity() == null)) {
            this.initializeComponentSecurity();
            this.getDataFieldSecurity().setAttributeSecurity(attributeDefinition.getAttributeSecurity());
        }
        if (this.getOptionsFinder() == null) {
            this.setOptionsFinder(attributeDefinition.getOptionsFinder());
        }
        if (this.getControl() == null) {
            Control control = LookupInputField.convertControlToLookupControl(attributeDefinition);
            this.setControl(control);
        }
        this.setMaxLength(100);
        if (attributeDefinition.getMaxLength() != null && attributeDefinition.getMaxLength() > 100) {
            this.setMaxLength(attributeDefinition.getMaxLength());
        }
        if ((this.getDefaultValue() == null || this.getDefaultValue() instanceof String && StringUtils.isEmpty((String)((String)this.getDefaultValue()))) && StringUtils.equals((String)this.getPropertyName(), (String)"active")) {
            this.setDefaultValue("Y");
        }
    }

    protected static Control convertControlToLookupControl(AttributeDefinition attributeDefinition) {
        if (attributeDefinition.getControlField() == null) {
            return null;
        }
        Control newControl = null;
        newControl = CheckboxControl.class.isAssignableFrom(attributeDefinition.getControlField().getClass()) ? (RadioGroupControl)ComponentFactory.getNewComponentInstance("Uif-CheckboxConvertedRadioControl") : (TextAreaControl.class.isAssignableFrom(attributeDefinition.getControlField().getClass()) ? ComponentFactory.getTextControl() : ComponentUtils.copy(attributeDefinition.getControlField(), ""));
        return newControl;
    }

    public Map<String, String> filterSearchCriteria(Map<String, String> searchCriteria) {
        return searchCriteria;
    }

    @BeanTagAttribute(name="disableWildcardsAndOperators")
    public boolean isDisableWildcardsAndOperators() {
        return this.disableWildcardsAndOperators;
    }

    public void setDisableWildcardsAndOperators(boolean disableWildcardsAndOperators) {
        this.disableWildcardsAndOperators = disableWildcardsAndOperators;
    }

    @BeanTagAttribute(name="addControlSelectAllOption")
    public boolean isAddControlSelectAllOption() {
        return this.addControlSelectAllOption;
    }

    public void setAddControlSelectAllOption(boolean addControlSelectAllOption) {
        this.addControlSelectAllOption = addControlSelectAllOption;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public void setRanged(boolean ranged) {
        this.ranged = ranged;
    }
}

