/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RedirectFilter
implements Filter {
    protected static final String INIT_PARAM_REDIRECT_URL = "redirectUrl";
    protected static final String INIT_PARAM_REQUEST_URL_CONTAINS = "requestUrlContains";
    protected static final String DELIMITER = ",";
    protected String redirectUrl = null;
    protected Set<String> requestUrlContains = new HashSet<String>();

    public void init(FilterConfig filterConfig) {
        this.redirectUrl = filterConfig.getInitParameter(INIT_PARAM_REDIRECT_URL);
        this.requestUrlContains = Optional.ofNullable(filterConfig.getInitParameter(INIT_PARAM_REQUEST_URL_CONTAINS)).map(initParam -> initParam.split(DELIMITER)).map(urls -> Arrays.stream(urls).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet())).orElse(Set.of());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requestContainsMatch(request)) {
            response.sendRedirect(this.redirectUrl);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean requestContainsMatch(HttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)this.redirectUrl) && CollectionUtils.isNotEmpty(this.requestUrlContains) && this.requestUrlContains.stream().anyMatch(substring -> this.getFullRequestURI(request).contains((CharSequence)substring));
    }

    protected String getFullRequestURI(HttpServletRequest request) {
        return String.format("%s?%s", request.getRequestURI(), request.getQueryString());
    }

    public void destroy() {
        this.redirectUrl = null;
        this.requestUrlContains = null;
    }
}

