/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.task;

import co.kuali.coeus.task.tasks.Task;
import co.kuali.coeus.task.util.ClasspathURLStreamHandler;
import co.kuali.coeus.task.util.CommandLineArgsHolder;
import co.kuali.coeus.task.util.CommandLineArgsPropertySource;
import co.kuali.coeus.task.util.SettableStreamHandlerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.PBKey;
import org.kuali.coeus.sys.framework.config.DbConnectionConfigUtil;
import org.kuali.coeus.sys.framework.service.KcApplicationInitializer;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springmodules.orm.ojb.OjbFactoryUtils;

public class TaskRunner {
    private static final Logger LOG = LogManager.getLogger(TaskRunner.class);
    private static final String[] BOOTSTRAP_SPRING_BEANS = new String[]{"classpath:org/kuali/coeus/sys/impl/RiceBootstrapSpringBeans.xml", "classpath:co/kuali/coeus/task/TaskBootstrapSpringBeans.xml"};
    public static final String DRY_RUN_ARG = "dryRun";
    public static final String TASK_ARG = "task";
    public static final String ARG_DELIM = ",";

    public static void main(String[] args) {
        System.exit(TaskRunner.run(args));
    }

    public static int run(String[] args) {
        return TaskRunner.run(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(String[] args, JAXBConfigImpl initialConfig) {
        SettableStreamHandlerFactory settableStreamHandlerFactory = new SettableStreamHandlerFactory("classpath", new ClasspathURLStreamHandler());
        URL.setURLStreamHandlerFactory(settableStreamHandlerFactory);
        TaskRunner.setupConfigContext(initialConfig);
        CommandLineArgsPropertySource commandLineProperties = new CommandLineArgsPropertySource("taskProperties", args);
        CommandLineArgsHolder.setArgs(commandLineProperties);
        GenericXmlApplicationContext context = new GenericXmlApplicationContext();
        context.getEnvironment().getPropertySources().addFirst((PropertySource)commandLineProperties);
        int exitStatus = 0;
        try {
            LOG.info("Loading task application context...");
            context.load(BOOTSTRAP_SPRING_BEANS);
            context.refresh();
            context.start();
            LOG.info("Context loading finished.");
            TaskRunner.runTasks();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception starting Task Runner", (Throwable)e);
            exitStatus = 1;
        }
        finally {
            context.close();
        }
        return exitStatus;
    }

    private static void setupConfigContext(JAXBConfigImpl initialConfig) {
        JAXBConfigImpl config = initialConfig;
        if (config == null) {
            config = new JAXBConfigImpl("classpath:META-INF/kc-task-config.xml", System.getProperties());
            try {
                config.parseConfig();
            }
            catch (IOException e) {
                LOG.error("Failed to parse XML config", (Throwable)e);
                throw new RuntimeException("Failed to parse XML config", e);
            }
        }
        config.putProperties(System.getProperties());
        DbConnectionConfigUtil.setUpdatedDatabaseConnection(config);
        KcApplicationInitializer.configureActiveSpringProfiles(config);
        ConfigContext.init((Config)config);
    }

    private static List<Task> getTasksFromArguments() throws ClassNotFoundException {
        String[] stringArray;
        String taskString = CommandLineArgsHolder.getArgs().getProperty(TASK_ARG);
        if (taskString == null) {
            throw new IllegalArgumentException(String.format("%s argument is required", TASK_ARG));
        }
        if (taskString.contains(ARG_DELIM)) {
            stringArray = taskString.split(ARG_DELIM);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = taskString;
        }
        String[] taskNames = stringArray;
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (taskNames.length == 0) {
            throw new IllegalArgumentException(String.format("%s argument must be a fully-qualified class name or bean name", TASK_ARG));
        }
        for (String task : taskNames) {
            Object taskBean;
            Object object = taskBean = task.contains(".") ? KcServiceLocator.getService(Class.forName(task)) : KcServiceLocator.getService(task);
            if (taskBean == null) {
                throw new IllegalArgumentException(String.format("No bean found for type or name %s", task));
            }
            if (!(taskBean instanceof Task)) {
                throw new IllegalArgumentException(String.format("%s is not an instance of %s", task, Task.class.getName()));
            }
            tasks.add((Task)taskBean);
        }
        return tasks;
    }

    private static void runTasks() {
        OjbFactoryUtils.getPersistenceBroker((PBKey)new PBKey("kradApplicationDataSource"), (boolean)true);
        boolean isDryRun = CommandLineArgsHolder.isArgPresent(DRY_RUN_ARG);
        try {
            TaskRunner.getTasksFromArguments().forEach(task -> {
                List<String> errors = task.validateArguments();
                if (CollectionUtils.isNotEmpty(errors)) {
                    errors.forEach(arg_0 -> ((Logger)LOG).error(arg_0));
                    return;
                }
                if (isDryRun) {
                    task.dryRun();
                } else {
                    task.run();
                }
            });
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

