/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsageContract;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoService;

public class NaturalLanguageUsageBoServiceImpl
implements NaturalLanguageUsageBoService {
    private DataObjectService dataObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }

    public KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    @Override
    public NaturalLanguageUsage createNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) {
        NaturalLanguageUsage existing;
        String naturalLanguageUsageIdKey;
        NaturalLanguageUsage existing2;
        this.incomingParamCheck(naturalLanguageUsage, "naturalLanguageUsage");
        if (StringUtils.isNotEmpty((String)naturalLanguageUsage.getId()) ? (existing2 = this.getNaturalLanguageUsage(naturalLanguageUsageIdKey = naturalLanguageUsage.getId())) != null : (existing = this.getNaturalLanguageUsageByName(naturalLanguageUsage.getNamespace(), naturalLanguageUsage.getName())) != null) {
            throw new IllegalStateException("the NaturalLanguageUsage to create already exists: " + String.valueOf(naturalLanguageUsage));
        }
        NaturalLanguageUsageBo bo = (NaturalLanguageUsageBo)this.dataObjectService.save((Object)this.from(naturalLanguageUsage), new PersistenceOption[]{PersistenceOption.FLUSH});
        return NaturalLanguageUsageBo.to(bo);
    }

    @Override
    public NaturalLanguageUsage getNaturalLanguageUsage(String naturalLanguageUsageId) {
        this.incomingParamCheck(naturalLanguageUsageId, "naturalLanguageUsageId");
        NaturalLanguageUsageBo bo = (NaturalLanguageUsageBo)this.dataObjectService.find(NaturalLanguageUsageBo.class, (Object)naturalLanguageUsageId);
        return NaturalLanguageUsageBo.to(bo);
    }

    @Override
    public NaturalLanguageUsage getNaturalLanguageUsageByName(String namespace, String name) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace was a null or blank value");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        map.put("name", name);
        NaturalLanguageUsageBo usageBo = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, NaturalLanguageUsageBo.class, map);
        return NaturalLanguageUsageBo.to(usageBo);
    }

    @Override
    public NaturalLanguageUsage updateNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) {
        NaturalLanguageUsage toUpdate;
        this.incomingParamCheck(naturalLanguageUsage, "naturalLanguageUsage");
        NaturalLanguageUsage existing = this.getNaturalLanguageUsage(naturalLanguageUsage.getId());
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageUsage to update does not exists: " + String.valueOf(naturalLanguageUsage));
        }
        if (!existing.getId().equals(naturalLanguageUsage.getId())) {
            NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((NaturalLanguageUsageContract)naturalLanguageUsage);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = naturalLanguageUsage;
        }
        NaturalLanguageUsageBo boToUpdate = this.from(toUpdate);
        NaturalLanguageUsageBo updatedData = (NaturalLanguageUsageBo)this.dataObjectService.save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
        return this.to(updatedData);
    }

    @Override
    public void deleteNaturalLanguageUsage(String naturalLanguageUsageId) {
        this.incomingParamCheck(naturalLanguageUsageId, "naturalLanguageUsageId");
        NaturalLanguageUsage existing = this.getNaturalLanguageUsage(naturalLanguageUsageId);
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageUsage to delete does not exists: " + naturalLanguageUsageId);
        }
        this.dataObjectService.delete((Object)this.from(existing));
    }

    @Override
    public List<NaturalLanguageUsage> findNaturalLanguageUsagesByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        List<NaturalLanguageUsageBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageUsageBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageUsage> findNaturalLanguageUsagesByDescription(String description) {
        if (StringUtils.isBlank((String)description)) {
            throw new IllegalArgumentException("description is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("description", description);
        List<NaturalLanguageUsageBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageUsageBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageUsage> findNaturalLanguageUsagesByNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        List<NaturalLanguageUsageBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, NaturalLanguageUsageBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    public List<NaturalLanguageUsage> convertBosToImmutables(Collection<NaturalLanguageUsageBo> naturalLanguageUsageBos) {
        LinkedList<NaturalLanguageUsage> immutables = new LinkedList<NaturalLanguageUsage>();
        if (naturalLanguageUsageBos != null) {
            NaturalLanguageUsage immutable = null;
            for (NaturalLanguageUsageBo bo : naturalLanguageUsageBos) {
                immutable = this.to(bo);
                immutables.add(immutable);
            }
        }
        return Collections.unmodifiableList(immutables);
    }

    @Override
    public NaturalLanguageUsage to(NaturalLanguageUsageBo naturalLanguageUsageBo) {
        return NaturalLanguageUsageBo.to(naturalLanguageUsageBo);
    }

    @Override
    public NaturalLanguageUsageBo from(NaturalLanguageUsage naturalLanguageUsage) {
        return NaturalLanguageUsageBo.from(naturalLanguageUsage);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new IllegalArgumentException(name + " was blank");
        }
    }
}

