/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.parameter;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kuali.rice.core.api.config.property.ConfigStrLookup;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterKey;
import org.kuali.rice.coreservice.api.parameter.ParameterRepositoryService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.KualiModuleService;

public class ParameterServiceImpl
implements ParameterService {
    private static final StrSubstitutor CONFIG_SUBSTITUTOR = new StrSubstitutor((StrLookup)new ConfigStrLookup());
    private KualiModuleService kualiModuleService;
    private ParameterRepositoryService parameterRepositoryService;
    private String applicationId = "KUALI";

    public Parameter createParameter(Parameter parameter) {
        return this.parameterRepositoryService.createParameter(parameter);
    }

    public Parameter updateParameter(Parameter parameter) {
        return this.parameterRepositoryService.updateParameter(parameter);
    }

    public Parameter getParameter(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Parameter>(){

            @Override
            public Parameter f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    public Parameter getParameter(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Parameter>(){

            @Override
            public Parameter f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key);
            }
        }, componentClass, parameterName);
    }

    public Boolean parameterExists(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key) != null;
            }
        }, namespaceCode, componentCode, parameterName);
    }

    public Boolean parameterExists(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameter(key) != null;
            }
        }, componentClass, parameterName);
    }

    public Boolean getParameterValueAsBoolean(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsBoolean(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    public Boolean getParameterValueAsBoolean(String namespaceCode, String componentCode, String parameterName, Boolean defaultValue) {
        Boolean value = this.getParameterValueAsBoolean(namespaceCode, componentCode, parameterName);
        return value != null ? value : defaultValue;
    }

    public Boolean getParameterValueAsBoolean(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Boolean>(){

            @Override
            public Boolean f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsBoolean(key);
            }
        }, componentClass, parameterName);
    }

    public Boolean getParameterValueAsBoolean(Class<?> componentClass, String parameterName, Boolean defaultValue) {
        Boolean value = this.getParameterValueAsBoolean(componentClass, parameterName);
        return value != null ? value : defaultValue;
    }

    public String getParameterValueAsString(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsString(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    public String getParameterValueAsString(String namespaceCode, String componentCode, String parameterName, String defaultValue) {
        String value = this.getParameterValueAsString(namespaceCode, componentCode, parameterName);
        return value != null ? value : defaultValue;
    }

    public String getParameterValueAsString(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValueAsString(key);
            }
        }, componentClass, parameterName);
    }

    public String getParameterValueAsString(Class<?> componentClass, String parameterName, String defaultValue) {
        String value = this.getParameterValueAsString(componentClass, parameterName);
        return value != null ? value : defaultValue;
    }

    public String getParameterValueAsFilteredString(String namespaceCode, String componentCode, String parameterName) {
        String value = this.getParameterValueAsString(namespaceCode, componentCode, parameterName);
        return CONFIG_SUBSTITUTOR.replace(value);
    }

    public String getParameterValueAsFilteredString(String namespaceCode, String componentCode, String parameterName, String defaultValue) {
        String value = this.getParameterValueAsFilteredString(namespaceCode, componentCode, parameterName);
        return value != null ? value : defaultValue;
    }

    public String getParameterValueAsFilteredString(Class<?> componentClass, String parameterName) {
        String value = this.getParameterValueAsString(componentClass, parameterName);
        return CONFIG_SUBSTITUTOR.replace(value);
    }

    public String getParameterValueAsFilteredString(Class<?> componentClass, String parameterName, String defaultValue) {
        String value = this.getParameterValueAsString(componentClass, parameterName);
        return value != null ? value : defaultValue;
    }

    public Collection<String> getParameterValuesAsString(String namespaceCode, String componentCode, String parameterName) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValuesAsString(key);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    public Collection<String> getParameterValuesAsString(Class<?> componentClass, String parameterName) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getParameterValuesAsString(key);
            }
        }, componentClass, parameterName);
    }

    public Collection<String> getParameterValuesAsFilteredString(String namespaceCode, String componentCode, String parameterName) {
        Collection<String> unfilteredValues = this.getParameterValuesAsString(namespaceCode, componentCode, parameterName);
        ArrayList<String> filteredValues = new ArrayList<String>();
        for (String unfilteredValue : unfilteredValues) {
            filteredValues.add(CONFIG_SUBSTITUTOR.replace(unfilteredValue));
        }
        return filteredValues;
    }

    public Collection<String> getParameterValuesAsFilteredString(Class<?> componentClass, String parameterName) {
        Collection<String> unfilteredValues = this.getParameterValuesAsString(componentClass, parameterName);
        ArrayList<String> filteredValues = new ArrayList<String>();
        for (String unfilteredValue : unfilteredValues) {
            filteredValues.add(CONFIG_SUBSTITUTOR.replace(unfilteredValue));
        }
        return filteredValues;
    }

    public String getSubParameterValueAsString(String namespaceCode, String componentCode, String parameterName, final String subParameterName) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValueAsString(key, subParameterName);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    public String getSubParameterValueAsString(Class<?> componentClass, String parameterName, final String subParameterName) {
        return this.exec(new Fun<String>(){

            @Override
            public String f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValueAsString(key, subParameterName);
            }
        }, componentClass, parameterName);
    }

    public String getSubParameterValueAsFilteredString(String namespaceCode, String componentCode, String parameterName, String subParameterName) {
        String value = this.getSubParameterValueAsString(namespaceCode, componentCode, parameterName, subParameterName);
        return CONFIG_SUBSTITUTOR.replace(value);
    }

    public String getSubParameterValueAsFilteredString(Class<?> componentClass, String parameterName, String subParameterName) {
        String value = this.getSubParameterValueAsString(componentClass, parameterName, subParameterName);
        return CONFIG_SUBSTITUTOR.replace(value);
    }

    public Collection<String> getSubParameterValuesAsString(String namespaceCode, String componentCode, String parameterName, final String subParameterName) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValuesAsString(key, subParameterName);
            }
        }, namespaceCode, componentCode, parameterName);
    }

    public Collection<String> getSubParameterValuesAsString(Class<?> componentClass, String parameterName, final String subParameterName) {
        return this.exec(new Fun<Collection<String>>(){

            @Override
            public Collection<String> f(ParameterKey key) {
                return ParameterServiceImpl.this.parameterRepositoryService.getSubParameterValuesAsString(key, subParameterName);
            }
        }, componentClass, parameterName);
    }

    public Collection<String> getSubParameterValuesAsFilteredString(String namespaceCode, String componentCode, String parameterName, String subParameterName) {
        Collection<String> unfilteredValues = this.getSubParameterValuesAsString(namespaceCode, componentCode, parameterName, subParameterName);
        ArrayList<String> filteredValues = new ArrayList<String>();
        for (String unfilteredValue : unfilteredValues) {
            filteredValues.add(CONFIG_SUBSTITUTOR.replace(unfilteredValue));
        }
        return filteredValues;
    }

    public Collection<String> getSubParameterValuesAsFilteredString(Class<?> componentClass, String parameterName, String subParameterName) {
        Collection<String> unfilteredValues = this.getSubParameterValuesAsString(componentClass, parameterName, subParameterName);
        ArrayList<String> filteredValues = new ArrayList<String>();
        for (String unfilteredValue : unfilteredValues) {
            filteredValues.add(CONFIG_SUBSTITUTOR.replace(unfilteredValue));
        }
        return filteredValues;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setParameterRepositoryService(ParameterRepositoryService parameterRepositoryService) {
        this.parameterRepositoryService = parameterRepositoryService;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    private <R> R exec(Fun<R> fun, String namespaceCode, String componentCode, String parameterName) {
        if (StringUtils.isBlank((String)this.applicationId)) {
            throw new IllegalStateException("applicationId is blank - this service is not configured correctly");
        }
        return fun.f(ParameterKey.create((String)this.applicationId, (String)namespaceCode, (String)componentCode, (String)parameterName));
    }

    private <R> R exec(Fun<R> fun, Class<?> componentClass, String parameterName) {
        return this.exec(fun, this.kualiModuleService.getNamespaceCode(componentClass), this.kualiModuleService.getComponentCode(componentClass), parameterName);
    }

    private static interface Fun<R> {
        public R f(ParameterKey var1);
    }
}

