/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.rice.kns.document.authorization.FieldRestriction;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.InactivationBlockingDetectionService;
import org.kuali.rice.krad.service.InactivationBlockingDisplayService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.impl.InactivationBlockingDetectionServiceImpl;
import org.kuali.rice.krad.util.GlobalVariables;

public class InactivationBlockingDisplayServiceImpl
implements InactivationBlockingDisplayService {
    private static final Logger LOG = LogManager.getLogger(InactivationBlockingDetectionServiceImpl.class);
    private DataDictionaryService dataDictionaryService;
    private BusinessObjectAuthorizationService businessObjectAuthorizationService;
    private LegacyDataAdapter legacyDataAdapter;

    public List<String> listAllBlockerRecords(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        String inactivationBlockingDetectionServiceBeanName = inactivationBlockingMetadata.getInactivationBlockingDetectionServiceBeanName();
        if (StringUtils.isBlank((String)inactivationBlockingDetectionServiceBeanName)) {
            inactivationBlockingDetectionServiceBeanName = "inactivationBlockingDetectionService";
        }
        InactivationBlockingDetectionService inactivationBlockingDetectionService = KRADServiceLocatorWeb.getInactivationBlockingDetectionService((String)inactivationBlockingDetectionServiceBeanName);
        Collection collection = inactivationBlockingDetectionService.listAllBlockerRecords(blockedBo, inactivationBlockingMetadata);
        Map<String, Formatter> formatters = this.getFormattersForPrimaryKeyFields(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        ArrayList<String> displayValues = new ArrayList<String>();
        List pkFieldNames = this.getLegacyDataAdapter().listPrimaryKeyFieldNames(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject element : collection) {
            StringBuilder buf = new StringBuilder();
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            for (int i = 0; i < pkFieldNames.size(); ++i) {
                String pkFieldName = (String)pkFieldNames.get(i);
                Object value = KradDataServiceLocator.getDataObjectService().wrap((Object)element).getPropertyValueNullSafe(pkFieldName);
                String displayValue = null;
                if (!businessObjectRestrictions.hasRestriction(pkFieldName)) {
                    Formatter formatter = formatters.get(pkFieldName);
                    displayValue = formatter != null ? (String)formatter.format(value) : String.valueOf(value);
                } else {
                    FieldRestriction fieldRestriction = businessObjectRestrictions.getFieldRestriction(pkFieldName);
                    if (fieldRestriction.isMasked() || fieldRestriction.isPartiallyMasked()) {
                        MaskFormatter maskFormatter = fieldRestriction.getMaskFormatter();
                        displayValue = maskFormatter.maskValue(value);
                    } else {
                        LOG.warn("Restriction was defined for class: " + String.valueOf(element.getClass()) + " field name: " + pkFieldName + ", but it was not honored by the inactivation blocking display framework");
                    }
                }
                buf.append(displayValue);
                if (i >= pkFieldNames.size() - 1) continue;
                buf.append(" - ");
            }
            displayValues.add(buf.toString());
        }
        return displayValues;
    }

    public List<String> displayAllBlockingRecords(Object blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        String inactivationBlockingDetectionServiceBeanName = inactivationBlockingMetadata.getInactivationBlockingDetectionServiceBeanName();
        if (StringUtils.isBlank((String)inactivationBlockingDetectionServiceBeanName)) {
            inactivationBlockingDetectionServiceBeanName = "inactivationBlockingDetectionService";
        }
        InactivationBlockingDetectionService inactivationBlockingDetectionService = KRADServiceLocatorWeb.getInactivationBlockingDetectionService((String)inactivationBlockingDetectionServiceBeanName);
        Collection collection = inactivationBlockingDetectionService.detectAllBlockingRecords(blockedBo, inactivationBlockingMetadata);
        Map<String, Formatter> formatters = this.getFormattersForPrimaryKeyFields(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        ArrayList<String> displayValues = new ArrayList<String>();
        List pkFieldNames = this.getLegacyDataAdapter().listPrimaryKeyFieldNames(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (Object element : collection) {
            StringBuilder buf = new StringBuilder();
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions(element, user);
            for (int i = 0; i < pkFieldNames.size(); ++i) {
                String pkFieldName = (String)pkFieldNames.get(i);
                Object value = KradDataServiceLocator.getDataObjectService().wrap(element).getPropertyValueNullSafe(pkFieldName);
                String displayValue = null;
                if (!businessObjectRestrictions.hasRestriction(pkFieldName)) {
                    Formatter formatter = formatters.get(pkFieldName);
                    displayValue = formatter != null ? (String)formatter.format(value) : String.valueOf(value);
                } else {
                    FieldRestriction fieldRestriction = businessObjectRestrictions.getFieldRestriction(pkFieldName);
                    if (fieldRestriction.isMasked() || fieldRestriction.isPartiallyMasked()) {
                        MaskFormatter maskFormatter = fieldRestriction.getMaskFormatter();
                        displayValue = maskFormatter.maskValue(value);
                    } else {
                        LOG.warn("Restriction was defined for class: " + String.valueOf(element.getClass()) + " field name: " + pkFieldName + ", but it was not honored by the inactivation blocking display framework");
                    }
                }
                buf.append(displayValue);
                if (i >= pkFieldNames.size() - 1) continue;
                buf.append(" - ");
            }
            displayValues.add(buf.toString());
        }
        return displayValues;
    }

    @Deprecated
    protected Map<String, Formatter> getFormattersForPrimaryKeyFields(Class<?> boClass) {
        List keyNames = this.getLegacyDataAdapter().listPrimaryKeyFieldNames(boClass);
        HashMap<String, Formatter> formattersForPrimaryKeyFields = new HashMap<String, Formatter>();
        for (String pkFieldName : keyNames) {
            Formatter formatter = null;
            Class formatterClass = this.dataDictionaryService.getAttributeFormatter(boClass, pkFieldName);
            if (formatterClass == null) continue;
            try {
                formatter = (Formatter)formatterClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formattersForPrimaryKeyFields;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (this.businessObjectAuthorizationService == null) {
            this.businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return this.businessObjectAuthorizationService;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = KRADServiceLocatorWeb.getLegacyDataAdapter();
        }
        return this.legacyDataAdapter;
    }
}

