/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate;

import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalV10.HashValueDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.common.questionnaire.api.core.QuestionAnswerService;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeService;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.person.attachment.ProposalPersonBiographyContract;
import org.kuali.coeus.propdev.api.questionnaire.PropDevQuestionAnswerService;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.GlobalLibraryV2_0Generator;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;

public abstract class S2SBaseFormGenerator<T extends XmlObject>
implements S2SFormGenerator<T>,
BeanNameAware {
    protected static final String NOT_ANSWERED = "No";
    protected static final String AREAS_AFFECTED_ABSTRACT_TYPE_CODE = "16";
    protected static final int ORGANIZATON_NAME_MAX_LENGTH = 60;
    protected static final int ORGANIZATION_UEI_MAX_LENGTH = 12;
    protected static final int DUNS_NUMBER_MAX_LENGTH = 13;
    protected static final int PRIMARY_TITLE_MAX_LENGTH = 45;
    protected static final int CONGRESSIONAL_DISTRICT_MAX_LENGTH = 6;
    protected static final String DEFAULT_SORT_INDEX = "1000";
    private static final String REPLACEMENT_CHARACTER = "_";
    private static final String REGEX_TITLE_FILENAME_PATTERN = "([^0-9a-zA-Z\\.\\-_])";
    protected ProposalDevelopmentDocumentContract pdDoc = null;
    private List<AuditError> auditErrors = new ArrayList<AuditError>();
    private List<AttachmentData> attachments = new ArrayList<AttachmentData>();
    private String beanName;
    @Autowired
    @Qualifier(value="narrativeService")
    private NarrativeService narrativeService;
    @Autowired
    @Qualifier(value="propDevQuestionAnswerService")
    private PropDevQuestionAnswerService propDevQuestionAnswerService;
    @Autowired
    @Qualifier(value="questionAnswerService")
    private QuestionAnswerService questionAnswerService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService grantApplicationHashService;
    @Autowired
    @Qualifier(value="GlobalLibraryV2_0Generator")
    protected GlobalLibraryV2_0Generator globLibV20Generator;

    @Override
    public List<AttachmentData> getAttachments() {
        return this.attachments;
    }

    protected void addAttachment(AttachmentData attachment) {
        this.attachments.add(attachment);
    }

    protected HashValueDocument.HashValue getHashValue(byte[] fileData) {
        return S2SBaseFormGenerator.createHashValue(this.grantApplicationHashService.computeAttachmentHash(fileData));
    }

    protected String createContentId(NarrativeContract narrative) {
        int index;
        Object retVal = narrative.getProposalNumber() + "-N-" + narrative.getModuleNumber();
        if (narrative.getNarrativeType() != null) {
            retVal = narrative.getNarrativeType().isAllowMultiple() && StringUtils.isNotBlank((CharSequence)narrative.getModuleTitle()) ? (String)retVal + REPLACEMENT_CHARACTER + narrative.getModuleTitle().trim() : (String)retVal + REPLACEMENT_CHARACTER + narrative.getNarrativeType().getDescription().trim();
        }
        if ((index = this.getCountOfAttachmentAlreadyAdded((String)(retVal = this.cleanFileName((String)retVal)))) > 0) {
            retVal = (String)retVal + "-" + index;
        }
        return retVal;
    }

    private int getCountOfAttachmentAlreadyAdded(String contentId) {
        return (int)this.getAttachments().stream().filter(attachmentData -> attachmentData.getContentId().startsWith(contentId)).count();
    }

    protected String createContentId(ProposalPersonBiographyContract biography) {
        int index;
        Object retVal = biography.getProposalNumber() + "-B-" + biography.getProposalPersonNumber() + REPLACEMENT_CHARACTER + biography.getBiographyNumber();
        if (biography.getPropPerDocType() != null) {
            retVal = (String)retVal + REPLACEMENT_CHARACTER + biography.getPropPerDocType().getDescription().trim();
        }
        if (StringUtils.isNotBlank((CharSequence)biography.getDescription())) {
            retVal = (String)retVal + REPLACEMENT_CHARACTER + biography.getDescription().trim();
        }
        if ((index = this.getCountOfAttachmentAlreadyAdded((String)(retVal = this.cleanFileName((String)retVal)))) > 0) {
            retVal = (String)retVal + "-" + index;
        }
        return retVal;
    }

    private static synchronized HashValueDocument.HashValue createHashValue(String hashValueStr) {
        HashValueDocument.HashValue hashValue = (HashValueDocument.HashValue)HashValueDocument.HashValue.Factory.newInstance();
        hashValue.setHashAlgorithm("SHA-1");
        hashValue.setStringValue(hashValueStr);
        return hashValue;
    }

    protected AttachedFileDataType addAttachedFileType(NarrativeContract narrative) {
        AttachedFileDataType attachedFileDataType = null;
        byte[] attachementContent = null;
        if (narrative.getNarrativeAttachment() != null) {
            attachementContent = narrative.getNarrativeAttachment().getData();
        }
        if (attachementContent != null && attachementContent.length > 0) {
            AttachedFileDataType.FileLocation fileLocation = (AttachedFileDataType.FileLocation)AttachedFileDataType.FileLocation.Factory.newInstance();
            String contentId = this.createContentId(narrative);
            fileLocation.setHref(contentId);
            attachedFileDataType = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
            attachedFileDataType.setFileLocation(fileLocation);
            attachedFileDataType.setFileName(this.getS2sNarrativeFileName(narrative));
            attachedFileDataType.setMimeType("application/octet-stream");
            HashValueDocument.HashValue hashValue = this.getHashValue(attachementContent);
            attachedFileDataType.setHashValue(hashValue);
            this.addAttachment(new AttachmentData(narrative.getNarrativeAttachment().getFileDataId(), this.getS2sNarrativeFileName(narrative), contentId, attachementContent, "application/octet-stream", hashValue.getHashAlgorithm(), hashValue.getStringValue(), narrative.getNarrativeAttachment().getUploadUser(), narrative.getNarrativeAttachment().getUploadTimestamp()));
        }
        return attachedFileDataType;
    }

    protected AttachedFileDataType[] getAttachedFileDataTypes(String narrativeTypeCode) {
        int size = 0;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType() == null || !narrative.getNarrativeType().getCode().equals(narrativeTypeCode)) continue;
            ++size;
        }
        AttachedFileDataType[] attachedFileDataTypes = new AttachedFileDataType[size];
        int attachments = 0;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType() == null || !narrative.getNarrativeType().getCode().equals(narrativeTypeCode)) continue;
            attachedFileDataTypes[attachments] = this.addAttachedFileType(narrative);
            ++attachments;
        }
        return attachedFileDataTypes;
    }

    protected AttachedFileDataType getAttachedFileDataType(String narrativeTypeCode) {
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType() == null || !narrative.getNarrativeType().getCode().equals(narrativeTypeCode)) continue;
            return this.addAttachedFileType(narrative);
        }
        return null;
    }

    protected AttachedFileDataType getPersonnelAttachments(ProposalDevelopmentDocumentContract pdDoc, String personId, Integer rolodexId, String documentType) {
        boolean personBiographyFound = false;
        for (ProposalPersonBiographyContract proposalPersonBiography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
            if (personId != null && proposalPersonBiography.getPersonId() != null && proposalPersonBiography.getPersonId().equals(personId) && documentType.equals(proposalPersonBiography.getPropPerDocType().getCode())) {
                personBiographyFound = true;
            } else if (rolodexId != null && proposalPersonBiography.getRolodexId() != null && proposalPersonBiography.getRolodexId().toString().equals(rolodexId.toString()) && proposalPersonBiography.getPropPerDocType() != null && documentType.equals(proposalPersonBiography.getPropPerDocType().getCode())) {
                personBiographyFound = true;
            }
            byte[] attachmentContent = null;
            if (proposalPersonBiography.getPersonnelAttachment() != null) {
                attachmentContent = proposalPersonBiography.getPersonnelAttachment().getData();
            }
            if (!personBiographyFound || attachmentContent == null || attachmentContent.length <= 0) continue;
            AttachedFileDataType.FileLocation fileLocation = (AttachedFileDataType.FileLocation)AttachedFileDataType.FileLocation.Factory.newInstance();
            String contentId = this.createContentId(proposalPersonBiography);
            fileLocation.setHref(contentId);
            AttachedFileDataType attachedFileDataType = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
            attachedFileDataType.setFileLocation(fileLocation);
            attachedFileDataType.setFileName(this.getS2sPersonnelAttachmentFileName(pdDoc.getDevelopmentProposal(), proposalPersonBiography));
            attachedFileDataType.setMimeType("application/octet-stream");
            HashValueDocument.HashValue hashValue = this.getHashValue(proposalPersonBiography.getPersonnelAttachment().getData());
            attachedFileDataType.setHashValue(hashValue);
            this.addAttachment(new AttachmentData(proposalPersonBiography.getPersonnelAttachment().getFileDataId(), this.getS2sPersonnelAttachmentFileName(pdDoc.getDevelopmentProposal(), proposalPersonBiography), contentId, proposalPersonBiography.getPersonnelAttachment().getData(), "application/octet-stream", hashValue.getHashAlgorithm(), hashValue.getStringValue(), proposalPersonBiography.getPersonnelAttachment().getUploadUser(), proposalPersonBiography.getPersonnelAttachment().getUploadTimestamp()));
            return attachedFileDataType;
        }
        return null;
    }

    private int getCountOfAttachmentAlreadyAddedByFileName(String fileName) {
        return (int)this.getAttachments().stream().filter(attachmentData -> attachmentData.getFileName().startsWith(fileName)).count();
    }

    protected String getS2sNarrativeFileName(NarrativeContract narrative) {
        Object fileName = narrative.getNarrativeType().isAllowMultiple() ? narrative.getModuleTitle() : narrative.getNarrativeType().getDescription();
        int attachmentCount = this.getCountOfAttachmentAlreadyAddedByFileName((String)(fileName = this.cleanFileName((String)fileName)));
        if (attachmentCount > 0) {
            fileName = (String)fileName + "-" + attachmentCount;
        }
        String extension = StringUtils.substringAfterLast((String)narrative.getNarrativeAttachment().getName(), (String)".");
        return (String)fileName + "." + extension;
    }

    protected String getS2sPersonnelAttachmentFileName(DevelopmentProposalContract developmentProposal, ProposalPersonBiographyContract biography) {
        String docType;
        String extension = StringUtils.substringAfterLast((String)biography.getName(), (String)".");
        String fullName = this.getPerson(developmentProposal, biography.getProposalPersonNumber()).getFullName();
        Object fileName = this.cleanFileName(fullName + REPLACEMENT_CHARACTER + (docType = biography.getPropPerDocType().getDescription()));
        int attachmentCount = this.getCountOfAttachmentAlreadyAddedByFileName((String)fileName);
        if (attachmentCount > 0) {
            fileName = (String)fileName + "-" + attachmentCount;
        }
        return (String)fileName + "." + extension;
    }

    protected String cleanFileName(String fileName) {
        Pattern pattern = Pattern.compile(REGEX_TITLE_FILENAME_PATTERN);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.replaceAll(REPLACEMENT_CHARACTER);
    }

    protected ProposalPersonContract getPerson(DevelopmentProposalContract developmentProposal, Integer proposalPersonNumber) {
        for (ProposalPersonContract person : developmentProposal.getProposalPersons()) {
            if (!proposalPersonNumber.equals(person.getProposalPersonNumber())) continue;
            return person;
        }
        return null;
    }

    @Override
    public List<AuditError> getAuditErrors() {
        return this.auditErrors;
    }

    public void setAuditErrors(List<AuditError> auditErrors) {
        this.auditErrors = auditErrors;
    }

    protected boolean isSponsorNIH(ProposalDevelopmentDocumentContract document) {
        return this.sponsorHierarchyService.isSponsorNihMultiplePi(document.getDevelopmentProposal().getSponsor().getSponsorCode());
    }

    protected NarrativeContract saveNarrative(byte[] attachment, String narrativeTypeCode, String fileName, String comment) {
        return this.narrativeService.createSystemGeneratedNarrative(this.pdDoc.getDevelopmentProposal().getProposalNumber(), narrativeTypeCode, attachment, fileName, comment);
    }

    public void setAttachments(List<AttachmentData> attachments) {
        this.attachments = attachments;
    }

    protected String getAnswer(Integer questionSeqId, List<? extends AnswerHeaderContract> answerHeaders) {
        for (AnswerHeaderContract answerHeaderContract : answerHeaders) {
            if (answerHeaderContract == null) continue;
            List answerDetails = answerHeaderContract.getAnswers();
            for (AnswerContract answers : answerDetails) {
                if (!questionSeqId.equals(this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId())) continue;
                return answers.getAnswer();
            }
        }
        return null;
    }

    protected Long getAnswerId(Integer questionSeqId, List<? extends AnswerHeaderContract> answerHeaders) {
        if (answerHeaders != null && !answerHeaders.isEmpty()) {
            for (AnswerHeaderContract answerHeaderContract : answerHeaders) {
                List answerDetails = answerHeaderContract.getAnswers();
                for (AnswerContract answers : answerDetails) {
                    if (answers.getAnswer() == null || !questionSeqId.equals(this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId())) continue;
                    return answers.getId();
                }
            }
        }
        return null;
    }

    protected String getChildQuestionAnswer(Integer parentQuestionSeqId, Integer questionSeqId, List<? extends AnswerHeaderContract> answerHeaders) {
        for (AnswerHeaderContract answerHeaderContract : answerHeaders) {
            if (answerHeaderContract == null) continue;
            List answerDetails = answerHeaderContract.getAnswers();
            for (AnswerContract answers : answerDetails) {
                if (answers.getParentAnswers() == null) continue;
                AnswerContract parentAnswer = (AnswerContract)answers.getParentAnswers().get(0);
                if (!questionSeqId.equals(this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId()) || !parentQuestionSeqId.equals(this.getQuestionAnswerService().findQuestionById(parentAnswer.getQuestionId()).getQuestionSeqId())) continue;
                return answers.getAnswer();
            }
        }
        return null;
    }

    protected String getAnswers(Integer questionSeqId, List<? extends AnswerHeaderContract> answerHeaders) {
        String childAnswer = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (answerHeaders != null && !answerHeaders.isEmpty()) {
            for (AnswerHeaderContract answerHeaderContract : answerHeaders) {
                List answerDetails = answerHeaderContract.getAnswers();
                for (AnswerContract answers : answerDetails) {
                    if (!questionSeqId.equals(this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId())) continue;
                    String answer = answers.getAnswer();
                    if (answer != null && !answer.equals(NOT_ANSWERED)) {
                        stringBuilder.append(answer);
                        stringBuilder.append(",");
                    }
                    childAnswer = stringBuilder.toString();
                }
            }
        }
        return childAnswer;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return Collections.emptyList();
    }

    @Override
    public boolean supportsPdfFilling() {
        return this instanceof S2SFormGeneratorPdfFillable;
    }

    @Override
    public boolean supportsXslTransform() {
        return true;
    }

    public NarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public PropDevQuestionAnswerService getPropDevQuestionAnswerService() {
        return this.propDevQuestionAnswerService;
    }

    public QuestionAnswerService getQuestionAnswerService() {
        return this.questionAnswerService;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public void setPropDevQuestionAnswerService(PropDevQuestionAnswerService propDevQuestionAnswerService) {
        this.propDevQuestionAnswerService = propDevQuestionAnswerService;
    }

    public void setQuestionAnswerService(QuestionAnswerService questionAnswerService) {
        this.questionAnswerService = questionAnswerService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }

    public GlobalLibraryV2_0Generator getGlobLibV20Generator() {
        return this.globLibV20Generator;
    }

    public void setGlobLibV20Generator(GlobalLibraryV2_0Generator globLibV20Generator) {
        this.globLibV20Generator = globLibV20Generator;
    }
}

