/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.ggLobbyingFormV11.LobbyingFormDocument;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.GGLobbyingFormBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="GGLobbyingFormV1_1Generator")
public class GGLobbyingFormV1_1Generator
extends GGLobbyingFormBaseGenerator<LobbyingFormDocument>
implements S2SFormGeneratorPdfFillable<LobbyingFormDocument> {
    @Value(value="http://apply.grants.gov/forms/GG_LobbyingForm-V1.1")
    private String namespace;
    @Value(value="GG_LobbyingForm-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/GG_LobbyingForm-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/GG_LobbyingForm-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    private LobbyingFormDocument getLobbyingForm() {
        DepartmentalPersonDto departmentalPerson;
        LobbyingFormDocument lobbyingFormDocument = (LobbyingFormDocument)LobbyingFormDocument.Factory.newInstance();
        LobbyingFormDocument.LobbyingForm lobbyingForm = (LobbyingFormDocument.LobbyingForm)LobbyingFormDocument.LobbyingForm.Factory.newInstance();
        lobbyingForm.setFormVersion(FormVersion.v1_1.getVersion());
        String applicantName = "";
        String authorizedRepresentativeTitle = "";
        String authorizedRepresentativeSignature = "";
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        if (proposalSite != null && proposalSite.getLocationName() != null) {
            applicantName = StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60);
        }
        if ((departmentalPerson = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc)).getPrimaryTitle() != null) {
            authorizedRepresentativeTitle = StringUtils.substring((String)departmentalPerson.getPrimaryTitle(), (int)0, (int)45);
        }
        if (departmentalPerson.getFullName() != null) {
            authorizedRepresentativeSignature = departmentalPerson.getFullName();
        }
        lobbyingForm.setApplicantName(applicantName);
        lobbyingForm.setAuthorizedRepresentativeTitle(authorizedRepresentativeTitle);
        lobbyingForm.setAuthorizedRepresentativeSignature(authorizedRepresentativeSignature);
        lobbyingForm.setAuthorizedRepresentativeName(this.globLibV20Generator.getHumanNameDataType(departmentalPerson));
        lobbyingForm.setSubmittedDate(departmentalPerson.getSubmittedDate());
        lobbyingFormDocument.setLobbyingForm(lobbyingForm);
        return lobbyingFormDocument;
    }

    @Override
    public LobbyingFormDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getLobbyingForm();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(LobbyingFormDocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<LobbyingFormDocument> factory() {
        return LobbyingFormDocument.Factory;
    }
}

