/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage18V18.NSFCoverPage18Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV1_8Generator")
public class NSFCoverPageV1_8Generator
extends NSFCoverPageBaseGenerator<NSFCoverPage18Document>
implements S2SFormGeneratorPdfFillable<NSFCoverPage18Document> {
    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    private static final int GOALI = -1;
    private static final int RAISE = -2;
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage_1_8-V1.8")
    private String namespace;
    @Value(value="NSF_CoverPage_1_8")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.8.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_1_8-V1.8.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;

    private NSFCoverPage18Document getNSFCoverPage18() {
        AttachedFileDataType raise;
        AttachedFileDataType goali;
        AttachedFileDataType mentoringPlan;
        AttachedFileDataType dataManagementPlan;
        NSFCoverPage18Document nsfCoverPage18Document = (NSFCoverPage18Document)NSFCoverPage18Document.Factory.newInstance();
        NSFCoverPage18Document.NSFCoverPage18 nsfCoverPage18 = (NSFCoverPage18Document.NSFCoverPage18)NSFCoverPage18Document.NSFCoverPage18.Factory.newInstance();
        nsfCoverPage18.setFormVersion(FormVersion.v1_8.getVersion());
        this.setFundingOpportunityNumber(nsfCoverPage18);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage18.setDueDate(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage18.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage18);
        this.setNsfId(nsfCoverPage18);
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage18.setSingleCopyDocuments(attachmentGroup);
        }
        if ((dataManagementPlan = this.getAttachedNarrativeFile(146)) != null) {
            nsfCoverPage18.setDataManagementPlan(dataManagementPlan);
        }
        if ((mentoringPlan = this.getAttachedNarrativeFile(147)) != null) {
            nsfCoverPage18.setMentoringPlan(mentoringPlan);
        }
        if ((goali = this.getAttachedNarrativeFile(-1)) != null) {
            nsfCoverPage18.setGOALILetter(goali);
        }
        if ((raise = this.getAttachedNarrativeFile(-2)) != null) {
            nsfCoverPage18.setRAISEEmails(raise);
        }
        nsfCoverPage18Document.setNSFCoverPage18(nsfCoverPage18);
        return nsfCoverPage18Document;
    }

    private void setNsfId(NSFCoverPage18Document.NSFCoverPage18 nsfCoverPage18) {
        DepartmentalPersonDto person = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        nsfCoverPage18.setNSFID(person.getNsfId());
    }

    protected void setFundingMechanism(NSFCoverPage18Document.NSFCoverPage18 nsfCoverPage18, String answer) {
        NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.Enum fundingMechanism = StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CONFERENCE.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CONFERENCE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAPID.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAPID : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EAGER.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EAGER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EQUIPMENT.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.EQUIPMENT : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAISE.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RAISE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FELLOWSHIP.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FELLOWSHIP : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.IDEAS_LAB.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.IDEAS_LAB : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.GOALI.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.GOALI : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FASED.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.FASED : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.TRAVEL.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.TRAVEL : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RESEARCH.toString()) ? NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RESEARCH : null)))))))))));
        nsfCoverPage18.setFundingMechanism(fundingMechanism);
    }

    private void setFundingOpportunityNumber(NSFCoverPage18Document.NSFCoverPage18 nsfCoverPage18) {
        nsfCoverPage18.setFundingOpportunityNumber(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), (int)0, (int)40));
    }

    private void setOtherInfo(NSFCoverPage18Document.NSFCoverPage18 nsfCoverPage18) {
        nsfCoverPage18.setFundingMechanism(NSFCoverPage18Document.NSFCoverPage18.FundingMechanism.RESEARCH);
        NSFCoverPage18Document.NSFCoverPage18.OtherInfo otherInfo = (NSFCoverPage18Document.NSFCoverPage18.OtherInfo)NSFCoverPage18Document.NSFCoverPage18.OtherInfo.Factory.newInstance();
        NSFCoverPage18Document.NSFCoverPage18.PIInfo pInfo = (NSFCoverPage18Document.NSFCoverPage18.PIInfo)NSFCoverPage18Document.NSFCoverPage18.PIInfo.Factory.newInstance();
        List questionnaireAnswers = this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        int unansweredQuestions = questionnaireAnswers.size();
        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 10: {
                    this.setFundingMechanism(nsfCoverPage18, answer);
                    --unansweredQuestions;
                    break;
                }
                case 11: {
                    otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
            }
        }
        nsfCoverPage18.setOtherInfo(unansweredQuestions == 0 ? otherInfo : null);
        nsfCoverPage18.setPIInfo(pInfo);
    }

    @Override
    public NSFCoverPage18Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage18();
    }

    protected NSFCoverPage18Document.NSFCoverPage18.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage18Document.NSFCoverPage18.NSFUnitConsideration nsfConsideration = (NSFCoverPage18Document.NSFCoverPage18.NSFUnitConsideration)NSFCoverPage18Document.NSFCoverPage18.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NSFCoverPage18Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType dataManagementPlanAttachedFile;
            if (form.getNSFCoverPage18().getSingleCopyDocuments() != null && form.getNSFCoverPage18().getSingleCopyDocuments().getAttachedFileList() != null) {
                List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage18().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); ++i) {
                    AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (!a.getContentId().equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NSF_CoverPage_1_8_P1.optionalFile1_" + i, a);
                }
            }
            if ((dataManagementPlanAttachedFile = form.getNSFCoverPage18().getDataManagementPlan()) != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_8_P1.optionalFile2", a);
            }
            AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage18().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_8_P1.optionalFile3", a);
            }
            AttachedFileDataType goaliLetterAttachedFile = form.getNSFCoverPage18().getGOALILetter();
            if (goaliLetterAttachedFile != null && a.getContentId().equals(goaliLetterAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_8_P1.optionalFile4", a);
            }
            AttachedFileDataType raiseAttachedFile = form.getNSFCoverPage18().getRAISEEmails();
            if (raiseAttachedFile != null && a.getContentId().equals(raiseAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_8_P1.optionalFile5", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage18Document> factory() {
        return NSFCoverPage18Document.Factory;
    }
}

