/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage20V20.NSFCoverPage20Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV2_0Generator")
public class NSFCoverPageV2_0Generator
extends NSFCoverPageBaseGenerator<NSFCoverPage20Document>
implements S2SFormGeneratorPdfFillable<NSFCoverPage20Document> {
    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    private static final int FUNDING_INT_BRANCH_CAMPUS_QUESTION = 12;
    private static final int FUNDING_FOREIGN_ORG_QUESTION = 13;
    private static final int GOALI = -1;
    private static final int RAISE = -2;
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage_2_0-V2.0")
    private String namespace;
    @Value(value="NSF_CoverPage_2_0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V2.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;

    private NSFCoverPage20Document getNSFCoverPage20() {
        AttachedFileDataType raise;
        AttachedFileDataType goali;
        AttachedFileDataType mentoringPlan;
        AttachedFileDataType dataManagementPlan;
        NSFCoverPage20Document nsfCoverPage20Document = (NSFCoverPage20Document)NSFCoverPage20Document.Factory.newInstance();
        NSFCoverPage20Document.NSFCoverPage20 nsfCoverPage20 = (NSFCoverPage20Document.NSFCoverPage20)NSFCoverPage20Document.NSFCoverPage20.Factory.newInstance();
        nsfCoverPage20.setFormVersion(FormVersion.v2_0.getVersion());
        this.setFundingOpportunityNumber(nsfCoverPage20);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage20.setDueDate(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage20.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage20);
        this.setNsfId(nsfCoverPage20);
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage20.setSingleCopyDocuments(attachmentGroup);
        }
        if ((dataManagementPlan = this.getAttachedNarrativeFile(146)) != null) {
            nsfCoverPage20.setDataManagementPlan(dataManagementPlan);
        }
        if ((mentoringPlan = this.getAttachedNarrativeFile(147)) != null) {
            nsfCoverPage20.setMentoringPlan(mentoringPlan);
        }
        if ((goali = this.getAttachedNarrativeFile(-1)) != null) {
            nsfCoverPage20.setGOALILetter(goali);
        }
        if ((raise = this.getAttachedNarrativeFile(-2)) != null) {
            nsfCoverPage20.setRAISEEmail(raise);
        }
        nsfCoverPage20Document.setNSFCoverPage20(nsfCoverPage20);
        return nsfCoverPage20Document;
    }

    private void setNsfId(NSFCoverPage20Document.NSFCoverPage20 nsfCoverPage20) {
        DepartmentalPersonDto person = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        nsfCoverPage20.setNSFID(person.getNsfId());
    }

    protected void setFundingMechanism(NSFCoverPage20Document.NSFCoverPage20 nsfCoverPage20, String answer) {
        NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.Enum fundingMechanism = StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.CONFERENCE.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.CONFERENCE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RAPID.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RAPID : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.EAGER.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.EAGER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.EQUIPMENT.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.EQUIPMENT : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RAISE.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RAISE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.FELLOWSHIP.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.FELLOWSHIP : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.IDEAS_LAB.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.IDEAS_LAB : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.GOALI.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.GOALI : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.FASED.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.FASED : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.TRAVEL.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.TRAVEL : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.CENTER.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.CENTER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RESEARCH_INFRASTRUCTURE.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RESEARCH_INFRASTRUCTURE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RESEARCH.toString()) ? NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RESEARCH : null))))))))))));
        nsfCoverPage20.setFundingMechanism(fundingMechanism);
    }

    private void setFundingOpportunityNumber(NSFCoverPage20Document.NSFCoverPage20 nsfCoverPage20) {
        nsfCoverPage20.setFundingOpportunityNumber(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), (int)0, (int)40));
    }

    private void setOtherInfo(NSFCoverPage20Document.NSFCoverPage20 nsfCoverPage20) {
        nsfCoverPage20.setFundingMechanism(NSFCoverPage20Document.NSFCoverPage20.FundingMechanism.RESEARCH);
        NSFCoverPage20Document.NSFCoverPage20.OtherInfo otherInfo = (NSFCoverPage20Document.NSFCoverPage20.OtherInfo)NSFCoverPage20Document.NSFCoverPage20.OtherInfo.Factory.newInstance();
        NSFCoverPage20Document.NSFCoverPage20.PIInfo pInfo = (NSFCoverPage20Document.NSFCoverPage20.PIInfo)NSFCoverPage20Document.NSFCoverPage20.PIInfo.Factory.newInstance();
        List questionnaireAnswers = this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        int unansweredQuestions = questionnaireAnswers.size();
        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 10: {
                    this.setFundingMechanism(nsfCoverPage20, answer);
                    --unansweredQuestions;
                    break;
                }
                case 11: {
                    otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 12: {
                    otherInfo.setIsFundingInternationalBranch(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 13: {
                    otherInfo.setIsFundingForeignOrganization(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
            }
        }
        nsfCoverPage20.setOtherInfo(unansweredQuestions == 0 ? otherInfo : null);
        nsfCoverPage20.setPIInfo(pInfo);
    }

    @Override
    public NSFCoverPage20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage20();
    }

    protected NSFCoverPage20Document.NSFCoverPage20.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage20Document.NSFCoverPage20.NSFUnitConsideration nsfConsideration = (NSFCoverPage20Document.NSFCoverPage20.NSFUnitConsideration)NSFCoverPage20Document.NSFCoverPage20.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NSFCoverPage20Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType dataManagementPlanAttachedFile;
            if (form.getNSFCoverPage20().getSingleCopyDocuments() != null && form.getNSFCoverPage20().getSingleCopyDocuments().getAttachedFileList() != null) {
                List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage20().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); ++i) {
                    AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (!a.getContentId().equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NSF_CoverPage_2_0_P1.optionalFile1_" + i, a);
                }
            }
            if ((dataManagementPlanAttachedFile = form.getNSFCoverPage20().getDataManagementPlan()) != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_0_P1.optionalFile2", a);
            }
            AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage20().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_0_P1.optionalFile3", a);
            }
            AttachedFileDataType goaliLetterAttachedFile = form.getNSFCoverPage20().getGOALILetter();
            if (goaliLetterAttachedFile != null && a.getContentId().equals(goaliLetterAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_0_P1.optionalFile4", a);
            }
            AttachedFileDataType raiseAttachedFile = form.getNSFCoverPage20().getRAISEEmail();
            if (raiseAttachedFile != null && a.getContentId().equals(raiseAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_2_0_P1.optionalFile5", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage20Document> factory() {
        return NSFCoverPage20Document.Factory;
    }
}

