/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398ModularBudgetV11.PHS398ModularBudgetDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.impl.budget.BudgetPeriodNum;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398ModularBudgetBaseGenerator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398ModularBudgetV1_1Generator")
public class PHS398ModularBudgetV1_1Generator
extends PHS398ModularBudgetBaseGenerator<PHS398ModularBudgetDocument> {
    @Value(value="http://apply.grants.gov/forms/PHS398_ModularBudget-V1.1")
    private String namespace;
    @Value(value="PHS398_ModularBudget-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_ModularBudget-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="190")
    private int sortIndex;
    private ScaleTwoDecimal cumulativeConsortiumFandA = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeDirectCostLessConsortiumFandA = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeTotalFundsRequestedDirectCosts = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeTotalFundsRequestedDirectIndirectCosts = ScaleTwoDecimal.ZERO;
    private ScaleTwoDecimal cumulativeTotalFundsRequestedIndirectCost = ScaleTwoDecimal.ZERO;

    private PHS398ModularBudgetDocument getPHS398ModularBudget() {
        PHS398ModularBudgetDocument modularBudgetDocument = (PHS398ModularBudgetDocument)PHS398ModularBudgetDocument.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget modularBudget = (PHS398ModularBudgetDocument.PHS398ModularBudget)PHS398ModularBudgetDocument.PHS398ModularBudget.Factory.newInstance();
        modularBudget.setFormVersion(FormVersion.v1_1.getVersion());
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        List modularAmounts = this.getModularBudgetService().getModularBudgetAmounts((BudgetContract)budget);
        if (budget != null) {
            for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod().intValue() == BudgetPeriodNum.P1.getNum()) {
                    modularBudget.setPeriods(this.getPeriods(budgetPeriod, modularAmounts));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod().intValue() == BudgetPeriodNum.P2.getNum()) {
                    modularBudget.setPeriods2(this.getPeriods2(budgetPeriod, modularAmounts));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod().intValue() == BudgetPeriodNum.P3.getNum()) {
                    modularBudget.setPeriods3(this.getPeriods3(budgetPeriod, modularAmounts));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod().intValue() == BudgetPeriodNum.P4.getNum()) {
                    modularBudget.setPeriods4(this.getPeriods4(budgetPeriod, modularAmounts));
                    continue;
                }
                if (budgetPeriod.getBudgetPeriod().intValue() != BudgetPeriodNum.P5.getNum()) continue;
                modularBudget.setPeriods5(this.getPeriods5(budgetPeriod, modularAmounts));
            }
            modularBudget.setCummulativeBudgetInfo(this.getCummBudget());
        }
        modularBudgetDocument.setPHS398ModularBudget(modularBudget);
        return modularBudgetDocument;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo getCummBudget() {
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo cummulativeBudgetInfo = (PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo)PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.EntirePeriodTotalCost entireCost = (PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.EntirePeriodTotalCost)PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.EntirePeriodTotalCost.Factory.newInstance();
        entireCost.setCumulativeDirectCostLessConsortiumFandA(BigDecimal.ZERO);
        entireCost.setCumulativeTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        entireCost.setCumulativeTotalFundsRequestedDirectIndirectCosts(BigDecimal.ZERO);
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications budgetJustifications = (PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications)PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.Factory.newInstance();
        if (!this.cumulativeTotalFundsRequestedDirectIndirectCosts.toString().equals("0")) {
            entireCost.setCumulativeDirectCostLessConsortiumFandA(this.cumulativeDirectCostLessConsortiumFandA.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedDirectCosts(this.cumulativeTotalFundsRequestedDirectCosts.bigDecimalValue());
            entireCost.setCumulativeConsortiumFandA(this.cumulativeConsortiumFandA.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedDirectIndirectCosts(this.cumulativeTotalFundsRequestedDirectIndirectCosts.bigDecimalValue());
            entireCost.setCumulativeTotalFundsRequestedIndirectCost(this.cumulativeTotalFundsRequestedIndirectCost.bigDecimalValue());
            budgetJustifications = this.getBudgetJustifications();
            if (budgetJustifications.getAdditionalNarrativeJustification() != null || budgetJustifications.getConsortiumJustification() != null || budgetJustifications.getPersonnelJustification() != null) {
                cummulativeBudgetInfo.setBudgetJustifications(budgetJustifications);
            }
        }
        cummulativeBudgetInfo.setEntirePeriodTotalCost(entireCost);
        return cummulativeBudgetInfo;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications getBudgetJustifications() {
        PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications budgetJustifications = (PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications)PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.Factory.newInstance();
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null) continue;
            if (Integer.parseInt(narrative.getNarrativeType().getCode()) == 35) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification personnelJustification = (PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification)PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.PersonnelJustification.Factory.newInstance();
                personnelJustification.setAttFile(attachedFileDataType);
                budgetJustifications.setPersonnelJustification(personnelJustification);
            }
            if (Integer.parseInt(narrative.getNarrativeType().getCode()) == 36) {
                attachedFileDataType = this.addAttachedFileType(narrative);
                if (attachedFileDataType == null) continue;
                PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification consortiumJustification = (PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification)PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.ConsortiumJustification.Factory.newInstance();
                consortiumJustification.setAttFile(attachedFileDataType);
                budgetJustifications.setConsortiumJustification(consortiumJustification);
            }
            if (Integer.parseInt(narrative.getNarrativeType().getCode()) != 37 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification narrativeJustification = (PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification)PHS398ModularBudgetDocument.PHS398ModularBudget.CummulativeBudgetInfo.BudgetJustifications.AdditionalNarrativeJustification.Factory.newInstance();
            narrativeJustification.setAttFile(attachedFileDataType);
            budgetJustifications.setAdditionalNarrativeJustification(narrativeJustification);
        }
        return budgetJustifications;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods getPeriods(BudgetPeriodContract budgetPeriod, List<? extends BudgetModularContract> modularAmounts) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods periods = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.DirectCost directCost = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.DirectCost)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.DirectCost.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost indirectCost = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.Factory.newInstance();
        ScaleTwoDecimal consortiumFandA = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal directCostLessConsortiumFandA = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalDirectCosts = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdTotalIndirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdBaseCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal bdRate = ScaleTwoDecimal.ZERO;
        String costType = null;
        periods.setBudgetPeriod(1);
        if (budgetPeriod.getStartDate() != null) {
            periods.setBudgetPeriodStartDate(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods.setBudgetPeriodEndDate(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost.setDirectCostLessConsortiumFandA(BigDecimal.ZERO);
        directCost.setTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        periods.setTotalFundsRequestedDirectIndirectCosts(BigDecimal.ZERO);
        BudgetModularContract budgetModular = this.modularBudgetService.getModularBudgetForPeriod(modularAmounts, budgetPeriod);
        if (budgetModular != null) {
            ScaleTwoDecimal totalCost = this.getTotalCost(budgetModular);
            periods.setTotalFundsRequestedDirectIndirectCosts(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                consortiumFandA = budgetModular.getConsortiumFna();
                directCost.setConsortiumFandA(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (ScaleTwoDecimal)this.cumulativeConsortiumFandA.add((AbstractDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost.setDirectCostLessConsortiumFandA(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (ScaleTwoDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost.setTotalFundsRequestedDirectCosts(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractDecimal)totalDirectCosts);
            }
            ArrayList<PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems> indirectCostItemsList = new ArrayList<PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems>();
            for (BudgetModularIdcContract budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems indirectCostItems = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (ScaleTwoDecimal)bdTotalIndirectCost.add((AbstractDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getRateClass() != null ? budgetModularIdc.getRateClass().getDescription() : budgetModularIdc.getDescription();
                    indirectCostItems.setIndirectCostTypeDescription(costType);
                }
                indirectCostItemsList.add(indirectCostItems);
            }
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems[] indirectCostItemsArray = indirectCostItemsList.toArray(new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods.IndirectCost.IndirectCostItems[0]);
            indirectCost.setIndirectCostItemsArray(indirectCostItemsArray);
        }
        periods.setDirectCost(directCost);
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            RolodexContract rolodex;
            if (organization.getCognizantAuditor() != null && (rolodex = this.rolodexService.getRolodex(organization.getCognizantAuditor())) != null) {
                indirectCost.setCognizantFederalAgency(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost.setIndirectCostAgreementDate(this.s2SDateTimeService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost.setTotalFundsRequestedIndirectCost(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractDecimal)bdTotalIndirectCost);
        periods.setIndirectCost(indirectCost);
        return periods;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2 getPeriods2(BudgetPeriodContract budgetPeriod, List<? extends BudgetModularContract> modularAmounts) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2 periods2 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.DirectCost2 directCost2 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.DirectCost2)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.DirectCost2.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2 indirectCost2 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.Factory.newInstance();
        ScaleTwoDecimal bdTotalIndirectCost = ScaleTwoDecimal.ZERO;
        periods2.setBudgetPeriod2(2);
        if (budgetPeriod.getStartDate() != null) {
            periods2.setBudgetPeriodStartDate2(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods2.setBudgetPeriodEndDate2(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost2.setDirectCostLessConsortiumFandA2(BigDecimal.ZERO);
        directCost2.setTotalFundsRequestedDirectCosts2(BigDecimal.ZERO);
        periods2.setTotalFundsRequestedDirectIndirectCosts2(BigDecimal.ZERO);
        BudgetModularContract budgetModular = this.modularBudgetService.getModularBudgetForPeriod(modularAmounts, budgetPeriod);
        if (budgetModular != null) {
            ScaleTwoDecimal totalCost = this.getTotalCost(budgetModular);
            periods2.setTotalFundsRequestedDirectIndirectCosts2(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                ScaleTwoDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost2.setConsortiumFandA2(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (ScaleTwoDecimal)this.cumulativeConsortiumFandA.add((AbstractDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                ScaleTwoDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost2.setDirectCostLessConsortiumFandA2(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (ScaleTwoDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                ScaleTwoDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost2.setTotalFundsRequestedDirectCosts2(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractDecimal)totalDirectCosts);
            }
            ScaleTwoDecimal bdCost = null;
            ScaleTwoDecimal bdBaseCost = null;
            ScaleTwoDecimal bdRate = null;
            String costType = null;
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2[] indirectCostItems2Array = null;
            if (budgetModular != null && budgetModular.getBudgetModularIdcs() != null) {
                indirectCostItems2Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2[budgetModular.getBudgetModularIdcs().size()];
            }
            int costItems = 0;
            for (BudgetModularIdcContract budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2 indirectCostItems2 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods2.IndirectCost2.IndirectCostItems2.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems2.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (ScaleTwoDecimal)bdTotalIndirectCost.add((AbstractDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems2.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems2.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getRateClass() != null ? budgetModularIdc.getRateClass().getDescription() : budgetModularIdc.getDescription();
                    indirectCostItems2.setIndirectCostTypeDescription(costType);
                }
                if (indirectCostItems2Array == null) continue;
                indirectCostItems2Array[costItems] = indirectCostItems2;
                ++costItems;
            }
            indirectCost2.setIndirectCostItems2Array(indirectCostItems2Array);
        }
        periods2.setDirectCost2(directCost2);
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            RolodexContract rolodex;
            if (organization.getCognizantAuditor() != null && (rolodex = this.rolodexService.getRolodex(organization.getCognizantAuditor())) != null) {
                indirectCost2.setCognizantFederalAgency2(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost2.setIndirectCostAgreementDate2(this.s2SDateTimeService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost2.setTotalFundsRequestedIndirectCost2(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractDecimal)bdTotalIndirectCost);
        periods2.setIndirectCost2(indirectCost2);
        return periods2;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3 getPeriods3(BudgetPeriodContract budgetPeriod, List<? extends BudgetModularContract> modularAmounts) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3 periods3 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.DirectCost3 directCost3 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.DirectCost3)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.DirectCost3.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3 indirectCost3 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.Factory.newInstance();
        ScaleTwoDecimal bdTotalIndirectCost = ScaleTwoDecimal.ZERO;
        periods3.setBudgetPeriod3(3);
        if (budgetPeriod.getStartDate() != null) {
            periods3.setBudgetPeriodStartDate3(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods3.setBudgetPeriodEndDate3(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost3.setDirectCostLessConsortiumFandA3(BigDecimal.ZERO);
        directCost3.setTotalFundsRequestedDirectCosts3(BigDecimal.ZERO);
        periods3.setTotalFundsRequestedDirectIndirectCosts3(BigDecimal.ZERO);
        BudgetModularContract budgetModular = this.modularBudgetService.getModularBudgetForPeriod(modularAmounts, budgetPeriod);
        if (budgetModular != null) {
            ScaleTwoDecimal totalCost = this.getTotalCost(budgetModular);
            periods3.setTotalFundsRequestedDirectIndirectCosts3(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                ScaleTwoDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost3.setConsortiumFandA3(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (ScaleTwoDecimal)this.cumulativeConsortiumFandA.add((AbstractDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                ScaleTwoDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost3.setDirectCostLessConsortiumFandA3(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (ScaleTwoDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                ScaleTwoDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost3.setTotalFundsRequestedDirectCosts3(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractDecimal)totalDirectCosts);
            }
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3[] indirectCostItems3Array = null;
            if (budgetModular.getBudgetModularIdcs() != null) {
                indirectCostItems3Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3[budgetModular.getBudgetModularIdcs().size()];
            }
            ScaleTwoDecimal bdCost = null;
            ScaleTwoDecimal bdBaseCost = null;
            ScaleTwoDecimal bdRate = null;
            String costType = null;
            int costItems = 0;
            for (BudgetModularIdcContract budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3 indirectCostItems3 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods3.IndirectCost3.IndirectCostItems3.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems3.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (ScaleTwoDecimal)bdTotalIndirectCost.add((AbstractDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems3.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems3.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getRateClass() != null ? budgetModularIdc.getRateClass().getDescription() : budgetModularIdc.getDescription();
                    indirectCostItems3.setIndirectCostTypeDescription(costType);
                }
                if (indirectCostItems3Array == null) continue;
                indirectCostItems3Array[costItems] = indirectCostItems3;
                ++costItems;
            }
            indirectCost3.setIndirectCostItems3Array(indirectCostItems3Array);
        }
        periods3.setDirectCost3(directCost3);
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            RolodexContract rolodex;
            if (organization.getCognizantAuditor() != null && (rolodex = this.rolodexService.getRolodex(organization.getCognizantAuditor())) != null) {
                indirectCost3.setCognizantFederalAgency3(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost3.setIndirectCostAgreementDate3(this.s2SDateTimeService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost3.setTotalFundsRequestedIndirectCost3(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractDecimal)bdTotalIndirectCost);
        periods3.setIndirectCost3(indirectCost3);
        return periods3;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4 getPeriods4(BudgetPeriodContract budgetPeriod, List<? extends BudgetModularContract> modularAmounts) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4 periods4 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.DirectCost4 directCost4 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.DirectCost4)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.DirectCost4.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4 indirectCost4 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.Factory.newInstance();
        ScaleTwoDecimal bdTotalIndirectCost = ScaleTwoDecimal.ZERO;
        periods4.setBudgetPeriod4(4);
        if (budgetPeriod.getStartDate() != null) {
            periods4.setBudgetPeriodStartDate4(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods4.setBudgetPeriodEndDate4(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost4.setDirectCostLessConsortiumFandA4(BigDecimal.ZERO);
        directCost4.setTotalFundsRequestedDirectCosts4(BigDecimal.ZERO);
        periods4.setTotalFundsRequestedDirectIndirectCosts4(BigDecimal.ZERO);
        BudgetModularContract budgetModular = this.modularBudgetService.getModularBudgetForPeriod(modularAmounts, budgetPeriod);
        if (budgetModular != null) {
            ScaleTwoDecimal totalCost = this.getTotalCost(budgetModular);
            periods4.setTotalFundsRequestedDirectIndirectCosts4(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                ScaleTwoDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost4.setConsortiumFandA4(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (ScaleTwoDecimal)this.cumulativeConsortiumFandA.add((AbstractDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                ScaleTwoDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost4.setDirectCostLessConsortiumFandA4(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (ScaleTwoDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                ScaleTwoDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost4.setTotalFundsRequestedDirectCosts4(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractDecimal)totalDirectCosts);
            }
            ScaleTwoDecimal bdCost = null;
            ScaleTwoDecimal bdBaseCost = null;
            ScaleTwoDecimal bdRate = null;
            String costType = null;
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4[] indirectCostItems4Array = null;
            if (budgetModular.getBudgetModularIdcs() != null) {
                indirectCostItems4Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4[budgetModular.getBudgetModularIdcs().size()];
            }
            int costItems = 0;
            for (BudgetModularIdcContract budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4 indirectCostItems4 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods4.IndirectCost4.IndirectCostItems4.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems4.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (ScaleTwoDecimal)bdTotalIndirectCost.add((AbstractDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems4.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems4.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getRateClass() != null ? budgetModularIdc.getRateClass().getDescription() : budgetModularIdc.getDescription();
                    indirectCostItems4.setIndirectCostTypeDescription(costType);
                }
                if (indirectCostItems4Array == null) continue;
                indirectCostItems4Array[costItems] = indirectCostItems4;
                ++costItems;
            }
            indirectCost4.setIndirectCostItems4Array(indirectCostItems4Array);
        }
        periods4.setDirectCost4(directCost4);
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            RolodexContract rolodex;
            if (organization.getCognizantAuditor() != null && (rolodex = this.rolodexService.getRolodex(organization.getCognizantAuditor())) != null) {
                indirectCost4.setCognizantFederalAgency4(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost4.setIndirectCostAgreementDate4(this.s2SDateTimeService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost4.setTotalFundsRequestedIndirectCost4(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractDecimal)bdTotalIndirectCost);
        periods4.setIndirectCost4(indirectCost4);
        return periods4;
    }

    private PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5 getPeriods5(BudgetPeriodContract budgetPeriod, List<? extends BudgetModularContract> modularAmounts) {
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5 periods5 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.DirectCost5 directCost5 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.DirectCost5)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.DirectCost5.Factory.newInstance();
        PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5 indirectCost5 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.Factory.newInstance();
        ScaleTwoDecimal bdTotalIndirectCost = ScaleTwoDecimal.ZERO;
        periods5.setBudgetPeriod5(5);
        if (budgetPeriod.getStartDate() != null) {
            periods5.setBudgetPeriodStartDate5(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getStartDate()));
        }
        if (budgetPeriod.getEndDate() != null) {
            periods5.setBudgetPeriodEndDate5(this.s2SDateTimeService.convertDateToCalendar(budgetPeriod.getEndDate()));
        }
        directCost5.setDirectCostLessConsortiumFandA5(BigDecimal.ZERO);
        directCost5.setTotalFundsRequestedDirectCosts5(BigDecimal.ZERO);
        periods5.setTotalFundsRequestedDirectIndirectCosts5(BigDecimal.ZERO);
        BudgetModularContract budgetModular = this.modularBudgetService.getModularBudgetForPeriod(modularAmounts, budgetPeriod);
        if (budgetModular != null) {
            ScaleTwoDecimal totalCost = this.getTotalCost(budgetModular);
            periods5.setTotalFundsRequestedDirectIndirectCosts5(totalCost.bigDecimalValue());
            this.cumulativeTotalFundsRequestedDirectIndirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectIndirectCosts.add((AbstractDecimal)totalCost);
            if (budgetModular.getConsortiumFna() != null) {
                ScaleTwoDecimal consortiumFandA = budgetModular.getConsortiumFna();
                directCost5.setConsortiumFandA5(consortiumFandA.bigDecimalValue());
                this.cumulativeConsortiumFandA = (ScaleTwoDecimal)this.cumulativeConsortiumFandA.add((AbstractDecimal)consortiumFandA);
            }
            if (budgetModular.getDirectCostLessConsortiumFna() != null) {
                ScaleTwoDecimal directCostLessConsortiumFandA = budgetModular.getDirectCostLessConsortiumFna();
                directCost5.setDirectCostLessConsortiumFandA5(directCostLessConsortiumFandA.bigDecimalValue());
                this.cumulativeDirectCostLessConsortiumFandA = (ScaleTwoDecimal)this.cumulativeDirectCostLessConsortiumFandA.add((AbstractDecimal)directCostLessConsortiumFandA);
            }
            if (budgetModular.getTotalDirectCost() != null) {
                ScaleTwoDecimal totalDirectCosts = budgetModular.getTotalDirectCost();
                directCost5.setTotalFundsRequestedDirectCosts5(totalDirectCosts.bigDecimalValue());
                this.cumulativeTotalFundsRequestedDirectCosts = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedDirectCosts.add((AbstractDecimal)totalDirectCosts);
            }
            ScaleTwoDecimal bdCost = null;
            ScaleTwoDecimal bdBaseCost = null;
            ScaleTwoDecimal bdRate = null;
            String costType = null;
            PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5[] indirectCostItems5Array = null;
            if (budgetModular.getBudgetModularIdcs() != null) {
                indirectCostItems5Array = new PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5[budgetModular.getBudgetModularIdcs().size()];
            }
            int costItems = 0;
            for (BudgetModularIdcContract budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
                PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5 indirectCostItems5 = (PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5)PHS398ModularBudgetDocument.PHS398ModularBudget.Periods5.IndirectCost5.IndirectCostItems5.Factory.newInstance();
                if (budgetModularIdc.getFundsRequested() != null) {
                    bdCost = budgetModularIdc.getFundsRequested();
                    indirectCostItems5.setIndirectCostFundsRequested(bdCost.bigDecimalValue());
                    bdTotalIndirectCost = (ScaleTwoDecimal)bdTotalIndirectCost.add((AbstractDecimal)bdCost);
                }
                if (budgetModularIdc.getIdcBase() != null) {
                    bdBaseCost = budgetModularIdc.getIdcBase();
                    indirectCostItems5.setIndirectCostBase(bdBaseCost.bigDecimalValue());
                }
                if (budgetModularIdc.getIdcRate() != null) {
                    bdRate = budgetModularIdc.getIdcRate();
                    indirectCostItems5.setIndirectCostRate(bdRate.bigDecimalValue());
                }
                if (budgetModularIdc.getDescription() != null) {
                    costType = budgetModularIdc.getRateClass() != null ? budgetModularIdc.getRateClass().getDescription() : budgetModularIdc.getDescription();
                    indirectCostItems5.setIndirectCostTypeDescription(costType);
                }
                if (indirectCostItems5Array == null) continue;
                indirectCostItems5Array[costItems] = indirectCostItems5;
                ++costItems;
            }
            indirectCost5.setIndirectCostItems5Array(indirectCostItems5Array);
        }
        periods5.setDirectCost5(directCost5);
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            RolodexContract rolodex;
            if (organization.getCognizantAuditor() != null && (rolodex = this.rolodexService.getRolodex(organization.getCognizantAuditor())) != null) {
                indirectCost5.setCognizantFederalAgency5(this.getCognizantFederalAgency(rolodex));
            }
            if (organization.getIndirectCostRateAgreement() != null) {
                indirectCost5.setIndirectCostAgreementDate5(this.s2SDateTimeService.convertDateStringToCalendar(organization.getIndirectCostRateAgreement()));
            }
        }
        indirectCost5.setTotalFundsRequestedIndirectCost5(bdTotalIndirectCost.bigDecimalValue());
        this.cumulativeTotalFundsRequestedIndirectCost = (ScaleTwoDecimal)this.cumulativeTotalFundsRequestedIndirectCost.add((AbstractDecimal)bdTotalIndirectCost);
        periods5.setIndirectCost5(indirectCost5);
        return periods5;
    }

    @Override
    public PHS398ModularBudgetDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398ModularBudget();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHS398ModularBudgetDocument> factory() {
        return PHS398ModularBudgetDocument.Factory;
    }
}

