/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.humanSubjectStudy30V30.HumanSubjectStudy30Document;
import gov.grants.apply.forms.phsHumanSubjectsAndClinicalTrialsInfo30V30.PHSHumanSubjectsAndClinicalTrialsInfo30Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.globalV10.HashValueDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.KcFile;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHSHumanSubjectsAndClinicalTrialsInfo_3_0V3_0Generator")
public class PHSHumanSubjectsAndClinicalTrialsInfo_3_0V3_0Generator
extends S2SBaseFormGenerator<PHSHumanSubjectsAndClinicalTrialsInfo30Document>
implements S2SFormGeneratorPdfFillable<PHSHumanSubjectsAndClinicalTrialsInfo30Document>,
InitializingBean {
    private static final String APPROVAL_TYPE_EXCEMPT = "4";
    private static final String HUMAN_SUBJECT = "1";
    private static final String OTHER_REQUESTED_INFO_NARRATIVE_TYPE_CODE = "-4";
    private static final String EXPLANATION_NARRATIVE_TYPE_CODE = "-3";
    private static final int INVOLVE_HUMAN_QUESTION_SEQ_ID = -10130;
    private static final String FILES = "files";
    private static final String CONTENT = "content";
    private static final String Y = "Y";
    private static final String INVALID_HUMAN_STUDIES_ATTACHMENT = "Invalid Human Studies Attachment";
    @Value(value="http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_3_0-V3.0")
    private String namespace;
    @Value(value="PHSHumanSubjectsAndClinicalTrialsInfo_3_0-V3.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHSHumanSubjectsAndClinicalTrialsInfo-V3.0.xsl")
    private Resource page1;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection1-V3.0-modified.xsl")
    private Resource page2;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection2-V3.0-modified.xsl")
    private Resource page3;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ClinicalTrialInclusionEnrollmentReport-V3.0-modified.xsl")
    private Resource page4;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection3-V3.0-modified.xsl")
    private Resource page5;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection4-V3.0-modified.xsl")
    private Resource page6;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/HumanSubjectStudyFormSection5-V3.0-modified.xsl")
    private Resource page7;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHSHumanSubjectsAndClinicalTrialsDelayedOnsetStudy-V3.0.xsl")
    private Resource page8;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHSHumanSubjectsAndClinicalTrialsInfo_3_0-V3.0.pdf")
    private Resource pdfForm;
    @Value(value="197")
    private int sortIndex;
    private List<Resource> stylesheets;

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public PHSHumanSubjectsAndClinicalTrialsInfo30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        this.pdDoc = proposalDevelopmentDocument;
        PHSHumanSubjectsAndClinicalTrialsInfo30Document document = (PHSHumanSubjectsAndClinicalTrialsInfo30Document)PHSHumanSubjectsAndClinicalTrialsInfo30Document.Factory.newInstance();
        PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30 info = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.Factory.newInstance();
        info.setFormVersion(FormVersion.v3_0.getVersion());
        if (this.pdDoc.getDevelopmentProposal().getPropSpecialReviews().isEmpty()) {
            info.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        }
        ArrayList<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy> delayedOnsetStudiesList = new ArrayList<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy>();
        ArrayList<HumanSubjectStudy30Document.HumanSubjectStudy30> humanSubjectsStudyList = new ArrayList<HumanSubjectStudy30Document.HumanSubjectStudy30>();
        ArrayList<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT> humanSubjectATTList = new ArrayList<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT>();
        List<ProposalSpecialReviewContract> humanSpecialreviews = this.pdDoc.getDevelopmentProposal().getPropSpecialReviews().stream().filter(Objects::nonNull).filter(specialReview -> Objects.nonNull(specialReview.getSpecialReviewType())).filter(specialReview -> HUMAN_SUBJECT.equals(specialReview.getSpecialReviewType().getCode())).collect(Collectors.toList());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(humanSpecialreviews)) {
            info.setHumanSubjectsIndicator(YesNoDataType.Y_YES);
            AttachedFileDataType attachment = this.getAttachedFileDataType(OTHER_REQUESTED_INFO_NARRATIVE_TYPE_CODE);
            if (attachment != null) {
                PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.OtherRequestedInformation otherInfo = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.OtherRequestedInformation)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.OtherRequestedInformation.Factory.newInstance();
                otherInfo.setAttFile(attachment);
                info.setOtherRequestedInformation(otherInfo);
            }
            humanSpecialreviews.forEach(humanSpecialreview -> this.setDelayedOnsetAndHumanSubjectStudy((List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy>)delayedOnsetStudiesList, (List<HumanSubjectStudy30Document.HumanSubjectStudy30>)humanSubjectsStudyList, (List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT>)humanSubjectATTList, (ProposalSpecialReviewContract)humanSpecialreview));
        } else {
            info.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        }
        Set exemptionNumbers = humanSpecialreviews.stream().filter(specialReview -> Objects.nonNull(specialReview.getApprovalType())).filter(specialReview -> APPROVAL_TYPE_EXCEMPT.equalsIgnoreCase(specialReview.getApprovalType().getCode())).filter(specialReview -> Objects.nonNull(specialReview.getSpecialReviewExemptions())).flatMap(specialReview -> specialReview.getSpecialReviewExemptions().stream()).filter(Objects::nonNull).map(e -> e.getExemptionType().getCode()).map(Integer::parseInt).filter(c -> c > 0 && c < 9).collect(Collectors.toSet());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(exemptionNumbers)) {
            info.setExemptFedReg(YesNoDataType.Y_YES);
            PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.ExemptionNumbers en = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.ExemptionNumbers)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.ExemptionNumbers.Factory.newInstance();
            en.setExemptionNumberArray((PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.ExemptionNumbers.ExemptionNumber.Enum[])exemptionNumbers.stream().map(PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.ExemptionNumbers.ExemptionNumber.Enum::forInt).toArray(PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.ExemptionNumbers.ExemptionNumber.Enum[]::new));
            info.setExemptionNumbers(en);
        } else {
            info.setExemptFedReg(YesNoDataType.N_NO);
        }
        List answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        String involveHumanSpecimens = this.getAnswer(-10130, answerHeaders);
        if (StringUtils.isNotBlank((CharSequence)involveHumanSpecimens)) {
            if (Y.equals(involveHumanSpecimens)) {
                info.setInvolveHumanSpecimens(YesNoDataType.Y_YES);
                AttachedFileDataType attachment = this.getAttachedFileDataType(EXPLANATION_NARRATIVE_TYPE_CODE);
                PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.Explanation explanation = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.Explanation)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.Explanation.Factory.newInstance();
                if (attachment != null) {
                    explanation.setAttFile(attachment);
                    info.setExplanation(explanation);
                }
            } else {
                info.setInvolveHumanSpecimens(YesNoDataType.N_NO);
            }
        }
        this.consolidateAllDelayedOnsetAndHumanSubjectStudies(info, delayedOnsetStudiesList, humanSubjectsStudyList, humanSubjectATTList);
        document.setPHSHumanSubjectsAndClinicalTrialsInfo30(info);
        return document;
    }

    private void setDelayedOnsetAndHumanSubjectStudy(List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy> delayedOnsetStudiesList, List<HumanSubjectStudy30Document.HumanSubjectStudy30> humanSubjectsStudyList, List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT> humanSubjectATTList, ProposalSpecialReviewContract sr) {
        if (sr.getSpecialReviewAttachment() != null && sr.getSpecialReviewAttachment().getData() != null && StringUtils.isNotBlank((CharSequence)sr.getSpecialReviewAttachment().getName())) {
            if (!sr.getSpecialReviewAttachment().isAttachmentDelayedOnset().booleanValue()) {
                try {
                    Map fileData = sr.getSpecialReviewAttachment().getSpecialReviewAttachmentXmlFileData();
                    if (fileData != null) {
                        this.setHumanSubjectStudy(humanSubjectsStudyList, fileData);
                        this.setHumanSubjectAtt(humanSubjectATTList, sr.getSpecialReviewAttachment().getName());
                    }
                    this.getAuditErrors().add(new AuditError("noField", INVALID_HUMAN_STUDIES_ATTACHMENT, "grantsGov.Opportunity", new String[0]));
                }
                catch (S2SException e) {
                    this.getAuditErrors().add(new AuditError("noField", INVALID_HUMAN_STUDIES_ATTACHMENT, "grantsGov.Opportunity", new String[0]));
                }
                catch (XmlException e) {
                    throw new RuntimeException(e);
                }
            } else {
                PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy study = this.getDelayedOnsetStudy(sr);
                delayedOnsetStudiesList.add(study);
            }
        }
    }

    private void consolidateAllDelayedOnsetAndHumanSubjectStudies(PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30 info, List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy> delayedOnsetStudiesList, List<HumanSubjectStudy30Document.HumanSubjectStudy30> humanSubjectsStudyList, List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT> humanSubjectATTList) {
        if (!delayedOnsetStudiesList.isEmpty()) {
            PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy[] delayedOnsetStudiesArray = delayedOnsetStudiesList.toArray(new PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy[0]);
            info.setDelayedOnsetStudyArray(delayedOnsetStudiesArray);
        }
        if (!humanSubjectsStudyList.isEmpty()) {
            HumanSubjectStudy30Document.HumanSubjectStudy30[] humanSubjectsStudyArray = humanSubjectsStudyList.toArray(new HumanSubjectStudy30Document.HumanSubjectStudy30[0]);
            PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectStudyAttachment humanSubjectStudyAttachment = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectStudyAttachment)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectStudyAttachment.Factory.newInstance();
            humanSubjectStudyAttachment.setHumanSubjectStudy30Array(humanSubjectsStudyArray);
            info.setHumanSubjectStudyAttachment(humanSubjectStudyAttachment);
        }
        if (!humanSubjectATTList.isEmpty()) {
            PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT[] humanSubjectAttArray = humanSubjectATTList.toArray(new PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT[0]);
            info.setHumanSubjectATTArray(humanSubjectAttArray);
        }
    }

    private void setHumanSubjectAtt(List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT> humanSubjectATTList, String fileName) {
        PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT att = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.HumanSubjectATT.Factory.newInstance();
        att.setATT(StringUtils.substring((String)fileName, (int)0, (int)30));
        humanSubjectATTList.add(att);
    }

    private void setHumanSubjectStudy(List<HumanSubjectStudy30Document.HumanSubjectStudy30> humanSubjectsStudyList, Map<String, Object> fileData) throws XmlException {
        String xmlContent = (String)fileData.get(CONTENT);
        List files = (List)fileData.get(FILES);
        try {
            String grantWrapperNS = "declare namespace grantwrapper='http://apply.grants.gov/system/MetaGrantApplicationWrapper';";
            String grantNS = "declare namespace grant='http://apply.grants.gov/system/MetaGrantApplication';";
            XmlObject xmlObject = (XmlObject)XmlObject.Factory.parse(xmlContent);
            XmlObject[] forms = xmlObject.selectPath("declare namespace grantwrapper='http://apply.grants.gov/system/MetaGrantApplicationWrapper';declare namespace grant='http://apply.grants.gov/system/MetaGrantApplication';$this/grantwrapper:GrantApplicationWrapper/grant:GrantApplication/grant:Forms");
            if (forms.length <= 0) {
                throw new XmlException("Unable to find study");
            }
            HumanSubjectStudy30Document study20Document = (HumanSubjectStudy30Document)HumanSubjectStudy30Document.Factory.parse(forms[0].xmlText());
            HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy = study20Document.getHumanSubjectStudy30();
            this.setInclOfIndividualAcrossLifespanAttachment(files, currentStudy);
            this.setInclOfWomenAttachment(files, currentStudy);
            this.setDataMentoringPlanAttachment(files, currentStudy);
            this.setDisseminationPlanAttachment(files, currentStudy);
            this.setInvestigationalAvailabilityAttachment(files, currentStudy);
            this.setIrbPlanAttachment(files, currentStudy);
            this.setOtherAttachments(files, currentStudy);
            this.setRRPlanAttachment(files, currentStudy);
            this.setStudyTimelineAttachment(files, currentStudy);
            this.setProtectionOfHumanSubjectsAttachment(files, currentStudy);
            this.setStudyTimelineAttachment(files, currentStudy);
            this.setStatDesignPowerAttachment(files, currentStudy);
            this.setStudyTeamStructureAttachment(files, currentStudy);
            humanSubjectsStudyList.add(currentStudy);
        }
        catch (XmlException e) {
            this.getAuditErrors().add(new AuditError("noField", INVALID_HUMAN_STUDIES_ATTACHMENT, "grantsGov.Opportunity", new String[0]));
        }
    }

    private void setInclOfIndividualAcrossLifespanAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.StudyPopulationCharacteristics.InclusionOfIndividualsAcrossLifespan inclusionOfIndividualsAcrossLifespan;
        if (currentStudy.getStudyPopulationCharacteristics() != null && (inclusionOfIndividualsAcrossLifespan = currentStudy.getStudyPopulationCharacteristics().getInclusionOfIndividualsAcrossLifespan()) != null && inclusionOfIndividualsAcrossLifespan.getAttFile() != null) {
            String fileName = inclusionOfIndividualsAcrossLifespan.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> inclusionOfIndividualsAcrossLifespan.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setInclOfWomenAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.StudyPopulationCharacteristics.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities;
        if (currentStudy.getStudyPopulationCharacteristics() != null && (inclusionOfWomenAndMinorities = currentStudy.getStudyPopulationCharacteristics().getInclusionOfWomenAndMinorities()) != null && inclusionOfWomenAndMinorities.getAttFile() != null) {
            String fileName = inclusionOfWomenAndMinorities.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> inclusionOfWomenAndMinorities.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setRRPlanAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.StudyPopulationCharacteristics.RecruitmentAndRetentionPlan recruitmentAndRetentionPlan;
        if (currentStudy.getStudyPopulationCharacteristics() != null && (recruitmentAndRetentionPlan = currentStudy.getStudyPopulationCharacteristics().getRecruitmentAndRetentionPlan()) != null && recruitmentAndRetentionPlan.getAttFile() != null) {
            String fileName = recruitmentAndRetentionPlan.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> recruitmentAndRetentionPlan.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setStudyTimelineAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.StudyPopulationCharacteristics.StudyTimeline studyTimeline;
        if (currentStudy.getStudyPopulationCharacteristics() != null && (studyTimeline = currentStudy.getStudyPopulationCharacteristics().getStudyTimeline()) != null && studyTimeline.getAttFile() != null) {
            String fileName = studyTimeline.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> studyTimeline.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setProtectionOfHumanSubjectsAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.ProtectionMonitoringPlans.ProtectionOfHumanSubjects protectionOfHumanSubjects;
        if (currentStudy.getProtectionMonitoringPlans() != null && (protectionOfHumanSubjects = currentStudy.getProtectionMonitoringPlans().getProtectionOfHumanSubjects()) != null && protectionOfHumanSubjects.getAttFile() != null) {
            String fileName = protectionOfHumanSubjects.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> protectionOfHumanSubjects.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setIrbPlanAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.ProtectionMonitoringPlans.IRBPlan irbPlan;
        if (currentStudy.getProtectionMonitoringPlans() != null && (irbPlan = currentStudy.getProtectionMonitoringPlans().getIRBPlan()) != null && irbPlan.getAttFile() != null) {
            String fileName = irbPlan.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> irbPlan.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setDataMentoringPlanAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.ProtectionMonitoringPlans.DataSafetyMonitoringPlan dataSafetyMonitoringPlan;
        if (currentStudy.getProtectionMonitoringPlans() != null && (dataSafetyMonitoringPlan = currentStudy.getProtectionMonitoringPlans().getDataSafetyMonitoringPlan()) != null && dataSafetyMonitoringPlan.getAttFile() != null) {
            String fileName = dataSafetyMonitoringPlan.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> dataSafetyMonitoringPlan.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setStudyTeamStructureAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.ProtectionMonitoringPlans.StudyTeamStructure studyTeamStructure;
        if (currentStudy.getProtectionMonitoringPlans() != null && (studyTeamStructure = currentStudy.getProtectionMonitoringPlans().getStudyTeamStructure()) != null && studyTeamStructure.getAttFile() != null) {
            String fileName = studyTeamStructure.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> studyTeamStructure.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setStatDesignPowerAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.ProtocolSynopsis.StatisticalDesignPower statisticalDesignPower;
        if (currentStudy.getProtocolSynopsis() != null && (statisticalDesignPower = currentStudy.getProtocolSynopsis().getStatisticalDesignPower()) != null && statisticalDesignPower.getAttFile() != null) {
            String fileName = statisticalDesignPower.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> statisticalDesignPower.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setInvestigationalAvailabilityAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.ProtocolSynopsis.InvestigationalAvailability investigationalAvailability;
        if (currentStudy.getProtocolSynopsis() != null && (investigationalAvailability = currentStudy.getProtocolSynopsis().getInvestigationalAvailability()) != null && investigationalAvailability.getAttFile() != null) {
            String fileName = investigationalAvailability.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> investigationalAvailability.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setDisseminationPlanAttachment(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        HumanSubjectStudy30Document.HumanSubjectStudy30.ProtocolSynopsis.DisseminationPlan disseminationPlan;
        if (currentStudy.getProtocolSynopsis() != null && (disseminationPlan = currentStudy.getProtocolSynopsis().getDisseminationPlan()) != null && disseminationPlan.getAttFile() != null) {
            String fileName = disseminationPlan.getAttFile().getFileName();
            this.findFile(files, fileName).ifPresent(fileContent -> disseminationPlan.setAttFile(this.addAttachedFileType((KcFile)fileContent)));
        }
    }

    private void setOtherAttachments(List<KcFile> files, HumanSubjectStudy30Document.HumanSubjectStudy30 currentStudy) {
        AttachmentGroupMin0Max100DataType otherClinicalTrialAttachment = currentStudy.getOtherClinicalTrialAttachment();
        if (otherClinicalTrialAttachment != null && otherClinicalTrialAttachment.getAttachedFileArray() != null) {
            AttachmentGroupMin0Max100DataType newOtherClinicalTrialAttachment = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
            newOtherClinicalTrialAttachment.setAttachedFileArray((AttachedFileDataType[])Stream.of(otherClinicalTrialAttachment.getAttachedFileArray()).map(att -> {
                String fileName = att.getFileName();
                Optional<KcFile> fileContent = this.findFile(files, fileName);
                return fileContent.map(this::addAttachedFileType).orElse(null);
            }).filter(Objects::nonNull).toArray(AttachedFileDataType[]::new));
            currentStudy.setOtherClinicalTrialAttachment(newOtherClinicalTrialAttachment);
        }
    }

    private Optional<KcFile> findFile(List<KcFile> files, String fileName) {
        return files.stream().filter(a -> a.getName().equals(fileName)).findFirst();
    }

    private PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy getDelayedOnsetStudy(ProposalSpecialReviewContract sr) {
        PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy study = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy.Factory.newInstance();
        study.setAnticipatedClinicalTrial(sr.getSpecialReviewAttachment().getClinicalTrial() != false ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
        study.setStudyTitle(sr.getSpecialReviewAttachment().getStudyTitle());
        PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy.Justification justification = (PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy.Justification)PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy.Justification.Factory.newInstance();
        justification.setAttFile(this.addAttachedFileType((KcFile)sr.getSpecialReviewAttachment()));
        study.setJustification(justification);
        return study;
    }

    protected AttachedFileDataType addAttachedFileType(KcFile data) {
        if (data != null && data.getData() != null && data.getData().length > 0) {
            String fileName = this.createUniqueFileName(data.getName(), this.getAttachments());
            AttachedFileDataType.FileLocation fileLocation = (AttachedFileDataType.FileLocation)AttachedFileDataType.FileLocation.Factory.newInstance();
            fileLocation.setHref(fileName);
            AttachedFileDataType attachedFileDataType = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
            attachedFileDataType.setFileLocation(fileLocation);
            attachedFileDataType.setFileName(fileName);
            attachedFileDataType.setMimeType(data.getType());
            HashValueDocument.HashValue hashValue = this.getHashValue(data.getData());
            attachedFileDataType.setHashValue(hashValue);
            this.addAttachment(new AttachmentData(data.getFileDataId(), fileName, fileName, data.getData(), data.getType(), hashValue.getHashAlgorithm(), hashValue.getStringValue(), data.getUploadUser(), data.getUploadTimestamp()));
            return attachedFileDataType;
        }
        return null;
    }

    String createUniqueFileName(String fileName, List<AttachmentData> currentAttachments) {
        List matchingNames = currentAttachments.stream().map(AttachmentData::getFileName).filter(f -> f.endsWith(fileName)).collect(Collectors.toList());
        if (matchingNames.isEmpty()) {
            return this.createUniqueFileName(1, fileName);
        }
        for (int i = 0; i < matchingNames.size(); ++i) {
            String newFileName = this.createUniqueFileName(i + 1, fileName);
            if (matchingNames.contains(newFileName)) continue;
            return newFileName;
        }
        return this.createUniqueFileName(matchingNames.size() + 1, fileName);
    }

    private String createUniqueFileName(int num, String fileName) {
        return "HS-" + num + "-" + fileName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public Resource getPage1() {
        return this.page1;
    }

    public void setPage1(Resource page1) {
        this.page1 = page1;
    }

    public Resource getPage2() {
        return this.page2;
    }

    public void setPage2(Resource page2) {
        this.page2 = page2;
    }

    public Resource getPage3() {
        return this.page3;
    }

    public void setPage3(Resource page3) {
        this.page3 = page3;
    }

    public Resource getPage4() {
        return this.page4;
    }

    public void setPage4(Resource page4) {
        this.page4 = page4;
    }

    public Resource getPage5() {
        return this.page5;
    }

    public void setPage5(Resource page5) {
        this.page5 = page5;
    }

    public Resource getPage6() {
        return this.page6;
    }

    public void setPage6(Resource page6) {
        this.page6 = page6;
    }

    public Resource getPage7() {
        return this.page7;
    }

    public void setPage7(Resource page7) {
        this.page7 = page7;
    }

    public Resource getPage8() {
        return this.page8;
    }

    public void setPage8(Resource page8) {
        this.page8 = page8;
    }

    public void afterPropertiesSet() {
        this.stylesheets = new ArrayList<Resource>();
        this.stylesheets.add(this.page1);
        this.stylesheets.add(this.page2);
        this.stylesheets.add(this.page3);
        this.stylesheets.add(this.page4);
        this.stylesheets.add(this.page5);
        this.stylesheets.add(this.page6);
        this.stylesheets.add(this.page7);
        this.stylesheets.add(this.page8);
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHSHumanSubjectsAndClinicalTrialsInfo30Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.Explanation explanation = form.getPHSHumanSubjectsAndClinicalTrialsInfo30().getExplanation();
            if (explanation != null && explanation.getAttFile() != null && a.getContentId().equals(explanation.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHSHumanSubjectsAndClinicalTrialsInfo_3_0_P1.optionalFile0", a);
            }
            PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.OtherRequestedInformation otherRequestedInformation = form.getPHSHumanSubjectsAndClinicalTrialsInfo30().getOtherRequestedInformation();
            if (otherRequestedInformation != null && otherRequestedInformation.getAttFile() != null && a.getContentId().equals(otherRequestedInformation.getAttFile().getFileLocation().getHref())) {
                return CollectionUtils.entry("PHSHumanSubjectsAndClinicalTrialsInfo_3_0_P1.optionalFile1", a);
            }
            List<PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy> delayedOnsetStudies = form.getPHSHumanSubjectsAndClinicalTrialsInfo30().getDelayedOnsetStudyList();
            if (delayedOnsetStudies != null) {
                for (int i = 0; i < delayedOnsetStudies.size(); ++i) {
                    PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy delayedOnsetStudy = delayedOnsetStudies.get(i);
                    PHSHumanSubjectsAndClinicalTrialsInfo30Document.PHSHumanSubjectsAndClinicalTrialsInfo30.DelayedOnsetStudy.Justification justification = delayedOnsetStudy.getJustification();
                    if (justification == null || justification.getAttFile() == null || !a.getContentId().equals(justification.getAttFile().getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("PHSHumanSubjectsAndClinicalTrialsInfo_3_0_P1.DelayedOnsetStudy.optionalFile3_" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<PHSHumanSubjectsAndClinicalTrialsInfo30Document> factory() {
        return PHSHumanSubjectsAndClinicalTrialsInfo30Document.Factory;
    }
}

