/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.performanceSite12V12.PerformanceSite12Document;
import gov.grants.apply.forms.performanceSite12V12.SiteLocationDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationYnqContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.CongressionalDistrictContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PerformanceSiteBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PerformanceSiteV1_2Generator")
public class PerformanceSiteV1_2Generator
extends PerformanceSiteBaseGenerator<PerformanceSite12Document> {
    private static final String QUESTION_ID_FOR_INDIVIDUAL_YNQ = "30";
    private static final int PERFORMING_ORG_LOCATION_TYPE_CODE = 2;
    private static final int OTHER_ORG_LOCATION_TYPE_CODE = 3;
    private static final int PERFORMANCE_SITE_LOCATION_TYPE_CODE = 4;
    @Value(value="http://apply.grants.gov/forms/PerformanceSite_1_2-V1.2")
    private String namespace;
    @Value(value="PerformanceSite_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PerformanceSite-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="130")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private PerformanceSite12Document getPerformanceSite() {
        PerformanceSite12Document performanceSite12Document = (PerformanceSite12Document)PerformanceSite12Document.Factory.newInstance();
        PerformanceSite12Document.PerformanceSite12 performanceSite12 = (PerformanceSite12Document.PerformanceSite12)PerformanceSite12Document.PerformanceSite12.Factory.newInstance();
        performanceSite12.setFormVersion(FormVersion.v1_2.getVersion());
        this.setOtherSites(performanceSite12);
        performanceSite12Document.setPerformanceSite12(performanceSite12);
        return performanceSite12Document;
    }

    private void setSiteLocationDataType(SiteLocationDataType siteLocationDataType, OrganizationContract organization) {
        if (organization.getOrganizationYnqs() != null && !organization.getOrganizationYnqs().isEmpty()) {
            for (OrganizationYnqContract organizationYnq : organization.getOrganizationYnqs()) {
                if (!organizationYnq.getQuestionId().equals(QUESTION_ID_FOR_INDIVIDUAL_YNQ)) continue;
                YesNoDataType.Enum answer = organizationYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                siteLocationDataType.setIndividual(answer);
            }
        }
    }

    private void setOtherSites(PerformanceSite12Document.PerformanceSite12 performanceSite) {
        List proposalSites = this.pdDoc.getDevelopmentProposal().getProposalSites();
        if (proposalSites != null) {
            OrganizationContract organization = null;
            SiteLocationDataType siteLocationDataType = null;
            for (ProposalSiteContract proposalSite : proposalSites) {
                String congressionalDistrict;
                organization = proposalSite.getOrganization();
                switch (proposalSite.getLocationTypeCode()) {
                    case 2: {
                        siteLocationDataType = performanceSite.addNewPrimarySite();
                        this.setSiteLocationDataType(siteLocationDataType, organization);
                        siteLocationDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
                        break;
                    }
                    case 3: 
                    case 4: {
                        siteLocationDataType = performanceSite.addNewOtherSite();
                        siteLocationDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
                    }
                }
                if (siteLocationDataType == null) continue;
                siteLocationDataType.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
                if (organization != null && organization.getDunsNumber() != null) {
                    siteLocationDataType.setDUNSNumber(organization.getDunsNumber());
                }
                if ((congressionalDistrict = this.getCongressionalDistrict(proposalSite)) == null) continue;
                siteLocationDataType.setCongressionalDistrictProgramProject(congressionalDistrict);
            }
        }
    }

    private String getCongressionalDistrict(ProposalSiteContract proposalSite) {
        String congDistrictProject = null;
        for (CongressionalDistrictContract congDistrict : proposalSite.getCongressionalDistricts()) {
            congDistrictProject = congDistrict.getCongressionalDistrict();
            if (congDistrictProject == null || congDistrictProject.length() <= 6) continue;
            congDistrictProject = congDistrictProject.substring(0, 6);
        }
        return congDistrictProject;
    }

    @Override
    public PerformanceSite12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPerformanceSite();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PerformanceSite12Document> factory() {
        return PerformanceSite12Document.Factory;
    }
}

