/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.country;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;

public class CountryCodeValuesFinder
extends UifKeyValuesFinderBase {
    private static final long serialVersionUID = -3369161005640011131L;
    private CountryService countryService;

    public List<KeyValue> getKeyValues() {
        Country defaultCountry = this.getCountryService().getDefaultCountry();
        List<KeyValue> keyValues = this.getCountryService().findAllCountries().stream().filter(country -> Objects.nonNull(this.getName((Country)country))).sorted((a, b) -> {
            if (defaultCountry != null && a.getCode().equals(defaultCountry.getCode())) {
                return -1;
            }
            if (defaultCountry != null && b.getCode().equals(defaultCountry.getCode())) {
                return 1;
            }
            return this.getName((Country)a).compareToIgnoreCase(this.getName((Country)b));
        }).map(country -> new ConcreteKeyValue(country.getAlternateCode(), this.getName((Country)country))).collect(Collectors.toList());
        if (this.isAddBlankOption()) {
            keyValues.add(0, ValuesFinderUtils.getSelectOption());
        }
        return keyValues;
    }

    private String getName(Country country) {
        return StringUtils.isNotBlank((CharSequence)country.getNameV3()) ? country.getNameV3() : country.getName();
    }

    public CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }
}

