/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.XmlHelper;
import org.apache.ojb.broker.util.pooling.PoolConfiguration;

public class ConnectionPoolDescriptor
extends PoolConfiguration
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -3071461685659671879L;
    public static final String JDBC_PROPERTY_NAME_PREFIX = "jdbc.";
    private static final int JDBC_PROPERTY_NAME_LENGTH = "jdbc.".length();
    public static final String DBCP_PROPERTY_NAME_PREFIX = "dbcp.";
    private static final int DBCP_PROPERTY_NAME_LENGTH = "dbcp.".length();
    protected Properties jdbcProperties;
    protected Properties dbcpProperties;
    public static final String FETCH_SIZE = "fetchSize";
    private Class connectionFactory;

    public ConnectionPoolDescriptor() {
        this.init();
    }

    private void init() {
        this.jdbcProperties = new Properties();
        this.dbcpProperties = new Properties();
        this.setFetchSize(0);
        this.setTestOnBorrow(true);
        this.setTestOnReturn(false);
        this.setTestWhileIdle(false);
        this.setLogAbandoned(false);
        this.setRemoveAbandoned(false);
    }

    public Class getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(Class clazz) {
        if (clazz == null) {
            throw new MetadataException("Given ConnectionFactory was null");
        }
        this.connectionFactory = clazz;
    }

    public int getFetchSize() {
        return Integer.parseInt(this.getProperty(FETCH_SIZE));
    }

    public void setFetchSize(int n) {
        this.setProperty(FETCH_SIZE, Integer.toString(n));
    }

    public Properties getJdbcProperties() {
        return this.jdbcProperties;
    }

    public Properties getDbcpProperties() {
        return this.dbcpProperties;
    }

    @Override
    public void addAttribute(String string, String string2) {
        if (string != null && string.startsWith(JDBC_PROPERTY_NAME_PREFIX)) {
            String string3 = string.substring(JDBC_PROPERTY_NAME_LENGTH);
            this.jdbcProperties.setProperty(string3, string2);
        } else if (string != null && string.startsWith(DBCP_PROPERTY_NAME_PREFIX)) {
            String string4 = string.substring(DBCP_PROPERTY_NAME_LENGTH);
            this.dbcpProperties.setProperty(string4, string2);
        } else {
            super.addAttribute(string, string2);
        }
    }

    @Override
    public String toXML() {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        String string = SystemUtils.LINE_SEPARATOR;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("      ").append(repositoryTags.getOpeningTagById(65)).append(string);
        stringBuffer.append("         " + repositoryTags.getAttribute(55, "" + this.getMaxActive()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(56, "" + this.getMaxIdle()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(57, "" + this.getMaxWait()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(58, "" + this.getMinEvictableIdleTimeMillis()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(59, "" + this.getNumTestsPerEvictionRun()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(60, "" + this.isTestOnBorrow()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(61, "" + this.isTestOnReturn()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(62, "" + this.isTestWhileIdle()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(63, "" + this.getTimeBetweenEvictionRunsMillis()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(64, "" + this.getWhenExhaustedAction()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(79, "" + this.getValidationQuery()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(87, "" + this.isLogAbandoned()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(85, "" + this.isRemoveAbandoned()) + string);
        stringBuffer.append("         " + repositoryTags.getAttribute(86, "" + this.getRemoveAbandonedTimeout()) + string);
        stringBuffer.append("         <!-- ");
        stringBuffer.append(string);
        stringBuffer.append("         Add JDBC-level properties here, like fetchSize.");
        stringBuffer.append("         Attributes with name prefix \"jdbc.\" are passed directly to the JDBC driver.");
        stringBuffer.append(string);
        stringBuffer.append("         e.g. <attribute attribute-name=\"fetchSize\" attribute-value=\"100\"/>");
        stringBuffer.append(string);
        stringBuffer.append("         -->");
        XmlHelper.appendSerializedAttributes(stringBuffer, "         ", this);
        stringBuffer.append("      ").append(repositoryTags.getClosingTagById(65)).append(string);
        return stringBuffer.toString();
    }
}

