/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.states.ModificationState;

class ObjectEnvelopeOrdering {
    private static final int CONCRETE_EDGE_WEIGHT = 3;
    private static final int CONCRETE_EDGE_WEIGHT_WITH_FK = 4;
    private static final int POTENTIAL_EDGE_WEIGHT = 1;
    private static final int POTENTIAL_EDGE_WEIGHT_WITH_FK = 2;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static Logger log = LoggerFactory.getLogger(ObjectEnvelopeOrdering.class);
    private List originalOrder;
    private Map envelopes;
    private Vertex[] vertices;
    private List edgeList;
    private Identity[] newOrder;

    public ObjectEnvelopeOrdering(List list, Map map) {
        this.originalOrder = list;
        this.envelopes = map;
    }

    public void reorder() {
        int n;
        int n2;
        int n3 = 0;
        long l = 0L;
        long l2 = 0L;
        if (log.isDebugEnabled()) {
            l = System.currentTimeMillis();
        }
        this.newOrder = new Identity[this.originalOrder.size()];
        if (log.isDebugEnabled()) {
            log.debug("Orginal order: " + this.originalOrder);
        }
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(this.originalOrder.size());
        Iterator iterator = this.originalOrder.iterator();
        while (iterator.hasNext()) {
            ObjectEnvelope objectEnvelope = (ObjectEnvelope)this.envelopes.get(iterator.next());
            if (objectEnvelope.needsUpdate() || objectEnvelope.needsInsert() || objectEnvelope.needsDelete()) {
                Vertex vertex = new Vertex(objectEnvelope);
                arrayList.add(vertex);
                if (!log.isDebugEnabled()) continue;
                log.debug("Add new Vertex object " + objectEnvelope.getIdentity() + " to VertexList");
                continue;
            }
            this.newOrder[n3++] = objectEnvelope.getIdentity();
            if (!log.isDebugEnabled()) continue;
            log.debug("Add unmodified object " + objectEnvelope.getIdentity() + " to new OrderList");
        }
        this.vertices = arrayList.toArray(new Vertex[arrayList.size()]);
        this.edgeList = new ArrayList(2 * this.vertices.length);
        for (n2 = 0; n2 < this.vertices.length; ++n2) {
            this.addEdgesForVertex(this.vertices[n2]);
        }
        if (log.isDebugEnabled()) {
            l2 = System.currentTimeMillis();
            log.debug("Building object envelope graph took " + (l2 - l) + " ms");
            log.debug("Object envelope graph contains " + this.vertices.length + " vertices" + " and " + this.edgeList.size() + " edges");
        }
        int n4 = 0;
        for (n2 = this.vertices.length; n2 > 0; n2 -= n) {
            Object object;
            ++n4;
            for (Edge edge : this.edgeList) {
                if (edge.isProcessed()) continue;
                if (log.isDebugEnabled()) {
                    object = "Add weight '" + edge.getWeight() + "' for terminal vertex " + edge.getTerminalVertex() + " of edge " + edge;
                    log.debug(object);
                }
                edge.getTerminalVertex().incrementIncomingEdgeWeight(edge.getWeight());
            }
            int n5 = Integer.MAX_VALUE;
            for (n = 0; n < this.vertices.length && (((Vertex)(object = this.vertices[n])).isProcessed() || n5 <= ((Vertex)object).getIncomingEdgeWeight() || (n5 = ((Vertex)object).getIncomingEdgeWeight()) != 0); ++n) {
            }
            n = 0;
            for (int i = 0; i < this.vertices.length; ++i) {
                Vertex vertex = this.vertices[i];
                if (!vertex.isProcessed() && vertex.getIncomingEdgeWeight() == n5) {
                    this.newOrder[n3++] = vertex.getEnvelope().getIdentity();
                    vertex.markProcessed();
                    ++n;
                    if (log.isDebugEnabled()) {
                        log.debug("add minimum edge weight - " + n5 + ", newOrderList: " + ArrayUtils.toString((Object)this.newOrder));
                    }
                }
                vertex.resetIncomingEdgeWeight();
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Processed " + n + " of " + n2 + " remaining vertices in iteration #" + n4);
        }
        if (log.isDebugEnabled()) {
            long l3 = System.currentTimeMillis();
            log.debug("New ordering: " + ArrayUtils.toString((Object)this.newOrder));
            log.debug("Processing object envelope graph took " + (l3 - l2) + " ms");
        }
    }

    public Identity[] getOrdering() {
        if (this.newOrder == null) {
            this.reorder();
        }
        return this.newOrder;
    }

    private void addEdgesForVertex(Vertex vertex) {
        ClassDescriptor classDescriptor = vertex.getEnvelope().getClassDescriptor();
        for (Object object : classDescriptor.getObjectReferenceDescriptors(true)) {
            this.addObjectReferenceEdges(vertex, (ObjectReferenceDescriptor)object);
        }
        for (CollectionDescriptor collectionDescriptor : classDescriptor.getCollectionDescriptors(true)) {
            this.addCollectionEdges(vertex, collectionDescriptor);
        }
    }

    private void addObjectReferenceEdges(Vertex vertex, ObjectReferenceDescriptor objectReferenceDescriptor) {
        Object object = objectReferenceDescriptor.getPersistentField().get(vertex.getEnvelope().getRealObject());
        Class clazz = objectReferenceDescriptor.getItemClass();
        for (int i = 0; i < this.vertices.length; ++i) {
            Edge edge = null;
            Vertex vertex2 = this.vertices[i];
            ObjectEnvelope objectEnvelope = vertex2.getEnvelope();
            if (object == objectEnvelope.getRealObject()) {
                edge = this.buildConcrete11Edge(vertex, vertex2, objectReferenceDescriptor.hasConstraint());
            } else if (clazz.isInstance(vertex2.getEnvelope().getRealObject())) {
                edge = this.buildPotential11Edge(vertex, vertex2, objectReferenceDescriptor.hasConstraint());
            }
            if (edge == null) continue;
            if (!this.edgeList.contains(edge)) {
                this.edgeList.add(edge);
                continue;
            }
            edge.increaseWeightTo(edge.getWeight());
        }
    }

    private void addCollectionEdges(Vertex vertex, CollectionDescriptor collectionDescriptor) {
        ObjectEnvelope objectEnvelope = vertex.getEnvelope();
        Object object = collectionDescriptor.getPersistentField().get(objectEnvelope.getRealObject());
        Object[] objectArray = object == null || ProxyHelper.isCollectionProxy(object) && !ProxyHelper.getCollectionProxy(object).isLoaded() ? EMPTY_OBJECT_ARRAY : BrokerHelper.getCollectionArray(object);
        Class clazz = collectionDescriptor.getItemClass();
        for (int i = 0; i < this.vertices.length; ++i) {
            Edge edge = null;
            Vertex vertex2 = this.vertices[i];
            ObjectEnvelope objectEnvelope2 = vertex2.getEnvelope();
            if (clazz.isInstance(objectEnvelope2.getRealObject())) {
                edge = ObjectEnvelopeOrdering.containsObject(objectEnvelope2.getRealObject(), objectArray) ? (collectionDescriptor.isMtoNRelation() ? this.buildConcreteMNEdge(vertex, vertex2) : this.buildConcrete1NEdge(vertex, vertex2)) : (collectionDescriptor.isMtoNRelation() ? this.buildPotentialMNEdge(vertex, vertex2) : this.buildPotential1NEdge(vertex, vertex2));
            }
            if (edge == null) continue;
            if (!this.edgeList.contains(edge)) {
                this.edgeList.add(edge);
                continue;
            }
            edge.increaseWeightTo(edge.getWeight());
        }
    }

    private static boolean containsObject(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (object != objectArray[i]) continue;
            return true;
        }
        return false;
    }

    protected Edge buildConcrete11Edge(Vertex vertex, Vertex vertex2, boolean bl) {
        ModificationState modificationState = vertex.getEnvelope().getModificationState();
        ModificationState modificationState2 = vertex2.getEnvelope().getModificationState();
        if (modificationState.needsUpdate() || modificationState.needsInsert()) {
            if (modificationState2.needsInsert()) {
                return new Edge(vertex2, vertex, bl ? 4 : 3);
            }
        } else if (modificationState.needsDelete() && modificationState2.needsDelete()) {
            return new Edge(vertex, vertex2, bl ? 4 : 3);
        }
        return null;
    }

    protected Edge buildPotential11Edge(Vertex vertex, Vertex vertex2, boolean bl) {
        ModificationState modificationState = vertex.getEnvelope().getModificationState();
        ModificationState modificationState2 = vertex2.getEnvelope().getModificationState();
        if ((modificationState.needsUpdate() || modificationState.needsDelete()) && modificationState2.needsDelete()) {
            return new Edge(vertex, vertex2, bl ? 2 : 1);
        }
        return null;
    }

    protected Edge buildConcrete1NEdge(Vertex vertex, Vertex vertex2) {
        ModificationState modificationState = vertex.getEnvelope().getModificationState();
        ModificationState modificationState2 = vertex2.getEnvelope().getModificationState();
        if (modificationState.needsInsert()) {
            if (modificationState2.needsUpdate() || modificationState2.needsInsert()) {
                return new Edge(vertex, vertex2, 3);
            }
        } else if (modificationState.needsDelete() && (modificationState2.needsUpdate() || modificationState2.needsDelete())) {
            return new Edge(vertex2, vertex, 3);
        }
        return null;
    }

    protected Edge buildPotential1NEdge(Vertex vertex, Vertex vertex2) {
        ModificationState modificationState = vertex.getEnvelope().getModificationState();
        ModificationState modificationState2 = vertex2.getEnvelope().getModificationState();
        if (modificationState.needsDelete() && (modificationState2.needsUpdate() || modificationState2.needsDelete())) {
            return new Edge(vertex2, vertex, 1);
        }
        return null;
    }

    protected Edge buildConcreteMNEdge(Vertex vertex, Vertex vertex2) {
        ModificationState modificationState = vertex.getEnvelope().getModificationState();
        ModificationState modificationState2 = vertex2.getEnvelope().getModificationState();
        if (modificationState.needsUpdate() || modificationState.needsInsert()) {
            if (modificationState2.needsInsert()) {
                return new Edge(vertex2, vertex, 3);
            }
        } else if (modificationState.needsDelete() && modificationState2.needsDelete()) {
            return new Edge(vertex, vertex2, 1);
        }
        return null;
    }

    protected Edge buildPotentialMNEdge(Vertex vertex, Vertex vertex2) {
        ModificationState modificationState = vertex.getEnvelope().getModificationState();
        ModificationState modificationState2 = vertex2.getEnvelope().getModificationState();
        if ((modificationState.needsUpdate() || modificationState.needsDelete()) && modificationState2.needsDelete()) {
            return new Edge(vertex, vertex2, 1);
        }
        return null;
    }

    private static class Vertex {
        private ObjectEnvelope envelope;
        private boolean processed;
        private int incomingEdgeWeight;

        public Vertex(ObjectEnvelope objectEnvelope) {
            this.envelope = objectEnvelope;
            this.incomingEdgeWeight = 0;
            this.processed = false;
        }

        public ObjectEnvelope getEnvelope() {
            return this.envelope;
        }

        public void markProcessed() {
            this.processed = true;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void resetIncomingEdgeWeight() {
            this.incomingEdgeWeight = 0;
        }

        public void incrementIncomingEdgeWeight(int n) {
            this.incomingEdgeWeight += n;
        }

        public int getIncomingEdgeWeight() {
            return this.incomingEdgeWeight;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("identity", (Object)this.envelope.getIdentity()).append("processed", this.processed).append("incomingEdgeWeight", this.incomingEdgeWeight).toString();
        }
    }

    private static class Edge {
        private Vertex initial;
        private Vertex terminal;
        private Identity initialIdentity;
        private Identity terminalIdentity;
        private int weight;
        private boolean knownToBeProcessed;
        private int hashCode;

        public Edge(Vertex vertex, Vertex vertex2, int n) {
            this.initial = vertex;
            this.terminal = vertex2;
            this.initialIdentity = vertex.getEnvelope().getIdentity();
            this.terminalIdentity = vertex2.getEnvelope().getIdentity();
            this.weight = n;
            this.knownToBeProcessed = false;
            this.hashCode = this.initialIdentity.hashCode() + 13 * this.terminalIdentity.hashCode();
        }

        public Vertex getInitialVertex() {
            return this.initial;
        }

        public Vertex getTerminalVertex() {
            return this.terminal;
        }

        public boolean connects(Vertex vertex) {
            return this.initial == vertex || this.terminal == vertex;
        }

        public void increaseWeightTo(int n) {
            if (this.weight < n) {
                this.weight = n;
            }
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean isProcessed() {
            boolean bl;
            if (this.knownToBeProcessed) {
                return true;
            }
            boolean bl2 = bl = this.initial.isProcessed() || this.terminal.isProcessed();
            if (bl) {
                this.knownToBeProcessed = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof Edge) {
                Edge edge = (Edge)object;
                return this.initialIdentity.equals(edge.initialIdentity) && this.terminalIdentity.equals(edge.terminalIdentity);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("initial", (Object)this.initialIdentity).append("terminal", (Object)this.terminalIdentity).append("weight", this.weight).append("processed", this.knownToBeProcessed).toString();
        }
    }
}

