/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.transaction;

import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.transaction.TransactionCommitAction;
import com.terracottatech.frs.transaction.TransactionHandle;
import com.terracottatech.frs.transaction.TransactionHandleImpl;
import com.terracottatech.frs.transaction.TransactionLSNCallback;
import com.terracottatech.frs.transaction.TransactionManager;
import com.terracottatech.frs.transaction.TransactionalAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionManagerImpl
implements TransactionManager {
    private final AtomicLong currentTransactionId = new AtomicLong();
    private final Map<TransactionHandle, TransactionAccount> liveTransactions = new ConcurrentHashMap<TransactionHandle, TransactionAccount>();
    private final ActionManager actionManager;

    public TransactionManagerImpl(ActionManager actionManager) {
        this.actionManager = actionManager;
    }

    @Override
    public TransactionHandle begin() {
        TransactionHandleImpl handle = new TransactionHandleImpl(this.currentTransactionId.incrementAndGet());
        TransactionAccount account = new TransactionAccount();
        this.liveTransactions.put(handle, account);
        return handle;
    }

    @Override
    public void commit(TransactionHandle handle, boolean synchronous) throws TransactionException {
        TransactionAccount account = this.liveTransactions.remove(handle);
        if (account == null) {
            throw new IllegalArgumentException(handle + " does not belong to a live transaction.");
        }
        TransactionCommitAction action = new TransactionCommitAction(handle, account.begin());
        if (synchronous) {
            Future<Void> written = this.actionManager.syncHappened(action);
            boolean interrupted = false;
            while (true) {
                try {
                    written.get();
                }
                catch (ExecutionException e) {
                    throw new TransactionException("Commit failed.", e);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.actionManager.happened(action);
        }
    }

    @Override
    public void happened(TransactionHandle handle, Action action) {
        TransactionAccount account = this.liveTransactions.get(handle);
        if (account == null) {
            throw new IllegalArgumentException(handle + " does not belong to a live transaction.");
        }
        TransactionalAction transactionalAction = new TransactionalAction(handle, account.begin(), false, action, account);
        this.actionManager.happened(transactionalAction);
    }

    @Override
    public long getLowestOpenTransactionLsn() {
        Long lowest = Long.MAX_VALUE;
        for (TransactionAccount account : this.liveTransactions.values()) {
            lowest = Math.min(account.lsn, lowest);
        }
        return lowest;
    }

    private static class TransactionAccount
    implements TransactionLSNCallback {
        private long lsn = Long.MAX_VALUE;
        private boolean beginWritten = false;

        private TransactionAccount() {
        }

        synchronized boolean begin() {
            if (this.beginWritten) {
                return false;
            }
            this.beginWritten = true;
            return true;
        }

        @Override
        public synchronized void setLsn(long lsn) {
            if (this.lsn == Long.MAX_VALUE) {
                this.lsn = lsn;
            } else assert (lsn > this.lsn);
        }
    }
}

