/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.document.service;

import com.codiform.moo.Moo;
import com.codiform.moo.configuration.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.UnknownDocumentIdException;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="commonApiService")
public class CommonApiServiceImpl
implements CommonApiService {
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="auditHelper")
    private AuditHelper auditHelper;

    @Override
    public void validatePerson(String personId, Integer rolodexId) {
        Entity personEntity = null;
        RolodexContract rolodex = null;
        if (personId != null) {
            personEntity = this.getIdentityService().getEntityByPrincipalId(personId);
        } else {
            rolodex = this.getRolodexService().getRolodex(rolodexId);
        }
        if (rolodex == null && personEntity == null) {
            throw new UnprocessableEntityException("Invalid person or rolodex for person " + (personId != null ? personId : rolodexId.toString()));
        }
    }

    @Override
    public void clearErrors() {
        this.getGlobalVariableService().getMessageMap().clearErrorMessages();
    }

    @Override
    public <T> T convertObject(Object input, Class<T> clazz) {
        Configuration mooConfig = new Configuration();
        mooConfig.setSourcePropertiesRequired(false);
        Moo moo = new Moo(mooConfig);
        T newDataObject = this.getNewDataObject(clazz);
        moo.update(input, newDataObject);
        return newDataObject;
    }

    public <T> T getNewDataObject(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("cannot create new data object", e);
        }
    }

    @Override
    public <T> T getDocumentFromDocId(String documentNumber, Class<T> clazz) {
        try {
            Document document = this.getDocumentService().getByDocumentHeaderId(documentNumber);
            if (document == null || !clazz.isAssignableFrom(document.getClass())) {
                throw new ResourceNotFoundException("Could not locate " + clazz.getSimpleName() + " with document number " + documentNumber);
            }
            return (T)document;
        }
        catch (WorkflowException | UnknownDocumentIdException exception) {
            throw new ResourceNotFoundException("Could not locate " + clazz.getSimpleName() + " with document number " + documentNumber);
        }
    }

    @Override
    public void routeDocument(Document document) {
        List<ErrorMessage> auditErrors = this.getAuditErrors(document);
        StringBuilder errorMessage = new StringBuilder("");
        for (ErrorMessage error : auditErrors) {
            errorMessage.append(KRADUtils.getMessageText((ErrorMessage)error, (boolean)false));
        }
        if (!errorMessage.toString().equalsIgnoreCase("")) {
            throw new UnprocessableEntityException(errorMessage.toString());
        }
        try {
            this.getDocumentService().routeDocument(document, "", new ArrayList());
        }
        catch (WorkflowException | ValidationException e) {
            throw new UnprocessableEntityException(this.getValidationErrors(), e);
        }
    }

    @Override
    public List<ErrorMessage> getAuditErrors(Document document) {
        boolean auditPassed = this.getAuditHelper().auditUnconditionally(document);
        ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
        if (!auditPassed) {
            Map<String, AuditCluster> auditErrorMap = this.getGlobalVariableService().getAuditErrorMap();
            for (String key : auditErrorMap.keySet()) {
                AuditCluster auditCluster = auditErrorMap.get(key);
                if (StringUtils.equalsIgnoreCase((CharSequence)auditCluster.getCategory(), (CharSequence)"Warnings")) continue;
                List auditErrors = auditCluster.getAuditErrorList();
                for (AuditError auditError : auditErrors) {
                    ErrorMessage errorMessage = new ErrorMessage();
                    errorMessage.setErrorKey(auditError.getMessageKey());
                    errorMessage.setMessageParameters(auditError.getParams());
                    errors.add(errorMessage);
                }
            }
        }
        return errors;
    }

    @Override
    public String getValidationErrors() {
        StringBuilder errors = new StringBuilder();
        for (Map.Entry entry : this.getGlobalVariableService().getMessageMap().getErrorMessages().entrySet()) {
            for (ErrorMessage msg : (List)entry.getValue()) {
                errors.append(KRADUtils.getMessageText((ErrorMessage)msg, (boolean)false));
            }
        }
        return errors.toString();
    }

    @Override
    public Document saveDocument(Document document) {
        try {
            document.validateBusinessRules((DocumentEvent)new SaveDocumentEvent("", document));
            document = this.getDocumentService().saveDocument(document);
        }
        catch (ValidationException e) {
            String errors = this.getValidationErrors() + " " + e.getMessage();
            throw new UnprocessableEntityException(errors, e);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        return document;
    }

    @Override
    public void updateDataObjectFromDto(Object existingDataObject, Object input) {
        Configuration mooConfig = new Configuration();
        mooConfig.setSourcePropertiesRequired(false);
        Moo moo = new Moo(mooConfig);
        moo.update(input, existingDataObject);
    }

    @Override
    public boolean isDocInModifiableState(WorkflowDocument workflowDocument) {
        return !workflowDocument.isCanceled();
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public AuditHelper getAuditHelper() {
        return this.auditHelper;
    }
}

