/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.GrowlMessage;
import org.kuali.rice.krad.util.MessageMap;

public class LifecycleBase
implements Serializable {
    private static final long serialVersionUID = 9150578453981086356L;

    public static void performPostLifecycleProcessing(View view, Object model, ViewPostMetadata viewPostMetadata) {
        String growlScript = LifecycleBase.buildGrowlScript(view.isGrowlMessagingEnabled());
        ((ViewModel)model).setGrowlScript(growlScript);
    }

    protected static String buildGrowlScript(boolean growlMessagingEnabled) {
        StringBuilder growlScript = new StringBuilder();
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        MessageMap messageMap = GlobalVariables.getMessageMap();
        for (GrowlMessage growl : messageMap.getGrowlMessages()) {
            if (growlMessagingEnabled) {
                String message = messageService.getMessageText(growl.getNamespaceCode(), growl.getComponentCode(), growl.getMessageKey());
                if (StringUtils.isBlank((String)message)) continue;
                if (growl.getMessageParameters() != null) {
                    message = message.replace("'", "''");
                    message = MessageFormat.format(message, growl.getMessageParameters());
                }
                message = message.replace("'", "\\'");
                String title = growl.getTitle();
                if (StringUtils.isNotBlank((String)growl.getTitleKey())) {
                    title = messageService.getMessageText(growl.getNamespaceCode(), growl.getComponentCode(), growl.getTitleKey());
                }
                title = title.replace("'", "\\'");
                growlScript.append(ScriptUtils.buildFunctionCall("showGrowl", message, title, growl.getTheme()));
                continue;
            }
            ErrorMessage infoMessage = new ErrorMessage(growl.getMessageKey(), growl.getMessageParameters());
            infoMessage.setNamespaceCode(growl.getNamespaceCode());
            infoMessage.setComponentCode(growl.getComponentCode());
            messageMap.putInfoForSectionId("GLOBAL_INFO", infoMessage);
        }
        return growlScript.toString();
    }
}

