/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.BaseFuture;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.core.TimeValue;

public abstract class AdapterActionFuture<T, L>
extends BaseFuture<T>
implements ActionFuture<T>,
ActionListener<L> {
    @Override
    public T actionGet() {
        try {
            return FutureUtils.get(this);
        }
        catch (ElasticsearchException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    @Override
    public T actionGet(String timeout) {
        return this.actionGet(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".actionGet.timeout")));
    }

    @Override
    public T actionGet(long timeoutMillis) {
        return this.actionGet(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(TimeValue timeout) {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout, TimeUnit unit) {
        try {
            return FutureUtils.get(this, timeout, unit);
        }
        catch (ElasticsearchException e) {
            throw AdapterActionFuture.unwrapEsException(e);
        }
    }

    @Override
    public void onResponse(L result) {
        this.set(this.convert(result));
    }

    @Override
    public void onFailure(Exception e) {
        this.setException(e);
    }

    protected abstract T convert(L var1);

    private static RuntimeException unwrapEsException(ElasticsearchException esEx) {
        Throwable root = esEx.unwrapCause();
        if (root instanceof RuntimeException) {
            return (RuntimeException)root;
        }
        return new UncategorizedExecutionException("Failed execution", root);
    }
}

