/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.uif;

import java.util.ArrayList;
import org.kuali.rice.core.api.uif.KeyLabeled;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableControlContract;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotablePasswordInput;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableSelectGroup;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.core.api.uif.RowsCols;
import org.kuali.rice.core.api.uif.Sized;
import org.kuali.rice.core.api.uif.Watermarked;

final class ControlCopy {
    private ControlCopy() {
        throw new IllegalArgumentException("do not call.");
    }

    public static RemotableAbstractControl.Builder toBuilder(RemotableControlContract c) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (c instanceof RemotableCheckbox || c instanceof RemotableCheckbox.Builder) {
            return RemotableCheckbox.Builder.create();
        }
        if (c instanceof RemotableCheckboxGroup || c instanceof RemotableCheckboxGroup.Builder) {
            return RemotableCheckboxGroup.Builder.create(((KeyLabeled)((Object)c)).getKeyLabels());
        }
        if (c instanceof RemotableHiddenInput || c instanceof RemotableHiddenInput.Builder) {
            return RemotableHiddenInput.Builder.create();
        }
        if (c instanceof RemotablePasswordInput || c instanceof RemotablePasswordInput.Builder) {
            RemotablePasswordInput.Builder b = RemotablePasswordInput.Builder.create();
            b.setSize(((Sized)((Object)c)).getSize());
            return b;
        }
        if (c instanceof RemotableRadioButtonGroup || c instanceof RemotableRadioButtonGroup.Builder) {
            return RemotableRadioButtonGroup.Builder.create(((KeyLabeled)((Object)c)).getKeyLabels());
        }
        if (c instanceof RemotableSelect) {
            RemotableSelect sc = (RemotableSelect)c;
            RemotableSelect.Builder b = RemotableSelect.Builder.create(sc.getKeyLabels());
            ArrayList<RemotableSelectGroup.Builder> temp = new ArrayList<RemotableSelectGroup.Builder>();
            if (sc.getGroups() != null) {
                for (RemotableSelectGroup attr : sc.getGroups()) {
                    temp.add(RemotableSelectGroup.Builder.create(attr.getKeyLabels(), attr.getLabel()));
                }
            }
            b.setGroups(temp);
            b.setSize(sc.getSize());
            b.setMultiple(sc.isMultiple());
            return b;
        }
        if (c instanceof RemotableSelect.Builder) {
            RemotableSelect.Builder sc = (RemotableSelect.Builder)c;
            RemotableSelect.Builder b = RemotableSelect.Builder.create(sc.getKeyLabels());
            b.setGroups(sc.getGroups());
            b.setSize(sc.getSize());
            b.setMultiple(sc.isMultiple());
            return b;
        }
        if (c instanceof RemotableTextarea || c instanceof RemotableTextarea.Builder) {
            RemotableTextarea.Builder b = RemotableTextarea.Builder.create();
            b.setWatermark(((Watermarked)((Object)c)).getWatermark());
            b.setCols(((RowsCols)((Object)c)).getCols());
            b.setRows(((RowsCols)((Object)c)).getRows());
            return b;
        }
        if (c instanceof RemotableTextInput || c instanceof RemotableTextInput.Builder) {
            RemotableTextInput.Builder b = RemotableTextInput.Builder.create();
            b.setWatermark(((Watermarked)((Object)c)).getWatermark());
            b.setSize(((Sized)((Object)c)).getSize());
            return b;
        }
        throw new UnsupportedOperationException(c.getClass().getName() + " not supported");
    }
}

